/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.vp;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformAWTBehavior;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class OrbitBehavior
extends ViewPlatformAWTBehavior {
    private Transform3D velocityTransform;
    private Transform3D longditudeTransform;
    private Transform3D rollTransform;
    private Transform3D latitudeTransform;
    private Transform3D rotateTransform = new Transform3D();
    private Transform3D temp1 = new Transform3D();
    private Transform3D temp2 = new Transform3D();
    private Transform3D translation = new Transform3D();
    private Vector3d transVector = new Vector3d();
    private Vector3d distanceVector = new Vector3d();
    private Vector3d centerVector = new Vector3d();
    private Vector3d invertCenterVector = new Vector3d();
    private double longditude = 0.0;
    private double latitude = 0.0;
    private double rollAngle = 0.0;
    private double distanceFromCenter = 20.0;
    private final double MAX_MOUSE_ANGLE = Math.toRadians(3.0);
    private final double ZOOM_FACTOR = 1.0;
    private Point3d rotationCenter = new Point3d();
    private Vector3d centerToView = new Vector3d();
    private Matrix3d rotMatrix = new Matrix3d();
    private Vector3d oldPos = new Vector3d();
    private Vector3d currentPos = new Vector3d();
    private int mouseX = 0;
    private int mouseY = 0;
    private Canvas3D canvas;
    private double rotXMul;
    private double rotYMul;
    private double transXMul;
    private double transYMul;
    private double zoomMul;
    private double rotXFactor = 1.0;
    private double rotYFactor = 1.0;
    private double transXFactor = 1.0;
    private double transYFactor = 1.0;
    private double zoomFactor = 1.0;
    private double xtrans = 0.0;
    private double ytrans = 0.0;
    private boolean zoomEnabled = true;
    private boolean rotateEnabled = true;
    private boolean translateEnabled = true;
    private boolean reverseRotate = false;
    private boolean reverseTrans = false;
    private boolean reverseZoom = false;
    private boolean stopZoom = false;
    private boolean proportionalZoom = false;
    private double minRadius = 0.0;
    private int leftButton = 0;
    private int rightButton = 1;
    private int middleButton = 2;
    public static final int REVERSE_ROTATE = 16;
    public static final int REVERSE_TRANSLATE = 32;
    public static final int REVERSE_ZOOM = 64;
    public static final int REVERSE_ALL = 112;
    public static final int STOP_ZOOM = 256;
    public static final int DISABLE_ROTATE = 512;
    public static final int DISABLE_TRANSLATE = 1024;
    public static final int DISABLE_ZOOM = 2048;
    public static final int PROPORTIONAL_ZOOM = 4096;
    private static final int ROTATE = 0;
    private static final int TRANSLATE = 1;
    private static final int ZOOM = 2;
    private static final double NOMINAL_ZOOM_FACTOR = 0.01;
    private static final double NOMINAL_PZOOM_FACTOR = 1.0;
    private static final double NOMINAL_ROT_FACTOR = 0.01;
    private static final double NOMINAL_TRANS_FACTOR = 0.01;

    public OrbitBehavior(Canvas3D canvas3D) {
        this(canvas3D, 0);
    }

    public OrbitBehavior(Canvas3D canvas3D, int n) {
        super(canvas3D, 3 | n);
        this.canvas = canvas3D;
        if ((n & 0x200) != 0) {
            this.rotateEnabled = false;
        }
        if ((n & 0x800) != 0) {
            this.zoomEnabled = false;
        }
        if ((n & 0x400) != 0) {
            this.translateEnabled = false;
        }
        if ((n & 0x20) != 0) {
            this.reverseTrans = true;
        }
        if ((n & 0x10) != 0) {
            this.reverseRotate = true;
        }
        if ((n & 0x40) != 0) {
            this.reverseZoom = true;
        }
        if ((n & 0x100) != 0) {
            this.stopZoom = true;
        }
        if ((n & 0x1000) != 0) {
            this.proportionalZoom = true;
        }
        this.rotXMul = 0.01 * this.rotXFactor;
        this.rotYMul = 0.01 * this.rotYFactor;
        this.transXMul = 0.01 * this.transXFactor;
        this.transYMul = 0.01 * this.transYFactor;
        this.zoomMul = this.proportionalZoom ? 1.0 * this.zoomFactor : 0.01 * this.zoomFactor;
        this.rollTransform = new Transform3D();
        this.latitudeTransform = new Transform3D();
        this.longditudeTransform = new Transform3D();
        this.targetTransform = new Transform3D();
        this.velocityTransform = new Transform3D();
    }

    protected synchronized void processAWTEvents(AWTEvent[] aWTEventArray) {
        this.motion = false;
        int n = 0;
        while (n < aWTEventArray.length) {
            if (aWTEventArray[n] instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)aWTEventArray[n]);
            }
            ++n;
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.motion = true;
        } else if (mouseEvent.getID() == 506) {
            int n = mouseEvent.getX() - this.mouseX;
            int n2 = mouseEvent.getY() - this.mouseY;
            if (this.rotate(mouseEvent)) {
                if (this.reverseRotate) {
                    this.longditude -= (double)n * this.rotXMul;
                    this.latitude -= (double)n2 * this.rotYMul;
                } else {
                    this.longditude += (double)n * this.rotXMul;
                    this.latitude += (double)n2 * this.rotYMul;
                }
            } else if (this.translate(mouseEvent)) {
                if (this.reverseTrans) {
                    this.xtrans -= (double)n * this.transXMul;
                    this.ytrans += (double)n2 * this.transYMul;
                } else {
                    this.xtrans += (double)n * this.transXMul;
                    this.ytrans -= (double)n2 * this.transYMul;
                }
            } else if (this.zoom(mouseEvent)) {
                this.distanceFromCenter = this.proportionalZoom ? (this.reverseZoom ? (this.distanceFromCenter - this.zoomMul * (double)n2 * this.distanceFromCenter / 100.0 > this.minRadius ? (this.distanceFromCenter -= this.zoomMul * (double)n2 * this.distanceFromCenter / 100.0) : this.minRadius) : (this.distanceFromCenter + this.zoomMul * (double)n2 * this.distanceFromCenter / 100.0 > this.minRadius ? (this.distanceFromCenter += this.zoomMul * (double)n2 * this.distanceFromCenter / 100.0) : this.minRadius)) : (this.stopZoom ? (this.reverseZoom ? (this.distanceFromCenter - (double)n2 * this.zoomMul > this.minRadius ? (this.distanceFromCenter -= (double)n2 * this.zoomMul) : this.minRadius) : (this.distanceFromCenter + (double)n2 * this.zoomMul > this.minRadius ? (this.distanceFromCenter += (double)n2 * this.zoomMul) : this.minRadius)) : (this.reverseZoom ? (this.distanceFromCenter -= (double)n2 * this.zoomMul) : (this.distanceFromCenter += (double)n2 * this.zoomMul)));
            }
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.motion = true;
        } else if (mouseEvent.getID() == 502) {
            // empty if block
        }
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        super.setViewingPlatform(viewingPlatform);
        if (viewingPlatform != null) {
            this.resetViewPosition();
            this.integrateTransforms();
        }
    }

    private void resetViewPosition() {
        this.targetTG.getTransform(this.targetTransform);
        this.targetTransform.get(this.rotMatrix, this.transVector);
        this.centerToView.sub((Tuple3d)this.transVector, (Tuple3d)this.rotationCenter);
        this.distanceFromCenter = this.centerToView.length();
        this.targetTransform.get(this.rotMatrix);
        this.rotateTransform.set(this.rotMatrix);
    }

    protected synchronized void integrateTransforms() {
        this.targetTransform.get(this.oldPos);
        this.targetTG.getTransform(this.targetTransform);
        this.targetTransform.get(this.currentPos);
        if (!this.currentPos.equals((Tuple3d)this.oldPos)) {
            this.resetViewPosition();
        }
        this.longditudeTransform.rotY(this.longditude);
        this.latitudeTransform.rotX(this.latitude);
        this.rotateTransform.mul(this.rotateTransform, this.latitudeTransform);
        this.rotateTransform.mul(this.rotateTransform, this.longditudeTransform);
        this.distanceVector.z = this.distanceFromCenter;
        this.temp1.set(this.distanceVector);
        this.temp1.mul(this.rotateTransform, this.temp1);
        this.transVector.x = this.rotationCenter.x + this.xtrans;
        this.transVector.y = this.rotationCenter.y + this.ytrans;
        this.transVector.z = this.rotationCenter.z;
        this.translation.set(this.transVector);
        this.targetTransform.mul(this.temp1, this.translation);
        this.temp1.set(this.centerVector);
        this.temp1.mul(this.targetTransform);
        this.invertCenterVector.x = -this.centerVector.x;
        this.invertCenterVector.y = -this.centerVector.y;
        this.invertCenterVector.z = -this.centerVector.z;
        this.temp2.set(this.invertCenterVector);
        this.targetTransform.mul(this.temp1, this.temp2);
        this.targetTG.setTransform(this.targetTransform);
        this.longditude = 0.0;
        this.latitude = 0.0;
    }

    public synchronized void setRotationCenter(Point3d point3d) {
        this.rotationCenter.x = point3d.x;
        this.rotationCenter.y = point3d.y;
        this.rotationCenter.z = point3d.z;
        this.centerVector.set((Tuple3d)this.rotationCenter);
    }

    public void getRotationCenter(Point3d point3d) {
        point3d.x = this.rotationCenter.x;
        point3d.y = this.rotationCenter.y;
        point3d.z = this.rotationCenter.z;
    }

    public synchronized void setRotFactors(double d, double d2) {
        this.rotXFactor = d;
        this.rotYFactor = d2;
        this.rotXMul = 0.01 * d;
        this.rotYMul = 0.01 * d2;
    }

    public synchronized void setRotXFactor(double d) {
        this.rotXFactor = d;
        this.rotXMul = 0.01 * d;
    }

    public synchronized void setRotYFactor(double d) {
        this.rotYFactor = d;
        this.rotYMul = 0.01 * d;
    }

    public synchronized void setTransFactors(double d, double d2) {
        this.transXFactor = d;
        this.transYFactor = d2;
        this.transXMul = 0.01 * d;
        this.transYMul = 0.01 * d2;
    }

    public synchronized void setTransXFactor(double d) {
        this.transXFactor = d;
        this.transXMul = 0.01 * d;
    }

    public synchronized void setTransYFactor(double d) {
        this.transYFactor = d;
        this.transYMul = 0.01 * d;
    }

    public synchronized void setZoomFactor(double d) {
        this.zoomFactor = d;
        this.zoomMul = this.proportionalZoom ? 1.0 * d : 0.01 * d;
    }

    public double getRotXFactor() {
        return this.rotXFactor;
    }

    public double getRotYFactor() {
        return this.rotYFactor;
    }

    public double getTransXFactor() {
        return this.transXFactor;
    }

    public double getTransYFactor() {
        return this.transYFactor;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public synchronized void setRotateEnable(boolean bl) {
        this.rotateEnabled = bl;
    }

    public synchronized void setZoomEnable(boolean bl) {
        this.zoomEnabled = bl;
    }

    public synchronized void setTranslateEnable(boolean bl) {
        this.translateEnabled = bl;
    }

    public boolean getRotateEnable() {
        return this.rotateEnabled;
    }

    public boolean getZoomEnable() {
        return this.zoomEnabled;
    }

    public boolean getTranslateEnable() {
        return this.translateEnabled;
    }

    boolean rotate(MouseEvent mouseEvent) {
        if (this.rotateEnabled) {
            if (this.leftButton == 0 && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
                return true;
            }
            if (this.middleButton == 0 && mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
                return true;
            }
            if (this.rightButton == 0 && !mouseEvent.isAltDown() && mouseEvent.isMetaDown()) {
                return true;
            }
        }
        return false;
    }

    boolean zoom(MouseEvent mouseEvent) {
        if (this.zoomEnabled) {
            if (this.leftButton == 2 && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
                return true;
            }
            if (this.middleButton == 2 && mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
                return true;
            }
            if (this.rightButton == 2 && !mouseEvent.isAltDown() && mouseEvent.isMetaDown()) {
                return true;
            }
        }
        return false;
    }

    boolean translate(MouseEvent mouseEvent) {
        if (this.translateEnabled) {
            if (this.leftButton == 1 && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
                return true;
            }
            if (this.middleButton == 1 && mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
                return true;
            }
            if (this.rightButton == 1 && !mouseEvent.isAltDown() && mouseEvent.isMetaDown()) {
                return true;
            }
        }
        return false;
    }

    public synchronized void setMinRadius(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("OrbitBehavior1"));
        }
        this.minRadius = d;
    }

    public double getMinRadius() {
        return this.minRadius;
    }
}

