/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Vector3d;

public class MouseTranslate
extends MouseBehavior {
    double x_factor = 0.02;
    double y_factor = 0.02;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;

    public MouseTranslate(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseTranslate() {
        super(0);
    }

    public MouseTranslate(int n) {
        super(n);
    }

    public MouseTranslate(Component component) {
        super(component, 0);
    }

    public MouseTranslate(Component component, TransformGroup transformGroup) {
        super(component, transformGroup);
    }

    public MouseTranslate(Component component, int n) {
        super(component, n);
    }

    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void setFactor(double d) {
        this.x_factor = this.y_factor = d;
    }

    public void setFactor(double d, double d2) {
        this.x_factor = d;
        this.y_factor = d2;
    }

    public void processStimulus(Enumeration enumeration) {
        block3: while (enumeration.hasMoreElements()) {
            MouseEvent mouseEvent;
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (wakeupCriterion instanceof WakeupOnAWTEvent) {
                AWTEvent[] aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent();
                if (aWTEventArray.length <= 0) continue;
                mouseEvent = (MouseEvent)aWTEventArray[aWTEventArray.length - 1];
                this.doProcess(mouseEvent);
                continue;
            }
            if (!(wakeupCriterion instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    mouseEvent = (MouseEvent)this.mouseq.remove(0);
                    while (mouseEvent.getID() == 506 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 506) {
                        mouseEvent = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(mouseEvent);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    void doProcess(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
        if (this.buttonPress && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0) {
            int n = mouseEvent.getID();
            if (n == 506 && !mouseEvent.isAltDown() && mouseEvent.isMetaDown()) {
                this.x = mouseEvent.getX();
                this.y = mouseEvent.getY();
                int n2 = this.x - this.x_last;
                int n3 = this.y - this.y_last;
                if (!this.reset && Math.abs(n3) < 50 && Math.abs(n2) < 50) {
                    this.transformGroup.getTransform(this.currXform);
                    this.translation.x = (double)n2 * this.x_factor;
                    this.translation.y = (double)(-n3) * this.y_factor;
                    this.transformX.set(this.translation);
                    if (this.invert) {
                        this.currXform.mul(this.currXform, this.transformX);
                    } else {
                        this.currXform.mul(this.transformX, this.currXform);
                    }
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(1, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (n == 501) {
                this.x_last = mouseEvent.getX();
                this.y_last = mouseEvent.getY();
            }
        }
    }

    public void transformChanged(Transform3D transform3D) {
    }

    public void setupCallback(MouseBehaviorCallback mouseBehaviorCallback) {
        this.callback = mouseBehaviorCallback;
    }
}

