/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.mouse;

import com.sun.j3d.internal.J3dUtilsI18N;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOr;

public abstract class MouseBehavior
extends Behavior
implements MouseListener,
MouseMotionListener {
    private boolean listener = false;
    protected WakeupCriterion[] mouseEvents;
    protected WakeupOr mouseCriterion;
    protected int x;
    protected int y;
    protected int x_last;
    protected int y_last;
    protected TransformGroup transformGroup;
    protected Transform3D transformX;
    protected Transform3D transformY;
    protected Transform3D currXform;
    protected boolean buttonPress = false;
    protected boolean reset = false;
    protected boolean invert = false;
    protected boolean wakeUp = false;
    protected int flags = 0;
    protected LinkedList mouseq;
    public static final int MANUAL_WAKEUP = 1;
    public static final int INVERT_INPUT = 2;

    public MouseBehavior(TransformGroup transformGroup) {
        this.transformGroup = transformGroup;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public MouseBehavior(int n) {
        this.flags = n;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public MouseBehavior(Component component, TransformGroup transformGroup) {
        this(transformGroup);
        if (component != null) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }
        this.listener = true;
    }

    public MouseBehavior(Component component, int n) {
        this(n);
        if (component != null) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }
        this.listener = true;
    }

    public void setTransformGroup(TransformGroup transformGroup) {
        this.transformGroup = transformGroup;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public TransformGroup getTransformGroup() {
        return this.transformGroup;
    }

    public void initialize() {
        this.mouseEvents = new WakeupCriterion[3];
        if (!this.listener) {
            this.mouseEvents[0] = new WakeupOnAWTEvent(506);
            this.mouseEvents[1] = new WakeupOnAWTEvent(501);
            this.mouseEvents[2] = new WakeupOnAWTEvent(502);
        } else {
            this.mouseEvents[0] = new WakeupOnBehaviorPost((Behavior)this, 506);
            this.mouseEvents[1] = new WakeupOnBehaviorPost((Behavior)this, 501);
            this.mouseEvents[2] = new WakeupOnBehaviorPost((Behavior)this, 502);
            this.mouseq = new LinkedList();
        }
        this.mouseCriterion = new WakeupOr(this.mouseEvents);
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
        this.x = 0;
        this.y = 0;
        this.x_last = 0;
        this.y_last = 0;
    }

    public void wakeup() {
        this.wakeUp = true;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.buttonPress = true;
            return;
        }
        if (mouseEvent.getID() == 502) {
            this.buttonPress = false;
            this.wakeUp = false;
        } else if (mouseEvent.getID() == 503) {
            // empty if block
        }
    }

    public abstract void processStimulus(Enumeration var1);

    public void addListener(Component component) {
        if (!this.listener) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Behavior0"));
        }
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        LinkedList linkedList = this.mouseq;
        synchronized (linkedList) {
            this.mouseq.add(mouseEvent);
            if (this.mouseq.size() == 1) {
                this.postId(501);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        LinkedList linkedList = this.mouseq;
        synchronized (linkedList) {
            this.mouseq.add(mouseEvent);
            if (this.mouseq.size() == 1) {
                this.postId(502);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        LinkedList linkedList = this.mouseq;
        synchronized (linkedList) {
            this.mouseq.add(mouseEvent);
            if (this.mouseq.size() == 1) {
                this.postId(506);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

