/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;

public abstract class KBSplinePathInterpolator
extends Interpolator {
    private int keysLength;
    protected KBKeyFrame[] keyFrames;
    protected float currentU;
    protected int lowerKnot;
    protected int upperKnot;

    KBSplinePathInterpolator() {
    }

    public KBSplinePathInterpolator(Alpha alpha, KBKeyFrame[] kBKeyFrameArray) {
        super(alpha);
        this.keysLength = kBKeyFrameArray.length;
        if (this.keysLength < 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator0"));
        }
        if ((double)kBKeyFrameArray[0].knot < -1.0E-4 || (double)kBKeyFrameArray[0].knot > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator1"));
        }
        if ((double)kBKeyFrameArray[this.keysLength - 1].knot - 1.0 < -1.0E-4 || (double)kBKeyFrameArray[this.keysLength - 1].knot - 1.0 > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator2"));
        }
        int n = 0;
        while (n < this.keysLength) {
            if (n > 0 && kBKeyFrameArray[n].knot < kBKeyFrameArray[n - 1].knot) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator3"));
            }
            ++n;
        }
        this.keyFrames = new KBKeyFrame[this.keysLength + 2];
        this.keyFrames[0] = new KBKeyFrame();
        this.keyFrames[0] = kBKeyFrameArray[0];
        int n2 = 1;
        while (n2 < this.keysLength + 1) {
            this.keyFrames[n2] = kBKeyFrameArray[n2 - 1];
            ++n2;
        }
        this.keyFrames[this.keysLength + 1] = new KBKeyFrame();
        this.keyFrames[this.keysLength + 1] = kBKeyFrameArray[this.keysLength - 1];
        this.keysLength += 2;
    }

    public int getArrayLength() {
        return this.keysLength;
    }

    public KBKeyFrame getKeyFrame(int n) {
        return this.keyFrames[n + 1];
    }

    protected void computePathInterpolation() {
        float f = this.getAlpha().value();
        int n = 1;
        int n2 = this.keysLength - 2;
        while (f > this.keyFrames[n].knot && n < n2) {
            ++n;
        }
        if (n == 1) {
            this.currentU = 0.0f;
            this.lowerKnot = 1;
            this.upperKnot = 2;
        } else {
            this.currentU = (f - this.keyFrames[n - 1].knot) / (this.keyFrames[n].knot - this.keyFrames[n - 1].knot);
            this.lowerKnot = n - 1;
            this.upperKnot = n;
        }
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        KBSplinePathInterpolator kBSplinePathInterpolator = (KBSplinePathInterpolator)node;
        this.setAlpha(kBSplinePathInterpolator.getAlpha());
        this.keysLength = kBSplinePathInterpolator.keysLength;
        this.keyFrames = new KBKeyFrame[this.keysLength];
        System.arraycopy(kBSplinePathInterpolator.keyFrames, 0, this.keyFrames, 0, this.keysLength);
    }
}

