/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.utils.behaviors.interpolators.KBCubicSplineCurve;
import com.sun.j3d.utils.behaviors.interpolators.KBCubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.KBSplinePathInterpolator;
import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class KBRotPosScaleSplinePathInterpolator
extends KBSplinePathInterpolator {
    TransformGroup target;
    Transform3D axis = new Transform3D();
    Transform3D axisInverse = new Transform3D();
    Transform3D rotation = new Transform3D();
    Transform3D temp = new Transform3D();
    Matrix4d pitchMat = new Matrix4d();
    Matrix4d bankMat = new Matrix4d();
    Matrix4d tMat = new Matrix4d();
    Matrix4d sMat = new Matrix4d();
    Vector3f iPos = new Vector3f();
    Point3f iScale = new Point3f();
    float iHeading;
    float iPitch;
    float iBank;
    KBCubicSplineCurve cubicSplineCurve = new KBCubicSplineCurve();
    KBCubicSplineSegment[] cubicSplineSegments;
    int numSegments;
    int currentSegmentIndex;
    KBCubicSplineSegment currentSegment;

    KBRotPosScaleSplinePathInterpolator() {
    }

    public KBRotPosScaleSplinePathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, KBKeyFrame[] kBKeyFrameArray) {
        super(alpha, kBKeyFrameArray);
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
        this.cubicSplineCurve = new KBCubicSplineCurve(this.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    public void setAxisOfRotPosScale(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public Transform3D getAxisOfRotPosScale() {
        return new Transform3D(this.axis);
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.getAlpha() != null) {
            this.computePathInterpolation();
            this.currentSegmentIndex = this.lowerKnot - 1;
            if (this.currentSegmentIndex == 0 && this.currentU == 0.0f) {
                this.iHeading = this.keyFrames[1].heading;
                this.iPitch = this.keyFrames[1].pitch;
                this.iBank = this.keyFrames[1].bank;
                this.iPos.set((Tuple3f)this.keyFrames[1].position);
                this.iScale.set((Tuple3f)this.keyFrames[1].scale);
            } else if (this.currentSegmentIndex == this.numSegments - 1 && (double)this.currentU == 1.0) {
                this.iHeading = this.keyFrames[this.upperKnot].heading;
                this.iPitch = this.keyFrames[this.upperKnot].pitch;
                this.iBank = this.keyFrames[this.upperKnot].bank;
                this.iPos.set((Tuple3f)this.keyFrames[this.upperKnot].position);
                this.iScale.set((Tuple3f)this.keyFrames[this.upperKnot].scale);
            } else {
                this.currentSegment = this.cubicSplineCurve.getSegment(this.currentSegmentIndex);
                this.iHeading = this.currentSegment.getInterpolatedHeading(this.currentU);
                this.iPitch = this.currentSegment.getInterpolatedPitch(this.currentU);
                this.iBank = this.currentSegment.getInterpolatedBank(this.currentU);
                this.currentSegment.getInterpolatedPositionVector(this.currentU, this.iPos);
                this.currentSegment.getInterpolatedScale(this.currentU, this.iScale);
            }
            this.pitchMat.setIdentity();
            this.pitchMat.rotX((double)(-this.iPitch));
            this.bankMat.setIdentity();
            this.bankMat.rotZ((double)this.iBank);
            this.tMat.setIdentity();
            this.tMat.rotY((double)(-this.iHeading));
            this.tMat.mul(this.pitchMat);
            this.tMat.mul(this.bankMat);
            this.sMat.set((double)this.iScale.x);
            this.tMat.mul(this.sMat);
            this.tMat.m03 = this.iPos.x;
            this.tMat.m13 = this.iPos.y;
            this.tMat.m23 = this.iPos.z;
            this.rotation.set(this.tMat);
            this.temp.mul(this.axis, this.rotation);
            this.temp.mul(this.temp, this.axisInverse);
            this.target.setTransform(this.temp);
        }
        this.wakeupOn((WakeupCondition)this.defaultWakeupCriterion);
    }

    public Node cloneNode(boolean bl) {
        KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = new KBRotPosScaleSplinePathInterpolator();
        kBRotPosScaleSplinePathInterpolator.duplicateNode((Node)this, bl);
        return kBRotPosScaleSplinePathInterpolator;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = (KBRotPosScaleSplinePathInterpolator)node;
        this.setAxisOfRotPosScale(kBRotPosScaleSplinePathInterpolator.axis);
        this.target = kBRotPosScaleSplinePathInterpolator.target;
        this.cubicSplineCurve = new KBCubicSplineCurve(kBRotPosScaleSplinePathInterpolator.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        TransformGroup transformGroup = (TransformGroup)nodeReferenceTable.getNewObjectReference((SceneGraphObject)this.target);
        this.setTarget(transformGroup);
    }
}

