/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.SequenceLine;
import com.sun.j3d.loaders.lw3d.SwitchPathInterpolator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

class SequenceReader {
    Vector sequenceLines;
    float totalTime;
    int totalFrames;
    TransformGroup objectTransform;
    Vector behaviorVector;

    SequenceReader(String string, float f, int n) {
        this.totalTime = f;
        this.totalFrames = n;
        this.sequenceLines = new Vector();
        try {
            System.out.println("reading sequence from " + string);
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new FileReader(string)));
            streamTokenizer.wordChars(95, 95);
            streamTokenizer.wordChars(47, 47);
            int n2 = streamTokenizer.nextToken();
            while (streamTokenizer.ttype != -1) {
                this.sequenceLines.addElement(new SequenceLine(streamTokenizer, this.totalTime, this.totalFrames));
                streamTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in SequenceReader: " + exception);
        }
    }

    void createJava3dObjects(int n, int n2) {
        SequenceLine sequenceLine;
        Object object;
        this.objectTransform = new TransformGroup();
        this.behaviorVector = new Vector();
        Enumeration enumeration = this.sequenceLines.elements();
        Switch switch_ = new Switch();
        switch_.setCapability(17);
        switch_.setCapability(18);
        this.objectTransform.addChild((Node)switch_);
        while (enumeration.hasMoreElements()) {
            object = (SequenceLine)enumeration.nextElement();
            ((SequenceLine)object).createJava3dObjects(n, n2);
            if (((SequenceLine)object).getGeometry() != null) {
                switch_.addChild((Node)((SequenceLine)object).getGeometry());
            }
            if (((SequenceLine)object).getBehavior() == null) continue;
            this.behaviorVector.addElement(((SequenceLine)object).getBehavior());
        }
        object = new float[this.sequenceLines.size() + 1];
        int n3 = 0;
        while (n3 < ((Object)object).length - 1) {
            sequenceLine = (SequenceLine)this.sequenceLines.elementAt(n3);
            object[n3] = (float)sequenceLine.startFrame / (float)this.totalFrames;
            ++n3;
        }
        object[((Object)object).length - 1] = 1.0f;
        sequenceLine = new Alpha(-1, 1, 0L, 0L, (long)(1000.0f * this.totalTime), 0L, 0L, 0L, 0L, 0L);
        SwitchPathInterpolator switchPathInterpolator = new SwitchPathInterpolator((Alpha)sequenceLine, (float[])object, switch_);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
        switchPathInterpolator.setSchedulingBounds((Bounds)boundingSphere);
        switch_.addChild((Node)switchPathInterpolator);
        this.behaviorVector.addElement(switchPathInterpolator);
    }

    TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    Vector getObjectBehaviors() {
        return this.behaviorVector;
    }

    void printLines() {
        Enumeration enumeration = this.sequenceLines.elements();
        while (enumeration.hasMoreElements()) {
            SequenceLine sequenceLine = (SequenceLine)enumeration.nextElement();
        }
    }
}

