/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.J3dLwoParser;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Switch;
import javax.media.j3d.SwitchValueInterpolator;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

class SequenceLine {
    int startFrame;
    int endFrame;
    String fileName;
    Group geometryGroup = null;
    Behavior behaviors;
    int numFrames;
    float totalTime;
    int totalFrames;
    static Hashtable storedRefList = new Hashtable();

    SequenceLine(StreamTokenizer streamTokenizer, float f, int n) {
        try {
            this.totalTime = f;
            this.totalFrames = n;
            this.startFrame = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.endFrame = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.fileName = streamTokenizer.sval;
            this.numFrames = this.endFrame - this.startFrame + 1;
        }
        catch (Exception exception) {
            System.err.println("Exception reading sequence line: " + exception);
        }
    }

    private void createSwitchBehavior(Switch switch_) {
        int n = -1;
        float f = 1000.0f * this.totalTime * (float)switch_.numChildren() / (float)this.totalFrames;
        float f2 = 1000.0f * this.totalTime * (float)this.startFrame / (float)this.totalFrames;
        Alpha alpha = new Alpha(-1, (long)f2, 0L, (long)f, 0L, 0L);
        SwitchValueInterpolator switchValueInterpolator = new SwitchValueInterpolator(alpha, switch_);
        this.behaviors = switchValueInterpolator;
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
        switchValueInterpolator.setSchedulingBounds((Bounds)boundingSphere);
        switch_.setCapability(18);
        switch_.addChild((Node)this.behaviors);
    }

    void createJava3dObjects(int n, int n2) {
        if (this.fileName.indexOf("000") != -1) {
            int n3 = this.fileName.indexOf("000");
            String string = this.fileName.substring(0, n3);
            Switch switch_ = new Switch();
            switch_.setCapability(17);
            switch_.setCapability(18);
            String string2 = this.fileName;
            int n4 = 0;
            while (new File(string2).exists()) {
                Link link;
                Object object;
                if (storedRefList.get(string2) != null) {
                    System.out.println("retrieve stored version of " + string2);
                    object = (SharedGroup)storedRefList.get(string2);
                    link = new Link((SharedGroup)object);
                    switch_.addChild((Node)link);
                } else {
                    System.out.println("reading " + string2);
                    object = new J3dLwoParser(string2, n);
                    ((J3dLwoParser)object).createJava3dGeometry();
                    link = new TransformGroup();
                    SharedGroup sharedGroup = new SharedGroup();
                    storedRefList.put(string2, sharedGroup);
                    sharedGroup.addChild((Node)link);
                    Link link2 = new Link(sharedGroup);
                    switch_.addChild((Node)link2);
                    if (((J3dLwoParser)object).getJava3dShapeList() != null) {
                        Enumeration enumeration = ((J3dLwoParser)object).getJava3dShapeList().elements();
                        while (enumeration.hasMoreElements()) {
                            link.addChild((Node)((Shape3D)enumeration.nextElement()));
                        }
                    }
                }
                object = String.valueOf(++n4);
                if (n4 < 10) {
                    object = "00" + (String)object;
                } else if (n4 < 100) {
                    object = "0" + (String)object;
                }
                string2 = string + (String)object + ".lwo";
            }
            this.behaviors = null;
            if (n2 != 0) {
                this.createSwitchBehavior(switch_);
            }
            this.geometryGroup = switch_;
        } else {
            this.geometryGroup = new Group();
            if (storedRefList.get(this.fileName) != null) {
                System.out.println("getting old ref to " + this.fileName);
                SharedGroup sharedGroup = (SharedGroup)storedRefList.get(this.fileName);
                Link link = new Link(sharedGroup);
                this.geometryGroup.addChild((Node)link);
            } else {
                SharedGroup sharedGroup;
                System.out.println("reading " + this.fileName);
                J3dLwoParser j3dLwoParser = new J3dLwoParser(this.fileName, n);
                j3dLwoParser.createJava3dGeometry();
                TransformGroup transformGroup = new TransformGroup();
                if (j3dLwoParser.getJava3dShapeList() != null) {
                    sharedGroup = j3dLwoParser.getJava3dShapeList().elements();
                    while (sharedGroup.hasMoreElements()) {
                        transformGroup.addChild((Node)((Shape3D)sharedGroup.nextElement()));
                    }
                }
                sharedGroup = new SharedGroup();
                sharedGroup.addChild((Node)transformGroup);
                Link link = new Link(sharedGroup);
                this.geometryGroup.addChild((Node)link);
                storedRefList.put(this.fileName, sharedGroup);
            }
        }
    }

    Group getGeometry() {
        return this.geometryGroup;
    }

    Behavior getBehavior() {
        return this.behaviors;
    }
}

