/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.ImageScaler;
import com.sun.j3d.loaders.lw3d.LWOBFileReader;
import com.sun.j3d.loaders.lw3d.ParserObject;
import com.sun.j3d.loaders.lw3d.TargaReader;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

class LwoTexture
extends ParserObject {
    LWOBFileReader theReader;
    int red = 255;
    int green = 255;
    int blue = 255;
    Color3f color;
    Color3f diffuseColor;
    Color3f specularColor;
    Color3f emissiveColor;
    Image theImage = null;
    String imageFile = null;
    Vector3f textureSize = new Vector3f(1.0f, 1.0f, 1.0f);
    Vector3f textureCenter = new Vector3f(0.0f, 0.0f, 0.0f);
    int textureAxis;
    int flags = 0;
    String type;
    String mappingType;
    String nextToken = null;
    static Hashtable imageTable = new Hashtable();
    static Hashtable textureTable = new Hashtable();

    LwoTexture(LWOBFileReader lWOBFileReader, int n, String string, int n2) {
        super(n2);
        this.debugOutputLn(1, "Constructor");
        this.theReader = lWOBFileReader;
        this.type = string;
        this.readTexture(n);
    }

    String getNextToken() {
        return this.nextToken;
    }

    boolean isHandled() {
        if ((this.type.equals("CTEX") || this.type.equals("DTEX")) && this.theImage != null) {
            return true;
        }
        this.debugOutputLn(8, "failed isHandled(), type, theImage = " + this.type + ", " + this.theImage);
        return false;
    }

    Texture getTexture() {
        this.debugOutputLn(1, "getTexture()");
        if (this.theImage == null) {
            return null;
        }
        Texture2D texture2D = (Texture2D)textureTable.get(this.theImage);
        if (texture2D == null) {
            ImageScaler imageScaler = new ImageScaler((BufferedImage)this.theImage);
            BufferedImage bufferedImage = (BufferedImage)imageScaler.getScaledImage();
            TextureLoader textureLoader = new TextureLoader(bufferedImage);
            texture2D = (Texture2D)textureLoader.getTexture();
            textureTable.put(this.theImage, texture2D);
        }
        return texture2D;
    }

    String getType() {
        return this.type;
    }

    Color3f getColor() {
        return this.color;
    }

    Image getImage() {
        return this.theImage;
    }

    Vector3f getTextureSize() {
        return this.textureSize;
    }

    int getTextureAxis() {
        return this.textureAxis;
    }

    Vector3f getTextureCenter() {
        return this.textureCenter;
    }

    String getMappingType() {
        return this.mappingType;
    }

    void readTexture(int n) {
        this.debugOutputLn(1, "readTexture()");
        int n2 = this.theReader.getMarker() + n;
        this.mappingType = this.theReader.getString();
        this.debugOutputLn(2, "mappingType = " + this.mappingType);
        String string = this.theReader.getToken();
        try {
            while (string != null && this.theReader.getMarker() < n2) {
                this.debugOutputLn(2, "  tokenString = " + string);
                this.debugOutputLn(2, "  marker, stop = " + this.theReader.getMarker() + ", " + n2);
                if (string.endsWith("TEX") || !string.startsWith("T") || string.equals("TRAN")) {
                    this.nextToken = string;
                    return;
                }
                int n3 = this.theReader.getShortInt();
                this.debugOutputLn(2, "  fl = " + n3);
                if (string.equals("TFLG")) {
                    this.debugOutputLn(64, "Not yet handling: " + string);
                    this.flags = this.theReader.getShortInt();
                    this.textureAxis = this.flags & 7;
                    this.debugOutputLn(64, "val = " + this.flags);
                } else if (string.equals("TCLR")) {
                    this.debugOutputLn(64, "Not yet handling: " + string);
                    this.red = this.theReader.read();
                    this.green = this.theReader.read();
                    this.blue = this.theReader.read();
                    this.theReader.read();
                    this.debugOutputLn(64, "val = " + this.red + ", " + this.green + ", " + this.blue);
                } else if (string.equals("TIMG")) {
                    this.debugOutputLn(64, "Not yet handling: " + string);
                    this.imageFile = this.theReader.getString();
                    this.debugOutputLn(2, "imageFile = " + this.imageFile);
                    if (this.imageFile.indexOf("none") == -1 && (this.theImage = (Image)imageTable.get(this.imageFile)) == null) {
                        try {
                            TargaReader targaReader = new TargaReader(this.imageFile, this.debugPrinter.getValidOutput());
                            this.theImage = targaReader.getImage();
                            imageTable.put(this.imageFile, this.theImage);
                        }
                        catch (Exception exception) {
                            System.err.println(exception + "\nCould not find image " + "file; check pathname " + "and filename of image " + "in " + this.theReader.getFilename());
                        }
                    }
                    this.debugOutputLn(64, "val = __" + this.imageFile + "__");
                } else if (string.equals("TWRP")) {
                    this.debugOutputLn(64, "Not yet handling: " + string);
                    int n4 = this.theReader.getShortInt();
                    int n5 = this.theReader.getShortInt();
                    this.debugOutputLn(64, "val = " + n4 + ", " + n5);
                } else if (string.equals("TCTR")) {
                    this.debugOutputLn(64, "Not yet handling: " + string);
                    this.textureCenter.x = this.theReader.getFloat();
                    this.textureCenter.y = this.theReader.getFloat();
                    this.textureCenter.z = this.theReader.getFloat();
                    this.debugOutputLn(64, "val = " + this.textureCenter);
                } else if (string.equals("TSIZ")) {
                    this.debugOutputLn(64, "Not yet handling: " + string);
                    this.textureSize.x = this.theReader.getFloat();
                    this.textureSize.y = this.theReader.getFloat();
                    this.textureSize.z = this.theReader.getFloat();
                    this.debugOutputLn(64, "val = " + this.textureSize);
                } else {
                    this.debugOutputLn(64, "unrecognized token: " + string);
                    this.theReader.skipLength(n3);
                }
                if (this.theReader.getMarker() >= n2) continue;
                string = this.theReader.getToken();
            }
        }
        catch (Exception exception) {
            this.debugOutputLn(16, "Exception in getSurf: " + exception);
        }
    }
}

