/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.AbstractOutputTarget;
import org.apache.log.output.io.WriterTarget;
import org.apache.log.output.io.rotate.RevolvingFileStrategy;
import org.apache.log.output.io.rotate.RotateStrategyBySize;
import org.apache.log.output.io.rotate.RotatingFileTarget;
import org.jacorb.util.Environment;
import org.jacorb.util.LoggerFactory;

public class LogKitLoggerFactory
implements LoggerFactory {
    private static final String DEFAULT_LOG_PATTERN = "[%.20{category}] %.7{priority} : %{message}\\n%{throwable}";
    private static final String name = "logkit";
    private static final PatternFormatter logFormatter = new PatternFormatter(Environment.getProperty("jacorb.log.default.log_pattern", "[%.20{category}] %.7{priority} : %{message}\\n%{throwable}"));
    private int defaultPriority = 0;
    private final Map namedLoggers = new HashMap();
    private boolean append = false;
    private Writer consoleWriter;
    private LogTarget consoleTarget;

    public LogKitLoggerFactory() {
        String string = Environment.getProperty("jacorb.log.default.verbosity");
        this.append = Environment.isPropertyOn("jacorb.logfile.append");
        if (string != null) {
            if (string != null && string.toUpperCase().equals("DEBUG")) {
                string = "4";
            } else if (string != null && string.toUpperCase().equals("INFO")) {
                string = "3";
            } else if (string != null && string.toUpperCase().equals("WARN")) {
                string = "2";
            } else if (string != null && string.toUpperCase().equals("ERROR")) {
                string = "1";
            }
            try {
                this.defaultPriority = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.defaultPriority = -1;
            }
            switch (this.defaultPriority) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("'" + string + "' is an illegal" + " value for the property jacorb.log.default.verbosity. Valid values are 0->4.");
                }
            }
        }
        this.consoleWriter = new OutputStreamWriter(System.err);
        this.consoleTarget = new WriterTarget(this.consoleWriter, logFormatter);
    }

    public void setDefaultPriority(int n) {
        this.defaultPriority = n;
    }

    public final String getLoggingBackendName() {
        return name;
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string) {
        return this.getNamedLogger(string, null);
    }

    public org.apache.avalon.framework.logger.Logger getNamedRootLogger(String string) {
        return this.getNamedLogger(string, this.consoleTarget);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string, String string2, long l) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Log file name must not be null!");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string2, this.append);
        AbstractOutputTarget abstractOutputTarget = null;
        if (l == 0L) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            abstractOutputTarget = new WriterTarget(outputStreamWriter, logFormatter);
        } else {
            abstractOutputTarget = new RotatingFileTarget(this.append, logFormatter, new RotateStrategyBySize(l * 1000L), new RevolvingFileStrategy(new File(string2), 10000));
        }
        return this.getNamedLogger(string, abstractOutputTarget);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string, LogTarget logTarget) {
        Object v = this.namedLoggers.get(string);
        if (v != null) {
            return (org.apache.avalon.framework.logger.Logger)v;
        }
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(string);
        int n = this.getPriorityForNamedLogger(string);
        logger.setPriority(LogKitLoggerFactory.intToPriority(n));
        if (logTarget != null) {
            logger.setLogTargets(new LogTarget[]{logTarget});
        } else {
            logger.setLogTargets(new LogTarget[]{this.consoleTarget});
        }
        LogKitLogger logKitLogger = new LogKitLogger(logger);
        this.namedLoggers.put(string, logKitLogger);
        return logKitLogger;
    }

    public int getPriorityForNamedLogger(String string) {
        String string2 = string;
        while (!string2.equals("")) {
            String string3 = Environment.getProperty(string2 + ".log.verbosity");
            if (string3 != null) {
                if (string3 != null && string3.toUpperCase().equals("DEBUG")) {
                    string3 = "4";
                } else if (string3 != null && string3.toUpperCase().equals("INFO")) {
                    string3 = "3";
                } else if (string3 != null && string3.toUpperCase().equals("WARN")) {
                    string3 = "2";
                } else if (string3 != null && string3.toUpperCase().equals("ERROR")) {
                    string3 = "1";
                }
                return Integer.parseInt(string3);
            }
            if (string2.lastIndexOf(".") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("."));
                continue;
            }
            string2 = "";
        }
        return this.defaultPriority;
    }

    public static Priority intToPriority(int n) {
        switch (n) {
            case 4: {
                return Priority.DEBUG;
            }
            case 3: {
                return Priority.INFO;
            }
            case 2: {
                return Priority.WARN;
            }
            case 1: {
                return Priority.ERROR;
            }
        }
        return Priority.FATAL_ERROR;
    }
}

