/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Environment;

public final class Debug {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Logger logger;

    public static final void initialize() {
        logger = Environment.getLogger();
    }

    public static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public static void output(String string) {
        if (logger == null) {
            System.out.println(string);
        } else {
            logger.debug(string);
        }
    }

    public static final void output(int n, String string) {
        if (logger == null) {
            System.out.println(string);
        } else {
            logger.debug(string);
        }
    }

    public static synchronized void output(int n, String string, byte[] byArray) {
        Debug.output(n, string, byArray, 0, byArray.length);
    }

    public static synchronized void output(String string, byte[] byArray) {
        Debug.output(3, string, byArray, 0, byArray.length);
    }

    public static synchronized void output(int n, String string, byte[] byArray, int n2) {
        Debug.output(n, string, byArray, 0, n2);
    }

    public static synchronized void output(int n, String string, byte[] byArray, int n2, int n3) {
        if (logger != null && logger.isDebugEnabled()) {
            int n4;
            System.out.print("\nHexdump [" + string + "] len=" + n3 + "," + byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            for (n4 = n2; n4 < n2 + n3; ++n4) {
                if (n4 % 16 == 0) {
                    System.out.println(stringBuffer);
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(Debug.toAscii(byArray[n4]));
                System.out.print(Debug.toHex(byArray[n4]));
                if (n4 % 4 != 3) continue;
                stringBuffer.append(' ');
                System.out.print(' ');
            }
            if (n3 % 16 != 0) {
                n4 = 0;
                int n5 = 16 - n3 % 16;
                n4 = n5 * 3;
                n4 += n5 / 4;
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.insert(0, ' ');
                }
            }
            System.out.println(stringBuffer);
        }
    }

    public static final String toHex(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = by >> 4 & 0xF;
        stringBuffer.append(lookup[n]);
        int n2 = by & 0xF;
        stringBuffer.append(lookup[n2]);
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }

    public static final char toAscii(byte by) {
        if (by > 31 && by < 127) {
            return (char)by;
        }
        return '.';
    }

    public static final void output(int n, Throwable throwable) {
        if (logger == null || n == 0) {
            System.out.println("############################ StackTrace ############################");
            throwable.printStackTrace(System.out);
            System.out.println("####################################################################");
        }
        if (logger != null && logger.isErrorEnabled()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                throwable.printStackTrace(printStream);
                byteArrayOutputStream.close();
                printStream.close();
                logger.error(byteArrayOutputStream.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Logger getNamedLogger(String string) {
        return Environment.getLoggerFactory().getNamedLogger(string);
    }

    public static Logger getNamedRootLogger(String string) {
        return Environment.getLoggerFactory().getNamedRootLogger(string);
    }

    static {
        Debug.initialize();
    }
}

