/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.util.PropUtil;
import org.jacorb.util.Debug;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class OfferUtil {
    private OfferUtil() {
    }

    public static void validateProperties(OfferDatabase offerDatabase, Property[] propertyArray, String string, TypeStruct typeStruct) throws IllegalPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MissingMandatoryProperty, DuplicatePropertyName {
        PropStruct propStruct;
        Hashtable<String, PropStruct> hashtable = new Hashtable<String, PropStruct>();
        for (int i = 0; i < typeStruct.props.length; ++i) {
            hashtable.put(typeStruct.props[i].name, typeStruct.props[i]);
        }
        Hashtable<String, Property> hashtable2 = new Hashtable<String, Property>();
        for (int i = 0; i < propertyArray.length; ++i) {
            propStruct = (PropStruct)hashtable.get(propertyArray[i].name);
            if (propStruct != null) {
                if (hashtable2.containsKey(propertyArray[i].name)) {
                    throw new DuplicatePropertyName(propertyArray[i].name);
                }
                OfferUtil.checkProperty(string, propertyArray[i], propStruct);
                hashtable2.put(propertyArray[i].name, propertyArray[i]);
            }
            if (offerDatabase.isTypeSupported(propertyArray[i].value)) continue;
            Debug.output(3, " Type not supported: " + propertyArray[i].name);
            throw new PropertyTypeMismatch(string, propertyArray[i]);
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            propStruct = (PropStruct)enumeration.nextElement();
            if (hashtable2.get(propStruct.name) != null || !OfferUtil.isMandatory(propStruct.mode)) continue;
            throw new MissingMandatoryProperty(string, propStruct.name);
        }
    }

    public static boolean isMandatory(PropertyMode propertyMode) {
        boolean bl = propertyMode == PropertyMode.PROP_MANDATORY || propertyMode == PropertyMode.PROP_MANDATORY_READONLY;
        return bl;
    }

    public static boolean isReadonly(PropertyMode propertyMode) {
        boolean bl = propertyMode == PropertyMode.PROP_READONLY || propertyMode == PropertyMode.PROP_MANDATORY_READONLY;
        return bl;
    }

    public static void checkProperty(String string, Property property, PropStruct propStruct) throws PropertyTypeMismatch, ReadonlyDynamicProperty {
        try {
            TypeCode typeCode = propStruct.value_type;
            while (typeCode.kind() == TCKind.tk_alias) {
                typeCode = typeCode.content_type();
            }
            if (PropUtil.isDynamicProperty(property.value.type())) {
                if (OfferUtil.isReadonly(propStruct.mode)) {
                    throw new ReadonlyDynamicProperty(string, property.name);
                }
                DynamicProp dynamicProp = DynamicPropHelper.extract(property.value);
                TypeCode typeCode2 = dynamicProp.returned_type;
                while (typeCode2.kind() == TCKind.tk_alias) {
                    typeCode2 = typeCode2.content_type();
                }
                if (!typeCode2.equal(typeCode)) {
                    throw new PropertyTypeMismatch(string, property);
                }
            } else {
                TypeCode typeCode3 = property.value.type();
                while (typeCode3.kind() == TCKind.tk_alias) {
                    typeCode3 = typeCode3.content_type();
                }
                if (!typeCode3.equal(typeCode)) {
                    throw new PropertyTypeMismatch(string, property);
                }
            }
        }
        catch (BadKind badKind) {
            throw new RuntimeException();
        }
    }
}

