/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.trading.impl.LinkAttrib;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.jacorb.util.Debug;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.InvalidLookupRef;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.LinkOperations;
import org.omg.CosTrading.LinkPOA;
import org.omg.CosTrading.LinkPackage.DefaultFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.DuplicateLinkName;
import org.omg.CosTrading.LinkPackage.IllegalLinkName;
import org.omg.CosTrading.LinkPackage.LimitingFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.LinkInfo;
import org.omg.CosTrading.LinkPackage.UnknownLinkName;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterHelper;

public class LinkImpl
extends LinkPOA
implements LinkOperations {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private LinkAttrib m_link;
    private Hashtable m_current_links;
    private boolean m_links_changed = true;

    public LinkImpl(TraderComp traderComp, SupportAttrib supportAttrib, LinkAttrib linkAttrib) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_link = linkAttrib;
        this.m_current_links = new Hashtable();
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    public FollowOption max_link_follow_policy() {
        return this.m_link.getMaxLinkFollowPolicy();
    }

    public void add_link(String string, Lookup lookup, FollowOption followOption, FollowOption followOption2) throws IllegalLinkName, DuplicateLinkName, InvalidLookupRef, DefaultFollowTooPermissive, LimitingFollowTooPermissive {
        IDLEntity iDLEntity;
        if (string == null || string.length() == 0) {
            throw new IllegalLinkName(string);
        }
        if (this.m_current_links.containsKey(string)) {
            throw new DuplicateLinkName(string);
        }
        Register register = null;
        try {
            iDLEntity = lookup.register_if();
            register = RegisterHelper.narrow(iDLEntity);
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            throw new InvalidLookupRef(lookup);
        }
        if (followOption.value() > followOption2.value()) {
            throw new DefaultFollowTooPermissive(followOption, followOption2);
        }
        if (followOption2.value() > this.max_link_follow_policy().value()) {
            throw new LimitingFollowTooPermissive(followOption, followOption2);
        }
        iDLEntity = new LinkInfo(lookup, register, followOption, followOption2);
        this.m_current_links.put(string, iDLEntity);
        this.m_links_changed = true;
    }

    public LinkInfo describe_link(String string) throws IllegalLinkName, UnknownLinkName {
        if (string == null || string.length() == 0) {
            throw new IllegalLinkName(string);
        }
        LinkInfo linkInfo = (LinkInfo)this.m_current_links.get(string);
        if (linkInfo == null) {
            throw new UnknownLinkName(string);
        }
        return linkInfo;
    }

    public String[] list_links() {
        String[] stringArray = new String[this.m_current_links.size()];
        Enumeration enumeration = this.m_current_links.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void modify_link(String string, FollowOption followOption, FollowOption followOption2) throws IllegalLinkName, UnknownLinkName, DefaultFollowTooPermissive, LimitingFollowTooPermissive {
        if (string == null || string.length() == 0) {
            throw new IllegalLinkName(string);
        }
        if (!this.m_current_links.containsKey(string)) {
            throw new UnknownLinkName(string);
        }
        if (followOption.value() > followOption2.value()) {
            throw new DefaultFollowTooPermissive(followOption, followOption2);
        }
        if (followOption2.value() > this.max_link_follow_policy().value()) {
            throw new LimitingFollowTooPermissive(followOption, followOption2);
        }
        LinkInfo linkInfo = (LinkInfo)this.m_current_links.get(string);
        linkInfo.def_pass_on_follow_rule = followOption;
        linkInfo.limiting_follow_rule = followOption2;
        this.m_links_changed = true;
    }

    public void remove_link(String string) throws IllegalLinkName, UnknownLinkName {
        if (string == null || string.length() == 0) {
            throw new IllegalLinkName(string);
        }
        if (!this.m_current_links.containsKey(string)) {
            throw new UnknownLinkName(string);
        }
        this.m_current_links.remove(string);
        this.m_links_changed = true;
    }

    public boolean linksChanged() {
        return this.m_links_changed;
    }

    public LinkInfo[] getLinks() {
        LinkInfo[] linkInfoArray = new LinkInfo[this.m_current_links.size()];
        Enumeration enumeration = this.m_current_links.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            linkInfoArray[n++] = (LinkInfo)enumeration.nextElement();
        }
        this.m_links_changed = false;
        return linkInfoArray;
    }
}

