/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class TypeCodeValue
implements Serializable {
    private int m_kind;
    private String m_id;
    private String m_name;
    private int m_length;
    private TypeCodeValue m_content;
    private Object m_arg;
    private transient TypeCode m_typeCode;
    static final long serialVersionUID = -2067446388881696087L;

    private TypeCodeValue() {
    }

    public TypeCodeValue(TypeCode typeCode) {
        this.setValue(typeCode);
    }

    public TypeCode getValue() {
        TypeCode typeCode = this.m_typeCode;
        if (typeCode == null) {
            ORB oRB = ORB.init();
            switch (this.m_kind) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    typeCode = oRB.get_primitive_tc(TCKind.from_int(this.m_kind));
                    break;
                }
                case 18: {
                    typeCode = oRB.create_string_tc(this.m_length);
                    break;
                }
                case 19: {
                    typeCode = oRB.create_sequence_tc(this.m_length, this.m_content.getValue());
                    break;
                }
                case 20: {
                    typeCode = oRB.create_array_tc(this.m_length, this.m_content.getValue());
                    break;
                }
                case 21: {
                    typeCode = oRB.create_alias_tc(this.m_id, this.m_name, this.m_content.getValue());
                    break;
                }
                case 14: {
                    typeCode = oRB.create_interface_tc(this.m_id, this.m_name);
                    break;
                }
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    throw new RuntimeException("Unsupported type");
                }
                default: {
                    throw new RuntimeException("Unexpected type");
                }
            }
            this.m_typeCode = typeCode;
        }
        return typeCode;
    }

    protected void setValue(TypeCode typeCode) {
        TCKind tCKind = typeCode.kind();
        this.m_kind = tCKind.value();
        this.m_id = null;
        this.m_name = null;
        this.m_length = 0;
        this.m_content = null;
        this.m_arg = null;
        this.m_typeCode = typeCode;
        try {
            switch (tCKind.value()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 18: {
                    this.m_length = typeCode.length();
                    break;
                }
                case 19: {
                    this.m_length = typeCode.length();
                    this.m_content = new TypeCodeValue(typeCode.content_type());
                    break;
                }
                case 20: {
                    this.m_length = typeCode.length();
                    this.m_content = new TypeCodeValue(typeCode.content_type());
                    break;
                }
                case 21: {
                    this.m_id = typeCode.id();
                    this.m_name = typeCode.name();
                    this.m_content = new TypeCodeValue(typeCode.content_type());
                    break;
                }
                case 14: {
                    this.m_id = typeCode.id();
                    this.m_name = typeCode.name();
                    break;
                }
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    throw new RuntimeException("Unsupported type");
                }
                default: {
                    throw new RuntimeException("Unexpected type");
                }
            }
        }
        catch (BadKind badKind) {
            throw new RuntimeException(badKind.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_typeCode = null;
    }
}

