/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.ATLAS.ATLASProfile;
import org.omg.ATLAS.ATLASProfileHelper;
import org.omg.ATLAS.AuthTokenData;
import org.omg.ATLAS.AuthTokenDispenserHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;

public class SASClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    protected static final int SecurityAttributeService = 15;
    protected final String DEFAULT_NAME = "SASClientInterceptor";
    protected Codec codec = null;
    protected String name = "SASClientInterceptor";
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS.CSS");
    protected byte[] contextToken = new byte[0];
    protected boolean useStateful = true;
    protected Hashtable atlasCache = new Hashtable();
    protected ISASContext sasContext = null;

    public SASClientInterceptor(ORBInitInfo oRBInitInfo) throws UnknownEncoding {
        Encoding encoding = new Encoding(0, 1, 0);
        this.codec = oRBInitInfo.codec_factory().create_codec(encoding);
        this.useStateful = Boolean.valueOf(Environment.getProperty("jacorb.security.sas.stateful", "true"));
        String string = Environment.getProperty("jacorb.security.sas.contextClass");
        if (string != null) {
            try {
                Class clazz = Environment.classForName(string);
                this.sasContext = (ISASContext)clazz.newInstance();
            }
            catch (Exception exception) {
                logger.error("Could not instantiate class " + string + ": " + exception);
            }
        }
        if (this.sasContext == null) {
            logger.error("Could not load SAS context class: " + string);
        } else {
            this.sasContext.initClient();
        }
    }

    public void setContextToken(byte[] byArray) {
        this.contextToken = byArray;
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        java.lang.Object object;
        ORB oRB = ((ClientRequestInfoImpl)clientRequestInfo).orb;
        CompoundSecMechList compoundSecMechList = null;
        try {
            object = clientRequestInfo.get_effective_component(33);
            CDRInputStream cDRInputStream = new CDRInputStream(null, ((TaggedComponent)object).component_data);
            cDRInputStream.openEncapsulatedArray();
            compoundSecMechList = CompoundSecMechListHelper.read(cDRInputStream);
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.debug("Did not find tagged component TAG_CSI_SEC_MECH_LIST: " + clientRequestInfo.operation());
        }
        catch (Exception exception) {
            logger.warn("Did not find tagged component TAG_CSI_SEC_MECH_LIST: " + exception);
        }
        if (compoundSecMechList == null) {
            return;
        }
        if (compoundSecMechList.mechanism_list[0].as_context_mech.target_supports == 0 && compoundSecMechList.mechanism_list[0].as_context_mech.target_requires == 0 && compoundSecMechList.mechanism_list[0].sas_context_mech.target_supports == 0 && compoundSecMechList.mechanism_list[0].sas_context_mech.target_requires == 0) {
            return;
        }
        object = ((ClientRequestInfoImpl)clientRequestInfo).connection;
        long l = 0L;
        if (this.useStateful) {
            l = ((ClientConnection)object).cacheSASContext("css".getBytes());
        }
        if (l < 0L) {
            logger.info("New SAS Context: " + -l);
        }
        AuthorizationElement[] authorizationElementArray = this.getATLASTokens(oRB, compoundSecMechList);
        try {
            Any any = null;
            if (l <= 0L) {
                IdentityToken identityToken = new IdentityToken();
                identityToken.absent(true);
                this.contextToken = this.sasContext.createClientContext(clientRequestInfo, compoundSecMechList);
                any = this.makeEstablishContext(oRB, -l, authorizationElementArray, identityToken, this.contextToken);
            } else {
                any = this.makeMessageInContext(oRB, l, false);
            }
            clientRequestInfo.add_request_service_context(new ServiceContext(15, this.codec.encode_value(any)), true);
        }
        catch (Exception exception) {
            logger.warn("Could not set security service context: " + exception);
            throw new NO_PERMISSION("SAS Could not set security service context: " + exception, 1245904897, CompletionStatus.COMPLETED_NO);
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        IDLEntity iDLEntity;
        java.lang.Object object;
        SASContextBody sASContextBody = null;
        ServiceContext serviceContext = null;
        try {
            serviceContext = clientRequestInfo.get_reply_service_context(15);
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.debug("No SAS security context found: " + clientRequestInfo.operation());
        }
        catch (Exception exception) {
            logger.warn("No SAS security context found: " + exception);
        }
        if (serviceContext == null) {
            return;
        }
        try {
            object = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type());
            sASContextBody = SASContextBodyHelper.extract((Any)object);
        }
        catch (Exception exception) {
            logger.warn("Could not parse SAS reply: " + exception);
            throw new NO_PERMISSION("SAS Could not parse SAS reply: " + exception, 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
        object = ((ClientRequestInfoImpl)clientRequestInfo).connection;
        if (sASContextBody.discriminator() == 1) {
            iDLEntity = sASContextBody.complete_msg();
            if (iDLEntity.client_context_id > 0L && !iDLEntity.context_stateful) {
                ((ClientConnection)object).purgeSASContext(iDLEntity.client_context_id);
            }
        }
        if (sASContextBody.discriminator() == 4) {
            iDLEntity = sASContextBody.error_msg();
            if (((ContextError)iDLEntity).client_context_id > 0L) {
                ((ClientConnection)object).purgeSASContext(((ContextError)iDLEntity).client_context_id);
            }
        }
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        IDLEntity iDLEntity;
        java.lang.Object object;
        SASContextBody sASContextBody = null;
        ServiceContext serviceContext = null;
        try {
            serviceContext = clientRequestInfo.get_reply_service_context(15);
        }
        catch (BAD_PARAM bAD_PARAM) {
            logger.debug("No SAS security context found (exception): " + clientRequestInfo.operation());
        }
        catch (Exception exception) {
            logger.warn("No SAS security context found (exception): " + exception);
        }
        if (serviceContext == null) {
            return;
        }
        try {
            object = this.codec.decode_value(serviceContext.context_data, SASContextBodyHelper.type());
            sASContextBody = SASContextBodyHelper.extract((Any)object);
        }
        catch (Exception exception) {
            logger.warn("Could not parse SAS reply: " + exception);
            throw new NO_PERMISSION("SAS Could not parse SAS reply: " + exception, 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
        object = ((ClientRequestInfoImpl)clientRequestInfo).connection;
        if (sASContextBody.discriminator() == 1) {
            iDLEntity = sASContextBody.complete_msg();
            if (iDLEntity.client_context_id > 0L && !iDLEntity.context_stateful) {
                ((ClientConnection)object).purgeSASContext(iDLEntity.client_context_id);
            }
        }
        if (sASContextBody.discriminator() == 4) {
            iDLEntity = sASContextBody.error_msg();
            if (((ContextError)iDLEntity).client_context_id > 0L) {
                ((ClientConnection)object).purgeSASContext(((ContextError)iDLEntity).client_context_id);
            }
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
    }

    protected Any makeEstablishContext(org.omg.CORBA.ORB oRB, long l, AuthorizationElement[] authorizationElementArray, IdentityToken identityToken, byte[] byArray) {
        EstablishContext establishContext = new EstablishContext();
        establishContext.client_context_id = l;
        establishContext.client_authentication_token = byArray;
        establishContext.identity_token = identityToken;
        establishContext.authorization_token = authorizationElementArray;
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.establish_msg(establishContext);
        Any any = oRB.create_any();
        SASContextBodyHelper.insert(any, sASContextBody);
        return any;
    }

    protected Any makeMessageInContext(org.omg.CORBA.ORB oRB, long l, boolean bl) {
        MessageInContext messageInContext = new MessageInContext();
        messageInContext.client_context_id = l;
        messageInContext.discard_context = bl;
        SASContextBody sASContextBody = new SASContextBody();
        sASContextBody.in_context_msg(messageInContext);
        Any any = oRB.create_any();
        SASContextBodyHelper.insert(any, sASContextBody);
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationElement[] getATLASTokens(org.omg.CORBA.ORB oRB, CompoundSecMechList compoundSecMechList) throws NO_PERMISSION {
        java.lang.Object object;
        Serializable serializable;
        java.lang.Object object2;
        ATLASProfile aTLASProfile = null;
        try {
            object2 = compoundSecMechList.mechanism_list[0].sas_context_mech.privilege_authorities;
            for (int i = 0; i < ((ServiceConfiguration[])object2).length; ++i) {
                if (object2[i].syntax != 3) continue;
                serializable = this.codec.decode(object2[i].name);
                aTLASProfile = ATLASProfileHelper.extract((Any)serializable);
            }
        }
        catch (Exception exception) {
            logger.warn("Error parsing ATLAS from IOR: " + exception);
            throw new NO_PERMISSION("SAS Error parsing ATLAS from IOR: " + exception, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        if (aTLASProfile == null) {
            return new AuthorizationElement[0];
        }
        object2 = new String(aTLASProfile.the_cache_id);
        String string = aTLASProfile.the_locator.the_url();
        if (string != null) {
            string = URLDecoder.decode(string);
        }
        serializable = this.atlasCache;
        synchronized (serializable) {
            if (this.atlasCache.containsKey(object2)) {
                return ((AuthTokenData)this.atlasCache.get((java.lang.Object)object2)).auth_token;
            }
        }
        serializable = null;
        try {
            object = oRB.string_to_object(string);
            serializable = AuthTokenDispenserHelper.narrow((Object)object);
        }
        catch (Exception exception) {
            logger.warn("Could not find ATLAS server " + string + ": " + exception);
            throw new NO_PERMISSION("SAS Could not find ATLAS server " + string + ": " + exception, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        if (serializable == null) {
            logger.warn("SAS found null ATLAS server " + string);
            throw new NO_PERMISSION("SAS found null ATLAS server " + string, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        object = null;
        try {
            object = serializable.get_my_authorization_token();
        }
        catch (Exception exception) {
            logger.warn("Error getting ATLAS tokens from server " + string + ": " + exception);
            throw new NO_PERMISSION("SAS Error getting ATLAS tokens from server: " + exception, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        Hashtable hashtable = this.atlasCache;
        synchronized (hashtable) {
            this.atlasCache.put(object2, object);
        }
        return ((AuthTokenData)object).auth_token;
    }
}

