/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.apache.avalon.framework.logger.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class KerberosContext
implements ISASContext {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS");
    private GSSContext validatedContext = null;
    private GSSCredential targetCreds = null;
    private GSSCredential clientCreds = null;

    public void initClient() {
        String string = "";
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            this.clientCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
        }
        catch (Exception exception) {
            logger.warn("Error getting created principal: " + exception);
        }
    }

    public String getMechOID() {
        return "oid:1.2.840.113554.1.2.2".substring(4);
    }

    public byte[] createClientContext(ClientRequestInfo clientRequestInfo, CompoundSecMechList compoundSecMechList) {
        byte[] byArray = new byte[]{};
        try {
            byte[] byArray2 = compoundSecMechList.mechanism_list[0].as_context_mech.target_name;
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            GSSName gSSName = gSSManager.createName(byArray2, null, oid);
            if (this.clientCreds == null) {
                this.clientCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
            }
            GSSContext gSSContext = gSSManager.createContext(gSSName, oid, this.clientCreds, Integer.MAX_VALUE);
            byArray = gSSContext.initSecContext(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            logger.error("Error creating Kerberos context: " + exception);
        }
        return byArray;
    }

    public String getClientPrincipal() {
        String string = "";
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            if (this.clientCreds == null) {
                this.clientCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 1);
            }
            string = ((Object)this.clientCreds.getName()).toString();
        }
        catch (Exception exception) {
            logger.error("Error getting created principal: " + exception);
        }
        return string;
    }

    public void initTarget() {
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            if (this.targetCreds == null) {
                this.targetCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 2);
            }
        }
        catch (GSSException gSSException) {
            logger.warn("Error accepting Kerberos context: " + gSSException);
        }
    }

    public boolean validateContext(ServerRequestInfo serverRequestInfo, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            Oid oid = new Oid("oid:1.2.840.113554.1.2.2".substring(4));
            GSSManager gSSManager = GSSManager.getInstance();
            if (this.targetCreds == null) {
                this.targetCreds = gSSManager.createCredential(null, Integer.MAX_VALUE, oid, 2);
            }
            this.validatedContext = gSSManager.createContext(this.targetCreds);
            byArray2 = this.validatedContext.acceptSecContext(byArray, 0, byArray.length);
        }
        catch (GSSException gSSException) {
            logger.error("Error accepting Kerberos context: " + gSSException);
        }
        if (byArray2 == null) {
            logger.warn("Could not accept token");
            return false;
        }
        return true;
    }

    public String getValidatedPrincipal() {
        if (this.validatedContext == null) {
            return null;
        }
        try {
            return ((Object)this.validatedContext.getSrcName()).toString();
        }
        catch (GSSException gSSException) {
            logger.error("Error getting name: " + gSSException);
            return null;
        }
    }
}

