/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.GSSUPContextSpi;
import org.jacorb.security.sas.GSSUPCredentialSpi;
import org.jacorb.security.sas.GSSUPNameSpi;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public final class GSSUPMechFactory
implements MechanismFactory {
    protected static Provider myProvider;
    private Oid myMechOid;
    private Oid[] nameTypes = new Oid[]{GSSName.NT_EXPORT_NAME};

    public GSSUPMechFactory() {
        try {
            this.myMechOid = new Oid("2.23.130.1.1.1");
        }
        catch (GSSException gSSException) {
            System.out.println("GSSUPMechanism: " + gSSException);
        }
    }

    public Oid getMechanismOid() {
        return this.myMechOid;
    }

    public Provider getProvider() {
        return myProvider;
    }

    public Oid[] getNameTypes() {
        return this.nameTypes;
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi gSSNameSpi, int n, int n2, int n3) throws GSSException {
        return new GSSUPCredentialSpi(myProvider, this.myMechOid, gSSNameSpi, n, n2, n3);
    }

    public GSSNameSpi getNameElement(String string, Oid oid) throws GSSException {
        return this.getNameElement(string.getBytes(), oid);
    }

    public GSSNameSpi getNameElement(byte[] byArray, Oid oid) throws GSSException {
        return new GSSUPNameSpi(myProvider, this.myMechOid, byArray, oid);
    }

    public GSSContextSpi getMechanismContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) throws GSSException {
        return new GSSUPContextSpi(myProvider, this.myMechOid, gSSNameSpi, gSSCredentialSpi, n);
    }

    public GSSContextSpi getMechanismContext(GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        return new GSSUPContextSpi(gSSCredentialSpi.getProvider(), gSSCredentialSpi.getMechanism(), gSSCredentialSpi.getName(), gSSCredentialSpi, gSSCredentialSpi.getInitLifetime());
    }

    public GSSContextSpi getMechanismContext(byte[] byArray) throws GSSException {
        return null;
    }
}

