/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.level2;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.security.level2.AccessDecisionImpl;
import org.jacorb.security.level2.CredentialsImpl;
import org.jacorb.security.level2.InvocationCredentialsPolicyImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.MechanismPolicyImpl;
import org.jacorb.security.level2.QOPPolicyImpl;
import org.jacorb.security.level2.SecAttributeManager;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.CredentialType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.MechandOptions;
import org.omg.Security.QOP;
import org.omg.Security.SecAttribute;
import org.omg.Security.SecurityFeature;
import org.omg.Security.SecurityMechanismData;
import org.omg.SecurityLevel2.AccessDecision;
import org.omg.SecurityLevel2.AuditDecision;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.Current;
import org.omg.SecurityLevel2.DelegationMode;
import org.omg.SecurityLevel2.InvocationCredentialsPolicy;
import org.omg.SecurityLevel2.MechanismPolicy;
import org.omg.SecurityLevel2.PrincipalAuthenticator;
import org.omg.SecurityLevel2.QOPPolicy;
import org.omg.SecurityLevel2.ReceivedCredentials;
import org.omg.SecurityLevel2.RequiredRights;

public class CurrentImpl
extends LocalObject
implements Current {
    private CredentialsImpl[] own_credentials;
    private PrincipalAuthenticator principalAuthenticator;
    private AccessDecision access_decision = null;
    private Hashtable policies = null;
    private SecAttributeManager attrib_mgr = null;
    private Hashtable ts_credentials = null;
    private Hashtable ts_received_credentials = null;
    private ORB orb = null;
    private Logger logger;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;

    public CurrentImpl(ORB oRB) {
        this.orb = oRB;
        this.logger = Debug.getNamedLogger("jacorb.security");
        this.attrib_mgr = SecAttributeManager.getInstance();
        this.ts_credentials = new Hashtable();
        this.ts_received_credentials = new Hashtable();
        this.policies = new Hashtable();
        try {
            Class clazz = Environment.classForName(Environment.getProperty("jacorb.security.access_decision"));
            this.access_decision = (AccessDecision)clazz.newInstance();
        }
        catch (Exception exception) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Class " + Environment.getProperty("jacorb.security.access_decision") + " not found! Please check property \"jacorb.security.access_decision\"");
            }
            this.access_decision = new AccessDecisionImpl();
        }
    }

    public void init() {
        this.authenticate();
    }

    private PrincipalAuthenticator createAuthenticator(String string) {
        block10: {
            try {
                Class clazz = Environment.classForName(string);
                Constructor<?>[] constructorArray = clazz.getConstructors();
                if (constructorArray.length != 1) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("PrincAuth " + string + " must have exactly one constructor that takes either no arg or one arg of type org.omg.CORBA.ORB");
                    }
                    return null;
                }
                Class<?>[] classArray = constructorArray[0].getParameterTypes();
                if (classArray.length == 0) {
                    return (PrincipalAuthenticator)clazz.newInstance();
                }
                if (classArray.length == 1) {
                    if (classArray[0].equals(class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = CurrentImpl.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB)) {
                        return (PrincipalAuthenticator)constructorArray[0].newInstance(this.orb);
                    }
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("PrincAuth " + string + "'s constructor has an arg of type " + classArray[0].getName() + " but it must have an arg of type org.omg.CORBA.ORB");
                    }
                } else if (this.logger.isErrorEnabled()) {
                    this.logger.error("PrincAuth " + string + " must have exactly one constructor that takes either no arg or one arg of type org.omg.CORBA.ORB");
                }
            }
            catch (Exception exception) {
                if (!this.logger.isWarnEnabled()) break block10;
                this.logger.warn("Exception " + exception.getMessage() + " in CurrentImpl");
            }
        }
        return null;
    }

    private void authenticate() {
        java.lang.Object object;
        java.lang.Object object2;
        String string = Environment.getProperty("jacorb.security.principal_authenticator");
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        if (string != null) {
            object2 = new StringTokenizer(string, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = this.createAuthenticator(((StringTokenizer)object2).nextToken());
                if (object == null) continue;
                vector.add(object);
            }
        }
        if (vector.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("No PrincipalAuthenticator set. Will not authenticate!");
            }
            this.own_credentials = new CredentialsImpl[0];
            return;
        }
        this.principalAuthenticator = (PrincipalAuthenticator)vector.get(0);
        object2 = Environment.getProperty("jacorb.security.default_user");
        object = Environment.getProperty("jacorb.security.default_password");
        byte[] byArray = object == null ? null : ((String)object).getBytes();
        Vector<CredentialsImpl> vector2 = new Vector<CredentialsImpl>();
        for (int i = 0; i < vector.size(); ++i) {
            CredentialsHolder credentialsHolder;
            PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)vector.get(i);
            if (principalAuthenticator.authenticate(0, null, (String)object2, byArray, null, credentialsHolder = new CredentialsHolder(), null, null) == AuthenticationStatus.SecAuthSuccess) {
                vector2.add((CredentialsImpl)credentialsHolder.value);
                this.own_credentials = new CredentialsImpl[vector2.size()];
                vector2.copyInto(this.own_credentials);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("PrincAuth " + i + ": AuthenticationStatus.SecAuthSuccess");
                continue;
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("PrincAuth " + i + ": AuthenticationStatus.SecAuthFailure");
        }
    }

    public SecAttribute[] get_attributes(AttributeType[] attributeTypeArray) {
        CredentialsImpl[] credentialsImplArray = this.getTSCredentials();
        if (credentialsImplArray != null && credentialsImplArray.length > 0) {
            return credentialsImplArray[0].get_attributes(attributeTypeArray);
        }
        if (this.own_credentials != null && this.own_credentials.length > 0) {
            return this.own_credentials[0].get_attributes(attributeTypeArray);
        }
        return new SecAttribute[0];
    }

    public ReceivedCredentials received_credentials() {
        return (ReceivedCredentials)this.ts_received_credentials.get(Thread.currentThread());
    }

    public void set_credentials(CredentialType credentialType, Credentials[] credentialsArray, DelegationMode delegationMode) {
        this.ts_credentials.put(Thread.currentThread(), credentialsArray);
    }

    public void set_received_credentials(ReceivedCredentials receivedCredentials) {
        this.ts_received_credentials.put(Thread.currentThread(), receivedCredentials);
    }

    public void remove_received_credentials() {
        this.ts_received_credentials.remove(Thread.currentThread());
    }

    public Credentials[] get_credentials(CredentialType credentialType) {
        CredentialsImpl[] credentialsImplArray = this.getTSCredentials();
        if (credentialsImplArray == null) {
            credentialsImplArray = this.own_credentials;
        }
        Vector<CredentialsImpl> vector = new Vector<CredentialsImpl>();
        for (int i = 0; i < credentialsImplArray.length; ++i) {
            if (credentialType.value() != credentialsImplArray[i].credentials_type().value()) continue;
            vector.addElement(credentialsImplArray[i]);
        }
        Credentials[] credentialsArray = new Credentials[vector.size()];
        for (int i = 0; i < credentialsArray.length; ++i) {
            credentialsArray[i] = (Credentials)vector.elementAt(i);
        }
        return credentialsArray;
    }

    public Credentials[] own_credentials() {
        return this.own_credentials;
    }

    public void remove_own_credentials(Credentials credentials) {
        int n;
        boolean bl = false;
        Vector<CredentialsImpl> vector = new Vector<CredentialsImpl>();
        for (n = 0; n < this.own_credentials.length; ++n) {
            if (credentials == this.own_credentials[n]) {
                bl = true;
                continue;
            }
            vector.addElement(this.own_credentials[n]);
        }
        if (bl) {
            this.own_credentials = new CredentialsImpl[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                this.own_credentials[n] = (CredentialsImpl)vector.elementAt(n);
            }
        } else {
            throw new BAD_PARAM();
        }
    }

    public SecurityFeature[] received_security_features() {
        return null;
    }

    public Policy get_policy(int n) {
        return (Policy)this.policies.get(new Integer(n));
    }

    public MechandOptions[] supported_mechanisms() {
        return null;
    }

    public SecurityMechanismData[] get_security_mechanisms(Object object) {
        return null;
    }

    public RequiredRights required_rights_object() {
        return null;
    }

    public PrincipalAuthenticator principal_authenticator() {
        return this.principalAuthenticator;
    }

    public AccessDecision access_decision() {
        return this.access_decision;
    }

    public AuditDecision audit_decision() {
        return null;
    }

    public QOPPolicy create_qop_policy(QOP qOP) {
        return new QOPPolicyImpl(qOP);
    }

    public MechanismPolicy create_mechanism_policy(String[] stringArray) {
        return new MechanismPolicyImpl(stringArray);
    }

    public InvocationCredentialsPolicy create_invoc_creds_policy(Credentials[] credentialsArray) {
        return new InvocationCredentialsPolicyImpl(credentialsArray);
    }

    private CredentialsImpl[] getTSCredentials() {
        return (CredentialsImpl[])this.ts_credentials.get(Thread.currentThread());
    }

    public KeyAndCert[] getSSLCredentials() {
        if (this.own_credentials == null || this.own_credentials.length == 0) {
            return new KeyAndCert[0];
        }
        AttributeType attributeType = new AttributeType(new ExtensibleFamily(0, 1), 2);
        AttributeType attributeType2 = new AttributeType(new ExtensibleFamily(0, 1), 5);
        SecAttribute[] secAttributeArray = this.own_credentials[0].get_attributes(new AttributeType[]{attributeType, attributeType2});
        KeyAndCert[] keyAndCertArray = new KeyAndCert[secAttributeArray.length];
        for (int i = 0; i < keyAndCertArray.length; ++i) {
            keyAndCertArray[i] = this.attrib_mgr.getAttributeCertValue(secAttributeArray[i]);
        }
        return keyAndCertArray;
    }

    public void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Closing Current");
        }
        this.principalAuthenticator = null;
        this.policies.clear();
        this.ts_credentials.clear();
        this.ts_received_credentials.clear();
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

