/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.util;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.Delegate;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.IdUtil;
import org.jacorb.util.Debug;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public final class POAUtil {
    private static final int bytesPerLine = 20;

    private POAUtil() {
    }

    public static String convert(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            stringBuffer.append(Debug.toHex(byArray[i]));
            boolean bl2 = bl = i >= byArray.length - 1;
            if (bl) {
                for (int j = 0; j < 20 - i % 20 - 1; ++j) {
                    stringBuffer.append("   ");
                }
            }
            if (i % 20 != 19 && !bl) continue;
            while (n <= i) {
                stringBuffer.append(byArray[n] < 32 ? (char)'.' : (char)byArray[n]);
                ++n;
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static String convert(Policy policy, int n) {
        switch (n) {
            case 16: {
                if (policy == null || ((ThreadPolicy)policy).value() == ThreadPolicyValue.ORB_CTRL_MODEL) {
                    return "ORB_CTRL_MODEL";
                }
                if (((ThreadPolicy)policy).value() != ThreadPolicyValue.SINGLE_THREAD_MODEL) break;
                return "SINGLE_THREAD_MODEL";
            }
            case 17: {
                if (policy == null || ((LifespanPolicy)policy).value() == LifespanPolicyValue.TRANSIENT) {
                    return "TRANSIENT";
                }
                if (((LifespanPolicy)policy).value() != LifespanPolicyValue.PERSISTENT) break;
                return "PERSISTENT";
            }
            case 18: {
                if (policy == null || ((IdUniquenessPolicy)policy).value() == IdUniquenessPolicyValue.UNIQUE_ID) {
                    return "UNIQUE_ID";
                }
                if (((IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID) break;
                return "MULTIPLE_ID";
            }
            case 19: {
                if (policy == null || ((IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) {
                    return "SYSTEM_ID";
                }
                if (((IdAssignmentPolicy)policy).value() != IdAssignmentPolicyValue.USER_ID) break;
                return "USER_ID";
            }
            case 21: {
                if (policy == null || ((ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) {
                    return "RETAIN";
                }
                if (((ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.NON_RETAIN) break;
                return "NON_RETAIN";
            }
            case 22: {
                if (policy == null || ((RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                    return "USE_ACTIVE_OBJECT_MAP_ONLY";
                }
                if (((RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) {
                    return "USE_SERVANT_MANAGER";
                }
                if (((RequestProcessingPolicy)policy).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) break;
                return "USE_DEFAULT_SERVANT";
            }
            case 20: {
                if (policy == null || ((ImplicitActivationPolicy)policy).value() == ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION) {
                    return "NO_IMPLICIT_ACTIVATION";
                }
                if (((ImplicitActivationPolicy)policy).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) break;
                return "IMPLICIT_ACTIVATION";
            }
        }
        return "unknown";
    }

    public static String convert(State state) {
        if (state.value() == 1) {
            return "active";
        }
        if (state.value() == 0) {
            return "holding";
        }
        if (state.value() == 2) {
            return "discarding";
        }
        if (state.value() == 3) {
            return "inactive";
        }
        return "unknown";
    }

    public static String extractImplName(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 47) continue;
            byte[] byArray2 = IdUtil.extract(byArray, 0, i);
            return POAUtil.unmaskStr(new String(byArray2));
        }
        throw new POAInternalError("error extracting impl name from object_key: " + POAUtil.convert(byArray));
    }

    public static byte[] extractOID(byte[] byArray) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] != 47) continue;
            byte[] byArray2 = IdUtil.extract(byArray, ++i, byArray.length - i);
            return POAUtil.unmaskId(byArray2);
        }
        throw new POAInternalError("error extracting oid from object_key: " + POAUtil.convert(byArray));
    }

    public static byte[] extractOID(Object object) {
        return ((Delegate)((ObjectImpl)object)._get_delegate()).getObjectId();
    }

    public static String extractPOAName(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != 47) continue;
            n2 = n;
            break;
        }
        for (n = byArray.length - 1; n >= 0; --n) {
            if (byArray[n] != 47) continue;
            n3 = n;
            break;
        }
        if (n2 > n3) {
            throw new POAInternalError("error extracting poa name from object_key: " + POAUtil.convert(byArray));
        }
        if (n2 == n3) {
            return "";
        }
        return new String(IdUtil.extract(byArray, ++n2, n3 - n2));
    }

    public static List extractScopedPOANames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.length() > 0) {
            int n;
            int n2 = 0;
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) != '/') continue;
                arrayList.add(string.substring(n2, n));
                n2 = ++n;
            }
            arrayList.add(string.substring(n2, n));
        }
        return arrayList;
    }

    public static Policy getPolicy(Policy[] policyArray, int n) {
        if (policyArray != null) {
            for (int i = 0; i < policyArray.length; ++i) {
                if (policyArray[i].policy_type() != n) continue;
                return policyArray[i];
            }
        }
        return null;
    }

    public static boolean isActive(State state) {
        return state.value() == 1;
    }

    public static boolean isDiscarding(State state) {
        return state.value() == 2;
    }

    public static boolean isHolding(State state) {
        return state.value() == 0;
    }

    public static boolean isInactive(State state) {
        return state.value() == 3;
    }

    public static byte[] maskId(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 47) {
                ++n;
                continue;
            }
            if (byArray[i] != 38) continue;
            ++n;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 47) {
                byArray2[n] = 38;
                byArray2[n + 1] = 37;
                n += 2;
                continue;
            }
            if (byArray[i] == 38) {
                byArray2[n] = 38;
                byArray2[n + 1] = 38;
                n += 2;
                continue;
            }
            byArray2[n] = byArray[i];
            ++n;
        }
        return byArray2;
    }

    public static String maskStr(String string) {
        return new String(POAUtil.maskId(string.getBytes()));
    }

    public static String unmaskStr(String string) {
        return new String(POAUtil.unmaskId(string.getBytes()));
    }

    public static byte[] unmaskId(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 38) continue;
            --n;
            ++i;
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 38) {
                if (byArray[i + 1] == 38) {
                    byArray2[n] = 38;
                } else if (byArray[i + 1] == 37) {
                    byArray2[n] = 47;
                } else {
                    throw new POAInternalError("error: forbidden byte sequence \"38" + byArray[i + 1] + "\" (unmaskId)");
                }
                ++i;
            } else {
                byArray2[n] = byArray[i];
            }
            ++n;
        }
        return byArray2;
    }
}

