/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.orb.ORB;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo {
    private int slot_count = 0;
    private ORB orb = null;
    private Hashtable named_server_interceptors = null;
    private Vector anonymous_server_interceptors = null;
    private Hashtable named_client_interceptors = null;
    private Vector anonymous_client_interceptors = null;
    private Hashtable named_ior_interceptors = null;
    private Vector anonymous_ior_interceptors = null;
    private Hashtable policy_factories = null;
    private boolean valid = true;

    public ORBInitInfoImpl(ORB oRB) {
        this.orb = oRB;
        this.named_server_interceptors = new Hashtable();
        this.named_client_interceptors = new Hashtable();
        this.anonymous_server_interceptors = new Vector();
        this.anonymous_client_interceptors = new Vector();
        this.named_ior_interceptors = new Hashtable();
        this.anonymous_ior_interceptors = new Vector();
        this.policy_factories = new Hashtable();
    }

    public ORB getORB() {
        return this.orb;
    }

    public void setInvalid() {
        this.valid = false;
    }

    private void merge(Vector vector, Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    public Vector getClientInterceptors() {
        this.merge(this.anonymous_client_interceptors, this.named_client_interceptors);
        return this.anonymous_client_interceptors;
    }

    public Vector getServerInterceptors() {
        this.merge(this.anonymous_server_interceptors, this.named_server_interceptors);
        return this.anonymous_server_interceptors;
    }

    public Vector getIORInterceptors() {
        this.merge(this.anonymous_ior_interceptors, this.named_ior_interceptors);
        return this.anonymous_ior_interceptors;
    }

    public Hashtable getPolicyFactories() {
        return this.policy_factories;
    }

    public int getSlotCount() {
        return this.slot_count;
    }

    public void add_client_request_interceptor(ClientRequestInterceptor clientRequestInterceptor) throws DuplicateName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        if (clientRequestInterceptor.name() == null) {
            throw new DuplicateName("The name is null!");
        }
        if (clientRequestInterceptor.name().length() == 0) {
            this.anonymous_client_interceptors.addElement(clientRequestInterceptor);
        } else {
            if (this.named_client_interceptors.containsKey(clientRequestInterceptor.name())) {
                throw new DuplicateName(clientRequestInterceptor.name());
            }
            this.named_client_interceptors.put(clientRequestInterceptor.name(), clientRequestInterceptor);
        }
    }

    public void add_ior_interceptor(IORInterceptor iORInterceptor) throws DuplicateName {
        if (iORInterceptor.name() == null) {
            throw new DuplicateName("The name is null!");
        }
        if (iORInterceptor.name().length() == 0) {
            this.anonymous_ior_interceptors.addElement(iORInterceptor);
        } else {
            if (this.named_ior_interceptors.containsKey(iORInterceptor.name())) {
                throw new DuplicateName(iORInterceptor.name());
            }
            this.named_ior_interceptors.put(iORInterceptor.name(), iORInterceptor);
        }
    }

    public void add_server_request_interceptor(ServerRequestInterceptor serverRequestInterceptor) throws DuplicateName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        if (serverRequestInterceptor.name() == null) {
            throw new DuplicateName("The name is null!");
        }
        if (serverRequestInterceptor.name().length() == 0) {
            this.anonymous_server_interceptors.addElement(serverRequestInterceptor);
        } else {
            if (this.named_server_interceptors.containsKey(serverRequestInterceptor.name())) {
                throw new DuplicateName(serverRequestInterceptor.name());
            }
            this.named_server_interceptors.put(serverRequestInterceptor.name(), serverRequestInterceptor);
        }
    }

    public int allocate_slot_id() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        return this.slot_count++;
    }

    public String[] arguments() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        return this.orb._args;
    }

    public CodecFactory codec_factory() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        try {
            return (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
        }
        catch (Exception exception) {
            Debug.output(4, exception.getMessage());
            return null;
        }
    }

    public String orb_id() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        return "jacorb:2.1";
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        try {
            this.orb.register_initial_reference(string, object);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName();
        }
    }

    public void register_policy_factory(int n, PolicyFactory policyFactory) {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        if (policyFactory == null) {
            throw new BAD_PARAM("Actual parameter policy_factory is null!");
        }
        Integer n2 = new Integer(n);
        if (this.policy_factories.containsKey(n2)) {
            throw new BAD_INV_ORDER("A PolicyFactory for type " + n + " has already been registered!", 12, CompletionStatus.COMPLETED_MAYBE);
        }
        this.policy_factories.put(n2, policyFactory);
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        try {
            return this.orb.resolve_initial_references(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName();
        }
    }
}

