/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.ETF.Connection;
import org.omg.ETF.Handle;
import org.omg.ETF.Profile;
import org.omg.ETF._ListenerLocalBase;
import org.omg.SSLIOP.SSL;

public class IIOPListener
extends _ListenerLocalBase {
    private ServerSocketFactory serverSocketFactory = null;
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private Acceptor acceptor = null;
    private SSLAcceptor sslAcceptor = null;
    private IIOPProfile endpoint = null;
    private Logger logger = null;
    private Handle up = null;
    private List incoming_connections = new ArrayList();
    private boolean terminated = false;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;

    public IIOPListener() {
        this.logger = Debug.getNamedLogger("jacorb.orb.iiop");
        if (!this.isSSLRequired()) {
            this.acceptor = new Acceptor();
            this.acceptor.init();
        }
        if (this.isSSLSupported()) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.endpoint = this.createEndPointProfile();
    }

    public void set_handle(Handle handle) {
        this.up = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection accept() {
        if (this.up != null) {
            throw new BAD_INV_ORDER("Must not call accept() when a Handle has been set");
        }
        List list = this.incoming_connections;
        synchronized (list) {
            while (!this.terminated && this.incoming_connections.isEmpty()) {
                try {
                    this.incoming_connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.terminated) {
                return (Connection)this.incoming_connections.remove(0);
            }
            return null;
        }
    }

    public void listen() {
        if (this.acceptor != null) {
            this.acceptor.start();
        }
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
    }

    public void destroy() {
        if (this.acceptor != null) {
            this.acceptor.terminate();
        }
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        this.terminated = true;
        if (this.up == null) {
            this.incoming_connections.notifyAll();
        }
    }

    public void completed_data(Connection connection) {
        throw new NO_IMPLEMENT();
    }

    public Profile endpoint() {
        return this.endpoint.copy();
    }

    private boolean isSSLSupported() {
        return Environment.isPropertyOn("jacorb.security.support_ssl");
    }

    private boolean isSSLRequired() {
        if (this.isSSLSupported()) {
            int n = 126;
            String string = Environment.getProperty("jacorb.ssl.server.required_options");
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string, 16);
                    return (n2 & n) != 0;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new INITIALIZE("could not parse jacorb.ssl.server.required_options: " + string);
                }
            }
        }
        return false;
    }

    private int getServerTimeout() {
        String string = Environment.getProperty("jacorb.connection.server.timeout");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    private ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = SocketFactoryManager.getServerSocketFactory(null);
        }
        return this.serverSocketFactory;
    }

    private SSLServerSocketFactory getSSLServerSocketFactory() {
        if (this.sslServerSocketFactory == null) {
            this.sslServerSocketFactory = BasicAdapter.ssl_socket_factory;
            if (this.sslServerSocketFactory == null) {
                throw new INITIALIZE("No SSL server socket factory found");
            }
        }
        return this.sslServerSocketFactory;
    }

    private IIOPProfile createEndPointProfile() {
        int n = 0;
        if (this.acceptor != null) {
            n = this.getConfiguredPort();
            if (n == 0) {
                n = this.acceptor.getLocalAddress().getPort();
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create endpoint profile");
        }
        IIOPProfile iIOPProfile = new IIOPProfile(new IIOPAddress(Environment.isPropertyOn("jacorb.dns.enable") ? this.getHost().getHostName() : this.getHost().getHostAddress(), n), null);
        if (this.sslAcceptor != null) {
            iIOPProfile.addComponent(20, this.createSSL(), class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = IIOPListener.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
        }
        return iIOPProfile;
    }

    private SSL createSSL() {
        int n = Environment.getIntProperty("jacorb.security.ssl.server.supported_options", 16);
        int n2 = Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16);
        return new SSL((short)n, (short)n2, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private InetAddress getConfiguredHost() {
        try {
            String string = Environment.getProperty("OAIAddr");
            return string == null ? null : InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private InetAddress getHost() {
        try {
            InetAddress inetAddress = this.getConfiguredHost();
            return inetAddress == null ? InetAddress.getLocalHost() : inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private int getConfiguredPort() {
        String string = Environment.getProperty("OAPort");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    private int getConfiguredSSLPort() {
        String string = Environment.getProperty("OASSLPort");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverConnection(Socket socket, boolean bl) {
        Connection connection = null;
        try {
            connection = this.createServerConnection(socket, bl);
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: " + iOException);
            }
            return;
        }
        if (this.up != null) {
            this.up.add_input(connection);
        } else {
            List list = this.incoming_connections;
            synchronized (list) {
                this.incoming_connections.add(connection);
                this.incoming_connections.notifyAll();
            }
        }
    }

    protected Connection createServerConnection(Socket socket, boolean bl) throws IOException {
        return new ServerIIOPConnection(socket, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SSLAcceptor
    extends Acceptor {
        private SSLAcceptor() {
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getSSLServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredSSLPort(), 20, IIOPListener.this.getConfiguredHost());
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn(iOException.getMessage());
                throw new INITIALIZE("Could not create SSL server socket");
            }
        }

        public void setup(Socket socket) throws IOException {
            super.setup(socket);
            IIOPListener.this.getSSLServerSocketFactory().switchToClientMode(socket);
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, true);
        }
    }

    private class Acceptor
    extends Thread {
        protected ServerSocket serverSocket;
        private boolean terminated = false;

        public Acceptor() {
            this.setDaemon(true);
        }

        public void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created socket listener on " + this.serverSocket.getInetAddress());
            }
        }

        public void run() {
            while (!this.terminated) {
                try {
                    Socket socket = this.serverSocket.accept();
                    this.setup(socket);
                    this.deliverConnection(socket);
                }
                catch (Exception exception) {
                    if (this.terminated || !IIOPListener.this.logger.isWarnEnabled()) continue;
                    IIOPListener.this.logger.warn(exception.getMessage());
                }
            }
            if (IIOPListener.this.logger.isInfoEnabled()) {
                IIOPListener.this.logger.info("Listener exited");
            }
        }

        public void terminate() {
            block2: {
                this.terminated = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    if (!IIOPListener.this.logger.isWarnEnabled()) break block2;
                    IIOPListener.this.logger.warn(iOException.getMessage());
                }
            }
        }

        public IIOPAddress getLocalAddress() {
            return new IIOPAddress(this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort());
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredPort(), 20, IIOPListener.this.getConfiguredHost());
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn(iOException.getMessage());
                throw new INITIALIZE("Could not create server socket");
            }
        }

        protected void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.getServerTimeout());
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, false);
        }
    }
}

