/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSIENT;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.SSLIOP.SSL;

public class ClientIIOPConnection
extends IIOPConnection {
    private IIOPProfile target_profile;
    private int timeout;
    private boolean use_ssl;
    private int ssl_port;
    private Logger logger;
    public static int openTransports = 0;
    static /* synthetic */ Class class$org$omg$CSIIOP$CompoundSecMechListHelper;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;

    public ClientIIOPConnection() {
        block3: {
            this.timeout = 0;
            this.use_ssl = false;
            this.ssl_port = -1;
            this.logger = Debug.getNamedLogger("jacorb.iiop.conn");
            String string = Environment.getProperty("jacorb.connection.client.idle_timeout");
            if (string != null) {
                try {
                    this.timeout = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create int from string >" + string + "< \n" + "Please check property \"jacorb.connection.client.idle_timeout\"");
                }
            }
        }
    }

    public ClientIIOPConnection(ClientIIOPConnection clientIIOPConnection) {
        super(clientIIOPConnection);
        this.timeout = 0;
        this.use_ssl = false;
        this.ssl_port = -1;
        this.logger = Debug.getNamedLogger("jacorb.iiop.conn");
        this.target_profile = clientIIOPConnection.target_profile;
        this.timeout = clientIIOPConnection.timeout;
        this.use_ssl = clientIIOPConnection.use_ssl;
        this.ssl_port = clientIIOPConnection.ssl_port;
    }

    public synchronized void connect(Profile profile, long l) {
        if (!this.connected) {
            int n;
            if (!(profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + profile.getClass());
            }
            this.target_profile = (IIOPProfile)profile;
            this.checkSSL();
            IIOPAddress iIOPAddress = this.target_profile.getAddress();
            this.connection_info = iIOPAddress.getIP() + ":" + (this.use_ssl ? this.ssl_port : iIOPAddress.getPort());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Trying to connect to " + this.connection_info);
            }
            for (n = Environment.noOfRetries(); n >= 0; --n) {
                try {
                    this.socket = this.createSocket();
                    if (this.timeout != 0) {
                        this.socket.setSoTimeout(this.timeout);
                    }
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : ""));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException iOException) {
                    Debug.output(3, iOException);
                    if (n < 0) continue;
                    Debug.output(1, "Retrying to connect to " + this.connection_info);
                    try {
                        Thread.sleep(Environment.retryInterval());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (n < 0) {
                this.target_profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    private Socket createSocket() throws IOException {
        Socket socket = null;
        IOException iOException = null;
        ArrayList<IIOPAddress> arrayList = new ArrayList<IIOPAddress>();
        arrayList.add(this.target_profile.getAddress());
        arrayList.addAll(this.target_profile.getAlternateAddresses());
        Iterator iterator = arrayList.iterator();
        while (socket == null && iterator.hasNext()) {
            try {
                IIOPAddress iIOPAddress = (IIOPAddress)iterator.next();
                if (this.use_ssl) {
                    socket = this.getSSLSocketFactory().createSocket(iIOPAddress.getIP(), this.ssl_port);
                    this.connection_info = iIOPAddress.getIP() + ":" + this.ssl_port;
                    continue;
                }
                socket = this.getSocketFactory().createSocket(iIOPAddress.getIP(), iIOPAddress.getPort());
                this.connection_info = iIOPAddress.toString();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (socket != null) {
            return socket;
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("connection failure without exception");
    }

    public synchronized void close() {
        try {
            if (this.connected && this.socket != null) {
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
                --openTransports;
            }
            this.connected = false;
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
        }
    }

    public boolean isSSL() {
        return this.use_ssl;
    }

    public Profile get_server_profile() {
        return this.target_profile;
    }

    private void checkSSL() {
        Object object;
        CompoundSecMechList compoundSecMechList = (CompoundSecMechList)this.target_profile.getComponent(33, class$org$omg$CSIIOP$CompoundSecMechListHelper == null ? (class$org$omg$CSIIOP$CompoundSecMechListHelper = ClientIIOPConnection.class$("org.omg.CSIIOP.CompoundSecMechListHelper")) : class$org$omg$CSIIOP$CompoundSecMechListHelper);
        TLS_SEC_TRANS tLS_SEC_TRANS = null;
        if (compoundSecMechList != null && compoundSecMechList.mechanism_list[0].transport_mech.tag == 36) {
            try {
                object = compoundSecMechList.mechanism_list[0].transport_mech.component_data;
                CDRInputStream cDRInputStream = new CDRInputStream(null, (byte[])object);
                cDRInputStream.openEncapsulatedArray();
                tLS_SEC_TRANS = TLS_SEC_TRANSHelper.read(cDRInputStream);
            }
            catch (Exception exception) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + exception);
            }
        }
        object = (SSL)this.target_profile.getComponent(20, class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = ClientIIOPConnection.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
        int n = 126;
        int n2 = 0;
        int n3 = 0;
        if (Environment.isPropertyOn("jacorb.security.support_ssl")) {
            n2 = Environment.getIntProperty("jacorb.security.ssl.client.required_options", 16);
            n3 = Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16);
        }
        if (tLS_SEC_TRANS != null && (tLS_SEC_TRANS.target_supports & n) != 0 && Environment.isPropertyOn("jacorb.security.support_ssl") && (n3 & n) != 0 && ((tLS_SEC_TRANS.target_requires & n) != 0 || (n2 & n) != 0)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
            this.use_ssl = true;
            this.ssl_port = tLS_SEC_TRANS.addresses[0].port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
        } else {
            if (tLS_SEC_TRANS == null && Environment.isPropertyOn("jacorb.security.support_ssl") && (n2 & n) != 0) {
                throw new NO_PERMISSION("Client-side policy requires TLS, but server doesn't support it");
            }
            if (object != null && (((SSL)object).target_supports & n) != 0 && Environment.isPropertyOn("jacorb.security.support_ssl") && (n3 & n) != 0 && ((((SSL)object).target_requires & n) != 0 || (n2 & n) != 0)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Selecting SSL for connection");
                }
                this.use_ssl = true;
                this.ssl_port = ((SSL)object).port;
                if (this.ssl_port < 0) {
                    this.ssl_port += 65536;
                }
            } else {
                if (object == null && Environment.isPropertyOn("jacorb.security.support_ssl") && (n2 & n) != 0) {
                    throw new NO_PERMISSION("Client-side policy requires SSL, but server doesn't support it");
                }
                this.use_ssl = false;
                this.ssl_port = -1;
            }
        }
    }

    private SocketFactory getSocketFactory() {
        return TransportManager.socket_factory;
    }

    private SocketFactory getSSLSocketFactory() {
        return TransportManager.ssl_socket_factory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

