/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.omg.GIOP.ReplyStatusType_1_2;

public abstract class GIOPConnection
extends OutputStream {
    protected Profile profile = null;
    protected Connection transport = null;
    private RequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    protected ConnectionListener connection_listener = null;
    protected Object connect_sync = new Object();
    private boolean writer_active = false;
    private Object write_sync = new Object();
    private Logger logger = Debug.getNamedLogger("jacorb.giop.conn");
    private int TCS = CodeSet.getTCSDefault();
    private int TCSW = CodeSet.getTCSWDefault();
    private boolean tcs_negotiated = false;
    private Hashtable fragments = null;
    private BufferManager buf_mg = null;
    private boolean dump_incoming = false;
    private BufferHolder msg_header = new BufferHolder(new byte[12]);
    private BufferHolder inbuf = new BufferHolder();
    private static int cubby_count = 0;
    private Object[] cubbyholes = null;
    private int pending_messages = 0;
    protected boolean discard_messages = false;
    protected Object pendingUndecidedSync = new Object();
    protected boolean do_close = false;
    protected StatisticsProvider statistics_provider = null;

    public GIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener, StatisticsProvider statisticsProvider) {
        this.profile = profile;
        this.transport = connection;
        this.request_listener = requestListener;
        this.reply_listener = replyListener;
        this.statistics_provider = statisticsProvider;
        this.fragments = new Hashtable();
        this.buf_mg = BufferManager.getInstance();
        String string = Environment.getProperty("jacorb.debug.dump_incoming_messages", "off");
        this.dump_incoming = "on".equals(string);
        this.cubbyholes = new Object[cubby_count];
    }

    public final void setCodeSets(int n, int n2) {
        this.TCS = n;
        this.TCSW = n2;
        this.tcs_negotiated = true;
    }

    public final int getTCS() {
        return this.TCS;
    }

    public final int getTCSW() {
        return this.TCSW;
    }

    public final void markTCSNegotiated() {
        this.tcs_negotiated = true;
    }

    public final boolean isTCSNegotiated() {
        return this.tcs_negotiated;
    }

    protected final synchronized RequestListener getRequestListener() {
        return this.request_listener;
    }

    public final synchronized void setRequestListener(RequestListener requestListener) {
        this.request_listener = requestListener;
    }

    private final synchronized ReplyListener getReplyListener() {
        return this.reply_listener;
    }

    public final synchronized void setReplyListener(ReplyListener replyListener) {
        this.reply_listener = replyListener;
    }

    public final void setConnectionListener(ConnectionListener connectionListener) {
        this.connection_listener = connectionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getTransport() {
        Object object = this.connect_sync;
        synchronized (object) {
            return this.transport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilConnected() {
        Object object = this.connect_sync;
        synchronized (object) {
            while (!this.transport.is_connected() && !this.do_close) {
                try {
                    this.connect_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.do_close;
        }
    }

    protected abstract void readTimedOut();

    protected abstract void streamClosed();

    private byte[] getMessage() throws IOException {
        if (!this.waitUntilConnected()) {
            return null;
        }
        try {
            this.transport.read(this.msg_header, 0, 12, 12, 0L);
        }
        catch (TRANSIENT tRANSIENT) {
            return null;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            this.streamClosed();
            return null;
        }
        catch (TIMEOUT tIMEOUT) {
            this.readTimedOut();
            return null;
        }
        byte[] byArray = this.msg_header.value;
        if ((char)byArray[0] == 'G' && (char)byArray[1] == 'I' && (char)byArray[2] == 'O' && (char)byArray[3] == 'P') {
            int n = Messages.getMsgSize(byArray);
            if (n < 0) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Negative GIOP message size: " + n);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("TCP_IP_GIOPTransport.getMessage() with header: \n" + byArray + "\nsize : " + 12);
                }
                return null;
            }
            this.inbuf.value = this.buf_mg.getBuffer(n + 12);
            System.arraycopy(byArray, 0, this.inbuf.value, 0, 12);
            try {
                this.transport.read(this.inbuf, 12, n, n, 0L);
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Failed to read GIOP message");
                }
                return null;
            }
            if (this.dump_incoming) {
                Debug.output(1, "getMessage()", this.inbuf.value, 0, n + 12);
            }
            if (this.statistics_provider != null) {
                this.statistics_provider.messageReceived(n + 12);
            }
            return this.inbuf.value;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Failed to read GIOP message, incorrect magic number");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnection.getMessage()" + this.msg_header.value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveMessages() throws IOException {
        while (true) {
            byte[] byArray;
            if ((byArray = this.getMessage()) == null) {
                if (!this.do_close) continue;
                return;
            }
            Object object = this.pendingUndecidedSync;
            synchronized (object) {
                OutputStream outputStream;
                if (this.discard_messages) {
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                if (Messages.getGIOPMajor(byArray) != 1) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Invalid GIOP major version encountered: " + Messages.getGIOPMajor(byArray));
                    }
                    Debug.output(3, "GIOPConnection.receiveMessages()", byArray);
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                int n = Messages.getMsgType(byArray);
                if (n == 7) {
                    if (Messages.getGIOPMinor(byArray) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message of type Fragment");
                        }
                        MessageOutputStream messageOutputStream = new MessageOutputStream();
                        messageOutputStream.writeGIOPMsgHeader(6, 0);
                        messageOutputStream.insertMsgSize();
                        this.sendMessage(messageOutputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    if (Messages.getGIOPMinor(byArray) == 1) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.1 Fragment message");
                        }
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    Integer n2 = new Integer(Messages.getRequestId(byArray));
                    if (!this.fragments.containsKey(n2)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("No previous Fragment to this one");
                        }
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    outputStream = (ByteArrayOutputStream)this.fragments.get(n2);
                    ((ByteArrayOutputStream)outputStream).write(byArray, 16, Messages.getMsgSize(byArray) - 4);
                    if (Messages.moreFragmentsFollow(byArray)) {
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    this.buf_mg.returnBuffer(byArray);
                    byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                    n = Messages.getMsgType(byArray);
                    this.fragments.remove(n2);
                } else if (Messages.moreFragmentsFollow(byArray)) {
                    if (Messages.getGIOPMinor(byArray) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message with the \"more fragments follow\" bits set");
                        }
                        MessageOutputStream messageOutputStream = new MessageOutputStream();
                        messageOutputStream.writeGIOPMsgHeader(6, 0);
                        messageOutputStream.insertMsgSize();
                        this.sendMessage(messageOutputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    if (Messages.getGIOPMinor(byArray) == 1) {
                        if (n != 0 && n != 1) {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn("Received a GIOP 1.1 message of type " + n + " with the \"more fragments follow\" bits set");
                            }
                            MessageOutputStream messageOutputStream = new MessageOutputStream();
                            messageOutputStream.writeGIOPMsgHeader(6, 1);
                            messageOutputStream.insertMsgSize();
                            this.sendMessage(messageOutputStream);
                            this.buf_mg.returnBuffer(byArray);
                            continue;
                        }
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a fragmented GIOP 1.1 message");
                        }
                        int n3 = Messages.getGIOPMinor(byArray);
                        outputStream = new ReplyOutputStream(Messages.getRequestId(byArray), ReplyStatusType_1_2.SYSTEM_EXCEPTION, n3, false);
                        SystemExceptionHelper.write((org.omg.CORBA.portable.OutputStream)outputStream, new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO));
                        this.sendMessage((MessageOutputStream)outputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    if (n == 2 || n == 5 || n == 2) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP message of type " + n + " with the \"more fragments follow\" bits set, but this " + "message type isn't allowed to be fragmented");
                        }
                        MessageOutputStream messageOutputStream = new MessageOutputStream();
                        messageOutputStream.writeGIOPMsgHeader(6, 1);
                        messageOutputStream.insertMsgSize();
                        this.sendMessage(messageOutputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    Integer n4 = new Integer(Messages.getRequestId(byArray));
                    if (this.fragments.containsKey(n4)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received a message of type " + n + " with the more fragments follow bit set, but there is already an fragmented, incomplete message with the same request id " + n4 + "!");
                        }
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    outputStream = new ByteArrayOutputStream();
                    this.fragments.put(n4, outputStream);
                    ((ByteArrayOutputStream)outputStream).write(byArray, 0, 12 + Messages.getMsgSize(byArray));
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                switch (n) {
                    case 0: {
                        this.getRequestListener().requestReceived(byArray, this);
                        break;
                    }
                    case 1: {
                        this.getReplyListener().replyReceived(byArray, this);
                        break;
                    }
                    case 2: {
                        this.getRequestListener().cancelRequestReceived(byArray, this);
                        break;
                    }
                    case 3: {
                        this.getRequestListener().locateRequestReceived(byArray, this);
                        break;
                    }
                    case 4: {
                        this.getReplyListener().locateReplyReceived(byArray, this);
                        break;
                    }
                    case 5: {
                        this.getReplyListener().closeConnectionReceived(byArray, this);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("received message with unknown message type " + n);
                        }
                        Debug.output(3, "GIOPConnection.receiveMessages()", byArray);
                        this.buf_mg.returnBuffer(byArray);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            while (this.writer_active) {
                try {
                    this.write_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.writer_active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            this.writer_active = false;
            this.write_sync.notifyAll();
        }
    }

    public final synchronized void incPendingMessages() {
        ++this.pending_messages;
    }

    public final synchronized void decPendingMessages() {
        --this.pending_messages;
    }

    public final synchronized boolean hasPendingMessages() {
        return this.pending_messages != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] byArray, int n, int n2) {
        if (!this.transport.is_connected()) {
            Object object = this.connect_sync;
            synchronized (object) {
                this.transport.connect(this.profile, 0L);
                this.connect_sync.notifyAll();
            }
        }
        this.transport.write(false, false, byArray, n, n2, 0L);
        if (this.getStatisticsProvider() != null) {
            this.getStatisticsProvider().messageChunkSent(n2);
        }
    }

    public final void write(int n) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void write(byte[] byArray) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void flush() throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void sendRequest(MessageOutputStream messageOutputStream, boolean bl) throws IOException {
        if (bl) {
            this.incPendingMessages();
        }
        this.sendMessage(messageOutputStream);
    }

    public final void sendReply(MessageOutputStream messageOutputStream) throws IOException {
        this.decPendingMessages();
        this.sendMessage(messageOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessage(MessageOutputStream messageOutputStream) throws IOException {
        try {
            this.getWriteLock();
            messageOutputStream.write_to(this);
            this.transport.flush();
            if (this.getStatisticsProvider() != null) {
                this.getStatisticsProvider().flushed();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public final boolean isSSL() {
        if (this.transport instanceof IIOPConnection) {
            return ((IIOPConnection)this.transport).isSSL();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connect_sync;
        synchronized (object) {
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            this.transport.close();
            this.do_close = true;
            this.connect_sync.notifyAll();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnection closed (terminated).");
        }
    }

    public final StatisticsProvider getStatisticsProvider() {
        return this.statistics_provider;
    }

    public static int allocate_cubby_id() {
        return cubby_count++;
    }

    public Object get_cubby(int n) {
        if (n < 0 || n >= cubby_count) {
            Debug.output(1, "Get bad cubby id " + n + " (max=" + cubby_count + ")");
            return null;
        }
        return this.cubbyholes[n];
    }

    public void set_cubby(int n, Object object) {
        if (n < 0 || n >= cubby_count) {
            Debug.output(1, "Set bad cubby id " + n + " (max=" + cubby_count + ")");
            return;
        }
        this.cubbyholes[n] = object;
    }
}

