/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.portableInterceptor.DefaultServerInterceptor;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class BiDirConnectionServerInterceptor
extends DefaultServerInterceptor {
    private String name = "BiDirConnectionServerInterceptor";
    private ORB orb = null;
    private Codec codec = null;
    private ClientConnectionManager conn_mg = null;

    public BiDirConnectionServerInterceptor(ORB oRB, Codec codec) {
        this.orb = oRB;
        this.codec = codec;
        this.conn_mg = oRB.getClientConnectionManager();
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (this.orb.useBiDirGIOP()) {
            ServiceContext serviceContext = null;
            try {
                serviceContext = serverRequestInfo.get_request_service_context(5);
            }
            catch (BAD_PARAM bAD_PARAM) {
                // empty catch block
            }
            if (serviceContext == null) {
                return;
            }
            BiDirIIOPServiceContext biDirIIOPServiceContext = null;
            CDRInputStream cDRInputStream = new CDRInputStream(this.orb, serviceContext.context_data);
            cDRInputStream.openEncapsulatedArray();
            biDirIIOPServiceContext = BiDirIIOPServiceContextHelper.read(cDRInputStream);
            GIOPConnection gIOPConnection = ((ServerRequestInfoImpl)serverRequestInfo).request.getConnection();
            for (int i = 0; i < biDirIIOPServiceContext.listen_points.length; ++i) {
                ListenPoint listenPoint = biDirIIOPServiceContext.listen_points[i];
                IIOPAddress iIOPAddress = new IIOPAddress(listenPoint.host, listenPoint.port);
                Debug.output(2, "BiDirServerInterceptor: Added client conn to target " + iIOPAddress);
                this.conn_mg.addConnection(gIOPConnection, new IIOPProfile(iIOPAddress, null));
            }
        }
    }
}

