/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jacorb.notification.servant.PropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedQoS;

public class QoSPropertySet
extends PropertySet {
    public static final int CHANNEL_QOS = 0;
    public static final int ADMIN_QOS = 1;
    public static final int PROXY_QOS = 2;
    private static HashSet validPerChannelQoS_ = new HashSet();
    private static HashSet validPerAdminQoS_;
    private static HashSet validPerProxyQoS_;
    private static HashSet validPerMessageQoS_;
    static Any connectionReliabilityLowValue_;
    static Any connectionReliabilityHighValue_;
    static Any orderPolicyLowValue_;
    static Any orderPolicyHighValue_;
    static Any discardPolicyLowValue_;
    static Any discardPolicyHighValue_;
    private int type_;
    private HashSet validNames_;

    public QoSPropertySet(int n) {
        this.type_ = n;
        this.init(n);
    }

    public QoSPropertySet(int n, Property[] propertyArray) {
        super(propertyArray);
        this.type_ = n;
        this.init(n);
    }

    private void init(int n) {
        switch (n) {
            case 0: {
                this.validNames_ = validPerChannelQoS_;
                break;
            }
            case 1: {
                this.validNames_ = validPerAdminQoS_;
                break;
            }
            case 2: {
                this.validNames_ = validPerProxyQoS_;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + n + " is unknown");
            }
        }
    }

    HashSet getValidNames() {
        return this.validNames_;
    }

    public void set_qos(Property[] propertyArray) {
        this.set_properties(propertyArray);
    }

    public Property[] get_qos() {
        return this.toArray();
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        ArrayList arrayList = new ArrayList();
        this.checkPropertyExistence(propertyArray, arrayList);
        this.checkPropertyValues(propertyArray, arrayList);
        if (!arrayList.isEmpty()) {
            throw new UnsupportedQoS(arrayList.toArray(PropertySet.PROPERTY_ERROR_ARRAY_TEMPLATE));
        }
    }

    private void checkPropertyValues(Property[] propertyArray, List list) {
        for (int i = 0; i < propertyArray.length; ++i) {
            if ("ConnectionReliability".equals(propertyArray[i].name)) {
                try {
                    switch (propertyArray[i].value.extract_short()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            list.add(new PropertyError(QoSError_code.BAD_VALUE, propertyArray[i].name, new PropertyRange(connectionReliabilityLowValue_, connectionReliabilityHighValue_)));
                            break;
                        }
                    }
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    list.add(this.badType(propertyArray[i].name));
                }
                continue;
            }
            if ("EventReliability".equals(propertyArray[i].name)) {
                try {
                    switch (propertyArray[i].value.extract_short()) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            list.add(new PropertyError(QoSError_code.BAD_VALUE, propertyArray[i].name, new PropertyRange(connectionReliabilityLowValue_, connectionReliabilityHighValue_)));
                            break;
                        }
                    }
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    list.add(this.badType(propertyArray[i].name));
                }
                continue;
            }
            if ("OrderPolicy".equals(propertyArray[i].name)) {
                try {
                    switch (propertyArray[i].value.extract_short()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            list.add(new PropertyError(QoSError_code.BAD_VALUE, propertyArray[i].name, new PropertyRange(orderPolicyLowValue_, orderPolicyHighValue_)));
                            break;
                        }
                    }
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    list.add(this.badType(propertyArray[i].name));
                }
                continue;
            }
            if (!"DiscardPolicy".equals(propertyArray[i].name)) continue;
            try {
                switch (propertyArray[i].value.extract_short()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        list.add(new PropertyError(QoSError_code.BAD_VALUE, propertyArray[i].name, new PropertyRange(discardPolicyLowValue_, discardPolicyHighValue_)));
                        break;
                    }
                }
                continue;
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                list.add(this.badType(propertyArray[i].name));
            }
        }
    }

    static {
        validPerChannelQoS_.add("EventReliability");
        validPerChannelQoS_.add("ConnectionReliability");
        validPerChannelQoS_.add("Priority");
        validPerChannelQoS_.add("Timeout");
        validPerChannelQoS_.add("StartTimeSupported");
        validPerChannelQoS_.add("StopTimeSupported");
        validPerChannelQoS_.add("MaxEventsPerConsumer");
        validPerChannelQoS_.add("OrderPolicy");
        validPerChannelQoS_.add("DiscardPolicy");
        validPerChannelQoS_.add("MaximumBatchSize");
        validPerChannelQoS_.add("PacingInterval");
        validPerAdminQoS_ = new HashSet(validPerChannelQoS_);
        validPerAdminQoS_.remove("EventReliability");
        validPerProxyQoS_ = new HashSet(validPerAdminQoS_);
        validPerMessageQoS_ = new HashSet();
        validPerMessageQoS_.add("EventReliability");
        validPerMessageQoS_.add("Priority");
        validPerMessageQoS_.add("StartTime");
        validPerMessageQoS_.add("StopTime");
        validPerMessageQoS_.add("Timeout");
        connectionReliabilityHighValue_ = PropertySet.orb_.create_any();
        connectionReliabilityHighValue_.insert_short((short)1);
        connectionReliabilityLowValue_ = PropertySet.orb_.create_any();
        connectionReliabilityLowValue_.insert_short((short)0);
        orderPolicyLowValue_ = PropertySet.orb_.create_any();
        orderPolicyLowValue_.insert_short((short)0);
        orderPolicyHighValue_ = PropertySet.orb_.create_any();
        orderPolicyHighValue_.insert_short((short)3);
        discardPolicyLowValue_ = PropertySet.orb_.create_any();
        discardPolicyLowValue_.insert_short((short)0);
        discardPolicyHighValue_ = PropertySet.orb_.create_any();
        discardPolicyHighValue_.insert_short((short)3);
    }
}

