/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.CollectionsWrapper;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PushConsumer;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ProxyPushSupplierHelper;
import org.omg.CosNotifyChannelAdmin.ProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.ProxyPushSupplierPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyComm.NotifyPublishHelper;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.PortableServer.Servant;

public class ProxyPushSupplierImpl
extends AbstractProxySupplier
implements ProxyPushSupplierOperations {
    private PushConsumer pushConsumer_;
    private NotifyPublishOperations offerListener_;
    private boolean enabled_;
    private boolean active_;

    ProxyPushSupplierImpl(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
        this.setProxyType(ProxyType.PUSH_ANY);
        this.enabled_ = true;
    }

    public void disconnect_push_supplier() {
        this.dispose();
    }

    protected void disconnectClient() {
        this.pushConsumer_.disconnect_push_consumer();
        this.pushConsumer_ = null;
    }

    public void deliverMessage(Message message) throws Disconnected {
        if (this.isConnected()) {
            if (this.active_ && this.enabled_) {
                this.pushConsumer_.push(message.toAny());
                message.dispose();
            } else {
                this.enqueue(message);
            }
        } else {
            this.logger_.debug("Not connected");
        }
    }

    public void connect_any_push_consumer(PushConsumer pushConsumer) throws AlreadyConnected {
        this.assertNotConnected();
        this.pushConsumer_ = pushConsumer;
        this.connectClient(pushConsumer);
        this.active_ = true;
        try {
            this.offerListener_ = NotifyPublishHelper.narrow(pushConsumer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public List getSubsequentFilterStages() {
        return CollectionsWrapper.singletonList(this);
    }

    public MessageConsumer getMessageConsumer() {
        return this;
    }

    public boolean hasMessageConsumer() {
        return true;
    }

    public synchronized void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        this.assertConnected();
        if (!this.active_) {
            throw new ConnectionAlreadyInactive();
        }
        this.active_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverPendingMessages() throws Disconnected {
        Message[] messageArray = this.getAllMessages();
        try {
            for (int i = 0; i < messageArray.length; ++i) {
                this.pushConsumer_.push(messageArray[i].toAny());
            }
            java.lang.Object var4_3 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_4 = null;
            for (int i = 0; i < messageArray.length; ++i) {
                messageArray[i].dispose();
            }
            throw throwable;
        }
        for (int i = 0; i < messageArray.length; ++i) {
            messageArray[i].dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume_connection() throws NotConnected, ConnectionAlreadyActive {
        this.assertConnected();
        ProxyPushSupplierImpl proxyPushSupplierImpl = this;
        synchronized (proxyPushSupplierImpl) {
            if (this.active_) {
                throw new ConnectionAlreadyActive();
            }
            this.active_ = true;
        }
        try {
            this.deliverPendingMessages();
        }
        catch (Disconnected disconnected) {
            this.logger_.fatalError("illegal state: PushConsumer think it's disconnected. ProxyPushSupplier think it's connected", disconnected);
            this.dispose();
        }
    }

    public synchronized void enableDelivery() {
        this.enabled_ = true;
    }

    public synchronized void disableDelivery() {
        this.enabled_ = false;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new ProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxyPushSupplierHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    NotifyPublishOperations getOfferListener() {
        return this.offerListener_;
    }
}

