/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.TimerEventSupplier;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.jacorb.util.Environment;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PullSupplier;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ProxyConsumerHelper;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyComm.NotifySubscribeHelper;
import org.omg.CosNotifyComm.NotifySubscribeOperations;
import org.omg.PortableServer.Servant;

public class ProxyPullConsumerImpl
extends AbstractProxyConsumer
implements ProxyPullConsumerOperations,
TimerEventSupplier {
    private Sync pullSync_ = new Semaphore(1L);
    private PullSupplier pullSupplier_;
    private NotifySubscribeOperations subscriptionListener_;
    private boolean active_ = false;
    private long pollInterval_;
    private java.lang.Object taskId_;
    private Runnable runQueueThis_;
    private int runCounter_;
    private long runTime_;
    private int successfulPull_;

    void configurePullIntervall() {
        this.pollInterval_ = 1000L;
        if (Environment.getProperty("jacorb.notification.supplier.poll_intervall") != null) {
            try {
                this.pollInterval_ = Long.parseLong(Environment.getProperty("jacorb.notification.supplier.poll_intervall"));
            }
            catch (NumberFormatException numberFormatException) {
                this.logger_.error("Invalid Number Format for Property jacorb.notification.supplier.poll_intervall", numberFormatException);
            }
        }
    }

    void configureTimerCallback() {
        this.runQueueThis_ = new Runnable(){

            public void run() {
                ProxyPullConsumerImpl.this.scheduleTimedPullTask(ProxyPullConsumerImpl.this);
            }
        };
    }

    ProxyPullConsumerImpl(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
        this.setProxyType(ProxyType.PULL_ANY);
        this.configurePullIntervall();
        this.configureTimerCallback();
    }

    public void disconnect_pull_consumer() {
        this.dispose();
    }

    protected void disconnectClient() {
        this.stopTask();
        this.pullSupplier_.disconnect_pull_supplier();
        this.pullSupplier_ = null;
    }

    public synchronized void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        this.assertConnected();
        if (!this.active_) {
            throw new ConnectionAlreadyInactive();
        }
        this.active_ = false;
        this.stopTask();
    }

    public synchronized void resume_connection() throws ConnectionAlreadyActive, NotConnected {
        this.assertConnected();
        if (this.active_) {
            throw new ConnectionAlreadyActive();
        }
        this.startTask();
    }

    public void runPullEvent() throws Disconnected {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.runPullEventInternal();
        }
        catch (InterruptedException interruptedException) {
            this.logger_.error("pull was interrupted", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPullEventInternal() throws InterruptedException, Disconnected {
        BooleanHolder booleanHolder = new BooleanHolder();
        Any any = null;
        try {
            this.pullSync_.acquire();
            ++this.runCounter_;
            long l = System.currentTimeMillis();
            any = this.pullSupplier_.try_pull(booleanHolder);
            this.runTime_ += System.currentTimeMillis() - l;
        }
        finally {
            this.pullSync_.release();
        }
        if (booleanHolder.value) {
            ++this.successfulPull_;
            Message message = this.messageFactory_.newMessage(any, (AbstractProxyConsumerI)this);
            this.checkMessageProperties(message);
            this.getTaskProcessor().processMessage(message);
        }
    }

    public void connect_any_pull_supplier(PullSupplier pullSupplier) throws AlreadyConnected {
        this.assertNotConnected();
        this.active_ = true;
        this.pullSupplier_ = pullSupplier;
        this.connectClient(pullSupplier);
        this.startTask();
        try {
            this.subscriptionListener_ = NotifySubscribeHelper.narrow(this.pullSupplier_);
        }
        catch (Throwable throwable) {
            this.logger_.info("disable subscription_change for PullSupplier");
        }
    }

    private synchronized void startTask() {
        if (this.taskId_ == null) {
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(this.pollInterval_, this.runQueueThis_, true);
        }
    }

    private synchronized void stopTask() {
        if (this.taskId_ != null) {
            this.getTaskProcessor().cancelTask(this.taskId_);
            this.taskId_ = null;
        }
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new ProxyPullConsumerPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxyConsumerHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    public long getPollInterval() {
        return this.pollInterval_;
    }

    public long getPullTimer() {
        return this.runTime_;
    }

    public int getPullCounter() {
        return this.runCounter_;
    }

    public int getSuccessfulPullCounter() {
        return this.successfulPull_;
    }

    NotifySubscribeOperations getSubscriptionListener() {
        return this.subscriptionListener_;
    }
}

