/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.servant.PropertySetListener;
import org.jacorb.util.Debug;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;

public abstract class PropertySet {
    static ORB orb_ = ORB.init();
    static final PropertyError[] PROPERTY_ERROR_ARRAY_TEMPLATE = new PropertyError[0];
    static final PropertyRange EMPTY_PROPERTY_RANGE = new PropertyRange(orb_.create_any(), orb_.create_any());
    private Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private Map listeners_ = new HashMap();
    private boolean modified_ = true;
    private Map properties_ = new HashMap();
    private Property[] arrayView_ = null;

    protected PropertySet() {
    }

    protected PropertySet(Property[] propertyArray) {
        this.properties_ = PropertySet.getUniqueSet(propertyArray);
    }

    public void addPropertySetListener(String[] stringArray, PropertySetListener propertySetListener) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPropertySetListener(stringArray[i], propertySetListener);
        }
    }

    public void addPropertySetListener(String string, PropertySetListener propertySetListener) {
        List<PropertySetListener> list;
        if (!this.listeners_.containsKey(string)) {
            list = new ArrayList();
            this.listeners_.put(string, list);
        } else {
            list = (List)this.listeners_.get(string);
        }
        list.add(propertySetListener);
    }

    public Property[] toArray() {
        if (this.arrayView_ == null || this.modified_) {
            Property[] propertyArray = new Property[this.properties_.size()];
            Iterator iterator = this.properties_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                propertyArray[n++] = new Property(string, (Any)this.properties_.get(string));
            }
            this.arrayView_ = propertyArray;
            this.modified_ = false;
        }
        return this.arrayView_;
    }

    public String toString() {
        return this.properties_.toString();
    }

    public boolean containsKey(String string) {
        return this.properties_.containsKey(string);
    }

    public Any get(String string) {
        return (Any)this.properties_.get(string);
    }

    protected void set_properties(Property[] propertyArray) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < propertyArray.length; ++i) {
            Any any = null;
            if (this.properties_.containsKey(propertyArray[i].name)) {
                any = (Any)this.properties_.get(propertyArray[i].name);
            }
            this.properties_.put(propertyArray[i].name, propertyArray[i].value);
            this.logger_.debug("set " + propertyArray[i].name + " => " + propertyArray[i].value);
            if (!this.listeners_.containsKey(propertyArray[i].name) || propertyArray[i].value.equals(any)) continue;
            hashSet.addAll((List)this.listeners_.get(propertyArray[i].name));
        }
        this.modified_ = true;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            try {
                ((PropertySetListener)iterator.next()).actionPropertySetChanged(this);
            }
            catch (Exception exception) {
                this.logger_.error("exception in listener", exception);
            }
        }
    }

    abstract HashSet getValidNames();

    protected void checkPropertyExistence(Property[] propertyArray, List list) {
        for (int i = 0; i < propertyArray.length; ++i) {
            if (this.getValidNames().contains(propertyArray[i].name)) continue;
            list.add(new PropertyError(QoSError_code.BAD_PROPERTY, propertyArray[i].name, new PropertyRange(orb_.create_any(), orb_.create_any())));
        }
    }

    protected PropertyError badType(String string) {
        return new PropertyError(QoSError_code.BAD_TYPE, string, EMPTY_PROPERTY_RANGE);
    }

    private static Map getUniqueSet(Property[] propertyArray) {
        HashMap<String, Any> hashMap = new HashMap<String, Any>();
        for (int i = 0; i < propertyArray.length; ++i) {
            hashMap.put(propertyArray[i].name, propertyArray[i].value);
        }
        return hashMap;
    }
}

