/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.queue.EventQueue;
import org.jacorb.notification.queue.EventQueueFactory;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.PropertySet;
import org.jacorb.notification.servant.PropertySetListener;
import org.jacorb.notification.servant.ProxyPullSupplierImpl;
import org.jacorb.notification.servant.ProxyPushSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPullSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPullSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.jacorb.notification.util.TaskExecutor;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotifyChannelAdmin.ObtainInfoMode;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifyPublishOperations;
import org.omg.CosNotifyComm.NotifySubscribeOperations;

public abstract class AbstractProxySupplier
extends AbstractProxy
implements MessageConsumer,
NotifySubscribeOperations {
    private static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];
    private TaskExecutor taskExecutor_;
    private Disposable disposeTaskExecutor_;
    private EventQueue pendingMessages_;
    private int errorThreshold_;
    private Object pendingMessagesRefLock_ = new Object();
    private NotifyPublishOperations offerListener_;
    private PropertySetListener eventQueueConfigurationChangedCB = new PropertySetListener(){

        public void validateProperty(Property[] propertyArray, List list) {
        }

        public void actionPropertySetChanged(PropertySet propertySet) throws UnsupportedQoS {
            AbstractProxySupplier.this.configureEventQueue();
        }
    };

    protected AbstractProxySupplier(AbstractAdmin abstractAdmin, ChannelContext channelContext) {
        super(abstractAdmin, channelContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preActivate() throws UnsupportedQoS {
        Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_ = EventQueueFactory.newEventQueue(this.qosSettings_);
        }
        this.errorThreshold_ = Environment.getIntPropertyWithDefault("jacorb.notification.consumer.error_threshold", 3);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set Error Threshold to : " + this.errorThreshold_);
        }
        this.qosSettings_.addPropertySetListener(new String[]{"OrderPolicy", "DiscardPolicy"}, this.eventQueueConfigurationChangedCB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEventQueue() throws UnsupportedQoS {
        EventQueue eventQueue = EventQueueFactory.newEventQueue(this.qosSettings_);
        try {
            Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (!this.pendingMessages_.isEmpty()) {
                    Message[] messageArray = this.pendingMessages_.getAllEvents(true);
                    for (int i = 0; i < messageArray.length; ++i) {
                        eventQueue.put(messageArray[i]);
                    }
                }
                this.pendingMessages_ = eventQueue;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException.getMessage());
        }
    }

    public TaskExecutor getExecutor() {
        return this.taskExecutor_;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        if (this.taskExecutor_ != null) {
            throw new IllegalArgumentException("set only once");
        }
        this.taskExecutor_ = taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor, Disposable disposable) {
        this.setTaskExecutor(taskExecutor);
        this.disposeTaskExecutor_ = disposable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingMessages() {
        Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return !this.pendingMessages_.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Message message) {
        Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            this.pendingMessages_.put(message);
        }
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("added " + message + " to pending Messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getMessageBlocking() throws InterruptedException {
        Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            return this.pendingMessages_.getEvent(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message getMessageNoBlock() {
        Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getEvent(false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getAllMessages() {
        Object object = this.pendingMessagesRefLock_;
        synchronized (object) {
            try {
                return this.pendingMessages_.getAllEvents(false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getUpToMessages(int n) {
        try {
            Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                return this.pendingMessages_.getEvents(n, false);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getAtLeastMessages(int n) {
        try {
            Object object = this.pendingMessagesRefLock_;
            synchronized (object) {
                if (this.pendingMessages_.getSize() >= n) {
                    return this.pendingMessages_.getAllEvents(true);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public int getErrorThreshold() {
        return this.errorThreshold_;
    }

    public final void dispose() {
        super.dispose();
        if (this.disposeTaskExecutor_ != null) {
            this.disposeTaskExecutor_.dispose();
        }
    }

    public final ConsumerAdmin MyAdmin() {
        return ConsumerAdminHelper.narrow(this.admin_.activate());
    }

    public final void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(eventTypeArray, eventTypeArray2);
    }

    public final EventType[] obtain_offered_types(ObtainInfoMode obtainInfoMode) {
        this.logger_.debug("obtain_offered_types " + obtainInfoMode.value());
        EventType[] eventTypeArray = EMPTY_EVENT_TYPE_ARRAY;
        switch (obtainInfoMode.value()) {
            case 1: {
                this.registerListener();
                eventTypeArray = this.offerManager_.obtain_offered_types();
                break;
            }
            case 0: {
                eventTypeArray = this.offerManager_.obtain_offered_types();
                this.removeListener();
                break;
            }
            case 3: {
                this.registerListener();
                break;
            }
            case 2: {
                this.removeListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal ObtainInfoMode");
            }
        }
        return eventTypeArray;
    }

    private void registerListener() {
        NotifyPublishOperations notifyPublishOperations;
        if (this.offerListener_ == null && (notifyPublishOperations = this.getOfferListener()) != null) {
            this.offerListener_ = new NotifyPublishOperations(){

                public void offer_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
                    try {
                        notifyPublishOperations.offer_change(eventTypeArray, eventTypeArray2);
                    }
                    catch (NO_IMPLEMENT nO_IMPLEMENT) {
                        AbstractProxySupplier.this.logger_.info("disable offer_change for Consumer.", nO_IMPLEMENT);
                        AbstractProxySupplier.this.removeListener();
                    }
                    catch (InvalidEventType invalidEventType) {
                        AbstractProxySupplier.this.logger_.error("invalid event type", invalidEventType);
                    }
                }
            };
            this.offerManager_.addListener(this.offerListener_);
        }
    }

    private void removeListener() {
        if (this.offerListener_ != null) {
            this.offerManager_.removeListener(this.offerListener_);
            this.offerListener_ = null;
        }
    }

    abstract NotifyPublishOperations getOfferListener();

    static AbstractProxySupplier newProxyPullSupplier(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxySupplier abstractProxySupplier;
        switch (clientType.value()) {
            case 0: {
                abstractProxySupplier = new ProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxySupplier = new StructuredProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxySupplier = new SequenceProxyPullSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        return abstractProxySupplier;
    }

    static AbstractProxySupplier newProxyPushSupplier(AbstractAdmin abstractAdmin, ClientType clientType) {
        AbstractProxySupplier abstractProxySupplier;
        switch (clientType.value()) {
            case 0: {
                abstractProxySupplier = new ProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 1: {
                abstractProxySupplier = new StructuredProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            case 2: {
                abstractProxySupplier = new SequenceProxyPushSupplierImpl(abstractAdmin, abstractAdmin.getChannelContext());
                break;
            }
            default: {
                throw new BAD_PARAM("The ClientType: " + clientType.value() + " is unknown");
            }
        }
        return abstractProxySupplier;
    }
}

