/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.collections.AST;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.NumberValue;
import org.jacorb.notification.filter.etcl.TCLParserTokenTypes;
import org.jacorb.notification.filter.etcl.UnionPositionOperator;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.jacorb.util.Debug;

public class TCLCleanUp
extends AbstractTCLVisitor
implements TCLParserTokenTypes {
    Logger logger_ = Debug.getNamedLogger(this.getClass().getName());

    public void fix(AbstractTCLNode abstractTCLNode) {
        try {
            abstractTCLNode.acceptPostOrder(this);
        }
        catch (VisitorException visitorException) {
            this.logger_.fatalError("error during fix", visitorException);
            throw new RuntimeException(visitorException.getMessage());
        }
    }

    public void visitComponent(ETCLComponentName eTCLComponentName) throws VisitorException {
        this.insertComponentName(eTCLComponentName);
    }

    public void visitUnionPosition(UnionPositionOperator unionPositionOperator) throws VisitorException {
        this.fixUnionPosition(unionPositionOperator);
    }

    void insertComponentName(ETCLComponentName eTCLComponentName) {
        StringBuffer stringBuffer = new StringBuffer(eTCLComponentName.toString());
        for (AbstractTCLNode abstractTCLNode = eTCLComponentName.left(); abstractTCLNode != null; abstractTCLNode = (AbstractTCLNode)abstractTCLNode.getNextSibling()) {
            stringBuffer.append(abstractTCLNode.toString());
        }
        eTCLComponentName.setComponentName(stringBuffer.toString());
    }

    void fixUnionPosition(UnionPositionOperator unionPositionOperator) {
        AST aST = unionPositionOperator.getNextSibling();
        if (aST == null) {
            unionPositionOperator.setDefault();
        } else {
            switch (aST.getType()) {
                case 21: {
                    Double d = ((NumberValue)aST).getNumber();
                    unionPositionOperator.setPosition(d);
                    unionPositionOperator.setNextSibling(aST.getNextSibling());
                }
                case 12: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    unionPositionOperator.setDefault();
                }
            }
        }
    }
}

