/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractTaskPool;
import org.jacorb.notification.engine.FilterConsumerAdminTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.FilterSupplierAdminTask;
import org.jacorb.notification.engine.PushToConsumerTask;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.util.Debug;

public class TaskFactory
implements Disposable {
    private final Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private TaskProcessor taskProcessor_;
    private AbstractTaskPool filterProxyConsumerTaskPool_ = new AbstractTaskPool("FilterProxyConsumerTaskPool"){

        public Object newInstance() {
            return new FilterProxyConsumerTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool filterSupplierAdminTaskPool_ = new AbstractTaskPool("FilterSupplierAdminTaskPool"){

        public Object newInstance() {
            return new FilterSupplierAdminTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool filterConsumerAdminTaskPool_ = new AbstractTaskPool("FilterConsumerAdminTaskPool"){

        public Object newInstance() {
            return new FilterConsumerAdminTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool filterProxySupplierTaskPool_ = new AbstractTaskPool("FilterProxySupplierTaskPool"){

        public Object newInstance() {
            return new FilterProxySupplierTask(TaskFactory.this.taskProcessor_.getFilterTaskExecutor(), TaskFactory.this.taskProcessor_, TaskFactory.this);
        }
    };
    private AbstractTaskPool deliverTaskPool_ = new AbstractTaskPool("PushToConsumerTaskPool"){

        public Object newInstance() {
            PushToConsumerTask pushToConsumerTask = new PushToConsumerTask(TaskFactory.this.taskProcessor_, TaskFactory.this);
            return pushToConsumerTask;
        }
    };

    public TaskFactory(TaskProcessor taskProcessor) {
        this.taskProcessor_ = taskProcessor;
    }

    public void init() {
        this.filterProxyConsumerTaskPool_.init();
        this.filterProxySupplierTaskPool_.init();
        this.filterConsumerAdminTaskPool_.init();
        this.filterSupplierAdminTaskPool_.init();
        this.deliverTaskPool_.init();
    }

    public void dispose() {
        this.filterProxyConsumerTaskPool_.dispose();
        this.filterProxySupplierTaskPool_.dispose();
        this.filterConsumerAdminTaskPool_.dispose();
        this.filterSupplierAdminTaskPool_.dispose();
        this.deliverTaskPool_.dispose();
    }

    private FilterProxyConsumerTask newFilterProxyConsumerTask() {
        return (FilterProxyConsumerTask)this.filterProxyConsumerTaskPool_.lendObject();
    }

    FilterProxyConsumerTask newFilterProxyConsumerTask(Message message) {
        FilterProxyConsumerTask filterProxyConsumerTask = this.newFilterProxyConsumerTask();
        filterProxyConsumerTask.setMessage(message);
        filterProxyConsumerTask.setCurrentFilterStage(new FilterStage[]{message.getInitialFilterStage()});
        return filterProxyConsumerTask;
    }

    private FilterSupplierAdminTask newFilterSupplierAdminTask() {
        return (FilterSupplierAdminTask)this.filterSupplierAdminTaskPool_.lendObject();
    }

    FilterSupplierAdminTask newFilterSupplierAdminTask(FilterProxyConsumerTask filterProxyConsumerTask) {
        FilterSupplierAdminTask filterSupplierAdminTask = this.newFilterSupplierAdminTask();
        if (filterProxyConsumerTask.getFilterStageToBeProcessed().length != 1) {
            throw new RuntimeException();
        }
        filterSupplierAdminTask.setMessage(filterProxyConsumerTask.removeMessage());
        filterSupplierAdminTask.setCurrentFilterStage(filterProxyConsumerTask.getFilterStageToBeProcessed());
        filterSupplierAdminTask.setSkip(filterProxyConsumerTask.getSkip());
        return filterSupplierAdminTask;
    }

    private FilterConsumerAdminTask newFilterConsumerAdminTask() {
        return (FilterConsumerAdminTask)this.filterConsumerAdminTaskPool_.lendObject();
    }

    FilterConsumerAdminTask newFilterConsumerAdminTask(FilterSupplierAdminTask filterSupplierAdminTask) {
        FilterConsumerAdminTask filterConsumerAdminTask = this.newFilterConsumerAdminTask();
        filterConsumerAdminTask.setMessage(filterSupplierAdminTask.removeMessage());
        filterConsumerAdminTask.setCurrentFilterStage(filterSupplierAdminTask.getFilterStageToBeProcessed());
        return filterConsumerAdminTask;
    }

    private FilterProxySupplierTask newFilterProxySupplierTask() {
        return (FilterProxySupplierTask)this.filterProxySupplierTaskPool_.lendObject();
    }

    FilterProxySupplierTask newFilterProxySupplierTask(FilterConsumerAdminTask filterConsumerAdminTask) {
        FilterProxySupplierTask filterProxySupplierTask = this.newFilterProxySupplierTask();
        filterProxySupplierTask.setMessage(filterConsumerAdminTask.removeMessage());
        FilterStage[] filterStageArray = filterConsumerAdminTask.getFilterStageToBeProcessed();
        filterProxySupplierTask.setCurrentFilterStage(filterStageArray);
        return filterProxySupplierTask;
    }

    AbstractDeliverTask[] newPushToConsumerTask(FilterStage[] filterStageArray, Message message) {
        return this.newPushToConsumerTask(filterStageArray, message, FilterProxySupplierTask.EMPTY_MAP);
    }

    private AbstractDeliverTask[] newPushToConsumerTask(FilterStage[] filterStageArray, Message message, FilterProxySupplierTask.AlternateMessageMap alternateMessageMap) {
        AbstractDeliverTask[] abstractDeliverTaskArray = new AbstractDeliverTask[filterStageArray.length];
        for (int i = 0; i < filterStageArray.length; ++i) {
            abstractDeliverTaskArray[i] = (AbstractDeliverTask)this.deliverTaskPool_.lendObject();
            abstractDeliverTaskArray[i].setMessageConsumer(filterStageArray[i].getMessageConsumer());
            Message message2 = alternateMessageMap.getAlternateMessage(filterStageArray[i]);
            if (message2 != null) {
                abstractDeliverTaskArray[i].setMessage(message2);
                continue;
            }
            if (i == 0) {
                abstractDeliverTaskArray[i].setMessage(message);
                continue;
            }
            abstractDeliverTaskArray[i].setMessage((Message)message.clone());
        }
        return abstractDeliverTaskArray;
    }

    AbstractDeliverTask[] newPushToConsumerTask(FilterProxySupplierTask filterProxySupplierTask) {
        Message message = filterProxySupplierTask.removeMessage();
        FilterStage[] filterStageArray = filterProxySupplierTask.getFilterStageToBeProcessed();
        AbstractDeliverTask[] abstractDeliverTaskArray = this.newPushToConsumerTask(filterStageArray, message, filterProxySupplierTask.changedMessages_);
        return abstractDeliverTaskArray;
    }
}

