/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Date;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.FilterUtils;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

class StructuredEventMessage
extends AbstractMessage {
    private Any anyValue_;
    private StructuredEvent structuredEventValue_;
    private String constraintKey_;
    private Date startTime_;
    private Date stopTime_;
    private long timeout_ = 0L;
    private boolean isTimeoutSet_;
    private short priority_;

    StructuredEventMessage() {
    }

    public void setStructuredEventValue(StructuredEvent structuredEvent, boolean bl, boolean bl2) {
        this.structuredEventValue_ = structuredEvent;
        this.constraintKey_ = FilterUtils.calcConstraintKey(this.structuredEventValue_.header.fixed_header.event_type.domain_name, this.structuredEventValue_.header.fixed_header.event_type.type_name);
        this.parseQosSettings(bl, bl2);
    }

    public void reset() {
        super.reset();
        this.anyValue_ = null;
        this.structuredEventValue_ = null;
        this.constraintKey_ = null;
        this.startTime_ = null;
        this.stopTime_ = null;
        this.priority_ = 0;
    }

    public int getType() {
        return 1;
    }

    public synchronized Any toAny() {
        if (this.anyValue_ == null) {
            this.anyValue_ = sOrb.create_any();
            StructuredEventHelper.insert(this.anyValue_, this.structuredEventValue_);
        }
        return this.anyValue_;
    }

    public StructuredEvent toStructuredEvent() {
        return this.structuredEventValue_;
    }

    public String getConstraintKey() {
        return this.constraintKey_;
    }

    public EvaluationResult extractFilterableData(EvaluationContext evaluationContext, ComponentName componentName, String string) throws EvaluationException {
        Any any = evaluationContext.getDynamicEvaluator().evaluatePropertyList(this.structuredEventValue_.filterable_data, string);
        return EvaluationResult.fromAny(any);
    }

    public EvaluationResult extractVariableHeader(EvaluationContext evaluationContext, ComponentName componentName, String string) throws EvaluationException {
        Any any = evaluationContext.getDynamicEvaluator().evaluatePropertyList(this.structuredEventValue_.header.variable_header, string);
        return EvaluationResult.fromAny(any);
    }

    private void parseQosSettings(boolean bl, boolean bl2) {
        Property[] propertyArray = this.toStructuredEvent().header.variable_header;
        for (int i = 0; i < propertyArray.length; ++i) {
            if (bl && "StartTime".equals(propertyArray[i].name)) {
                this.startTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(propertyArray[i].value)));
                continue;
            }
            if ("StopTime".equals(propertyArray[i].name)) {
                this.stopTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(propertyArray[i].value)));
                continue;
            }
            if (bl2 && "Timeout".equals(propertyArray[i].name)) {
                this.setTimeout(TimeTHelper.extract(propertyArray[i].value));
                continue;
            }
            if (!"Priority".equals(propertyArray[i].name)) continue;
            this.priority_ = propertyArray[i].value.extract_short();
        }
    }

    public static long unixTime(UtcT utcT) {
        long l = (utcT.time - 122192928000000000L) / 10000L;
        if (utcT.tdf != 0) {
            l -= (long)(utcT.tdf * 60000);
        }
        return l;
    }

    public boolean hasStartTime() {
        return this.startTime_ != null;
    }

    public Date getStartTime() {
        return this.startTime_;
    }

    public boolean hasStopTime() {
        return this.stopTime_ != null;
    }

    public Date getStopTime() {
        return this.stopTime_;
    }

    public boolean hasTimeout() {
        return this.isTimeoutSet_;
    }

    public long getTimeout() {
        return this.timeout_;
    }

    private void setTimeout(long l) {
        this.isTimeoutSet_ = true;
        this.timeout_ = l;
    }

    public boolean match(Filter filter) throws UnsupportedFilterableData {
        return filter.match_structured(this.toStructuredEvent());
    }

    public int getPriority() {
        return this.priority_;
    }

    public boolean match(MappingFilter mappingFilter, AnyHolder anyHolder) throws UnsupportedFilterableData {
        return mappingFilter.match_structured(this.toStructuredEvent(), anyHolder);
    }
}

