/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.io.IOException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.FilterImpl;
import org.jacorb.notification.MappingFilterImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.util.Debug;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryPOA;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public class FilterFactoryImpl
extends FilterFactoryPOA
implements Disposable {
    public static final String CONSTRAINT_GRAMMAR = "EXTENDED_TCL";
    protected Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    protected ApplicationContext applicationContext_;
    protected boolean isApplicationContextCreatedHere_;
    private FilterFactory thisRef_;

    public FilterFactoryImpl() throws InvalidName, IOException, AdapterInactive {
        final ORB oRB = ORB.init(new String[0], null);
        POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
        this.applicationContext_ = new ApplicationContext(oRB, pOA, true);
        this.isApplicationContextCreatedHere_ = true;
        this.getFilterFactory();
        pOA.the_POAManager().activate();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                oRB.run();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public FilterFactoryImpl(ApplicationContext applicationContext) throws InvalidName {
        this.applicationContext_ = applicationContext;
        this.isApplicationContextCreatedHere_ = false;
    }

    public Filter create_filter(String string) throws InvalidGrammar {
        FilterImpl filterImpl = this.create_filter_servant(string);
        Filter filter = filterImpl._this(this.applicationContext_.getOrb());
        return filter;
    }

    FilterImpl create_filter_servant(String string) throws InvalidGrammar {
        if (CONSTRAINT_GRAMMAR.equals(string)) {
            FilterImpl filterImpl = new FilterImpl(this.applicationContext_, CONSTRAINT_GRAMMAR);
            filterImpl.init();
            return filterImpl;
        }
        throw new InvalidGrammar("Constraint Language '" + string + "' is not supported. Try one of the following: " + CONSTRAINT_GRAMMAR);
    }

    public MappingFilter create_mapping_filter(String string, Any any) throws InvalidGrammar {
        FilterImpl filterImpl = this.create_filter_servant(string);
        MappingFilterImpl mappingFilterImpl = new MappingFilterImpl(this.applicationContext_, filterImpl, any);
        MappingFilter mappingFilter = mappingFilterImpl._this(this.applicationContext_.getOrb());
        return mappingFilter;
    }

    public void dispose() {
        if (this.isApplicationContextCreatedHere_) {
            this.applicationContext_.getOrb().shutdown(true);
            this.applicationContext_.dispose();
        }
    }

    public synchronized FilterFactory getFilterFactory() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this._this(this.applicationContext_.getOrb());
        }
        return this.thisRef_;
    }

    public POA _default_POA() {
        return this.applicationContext_.getPoa();
    }
}

