/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.EventChannelFactoryImpl;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.interfaces.AdminEvent;
import org.jacorb.notification.interfaces.AdminEventListener;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.ProxyCreationRequestEvent;
import org.jacorb.notification.interfaces.ProxyCreationRequestEventListener;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AdminPropertySet;
import org.jacorb.notification.servant.ConsumerAdminTieImpl;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.servant.PropertySet;
import org.jacorb.notification.servant.QoSPropertySet;
import org.jacorb.notification.servant.SupplierAdminTieImpl;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.ConsumerAdmin;
import org.omg.CosEventChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimit;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelPOA;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.CosNotifyChannelAdmin.SupplierAdminHelper;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class EventChannelImpl
extends EventChannelPOA
implements Disposable,
ManageableServant {
    private Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private ORB orb_;
    private POA poa_;
    private EventChannel thisRef_;
    private FilterFactory defaultFilterFactory_;
    private EventChannelFactoryImpl eventChannelFactory_;
    private String ior_;
    private int key_;
    private FilterStageListManager listManager_;
    private java.lang.Object modifyConsumerAdminsLock_ = new java.lang.Object();
    private java.lang.Object modifySupplierAdminsLock_ = new java.lang.Object();
    private Map consumerAdminServants_ = new HashMap();
    private Map supplierAdminServants_ = new HashMap();
    private SynchronizedInt adminIdPool_ = new SynchronizedInt(1);
    private static final Integer DEFAULT_ADMIN_KEY = new Integer(0);
    private SynchronizedInt numberOfConsumers_ = new SynchronizedInt(0);
    private SynchronizedInt numberOfSuppliers_ = new SynchronizedInt(0);
    private int maxNumberOfConsumers_;
    private int maxNumberOfSuppliers_;
    private ChannelContext channelContext_;
    private SubscriptionManager subscriptionManager_ = new SubscriptionManager();
    private OfferManager offerManager_ = new OfferManager();
    private AdminPropertySet adminSettings_ = new AdminPropertySet();
    private QoSPropertySet qosSettings_ = new QoSPropertySet(0);
    private List listAdminEventListeners_ = new ArrayList();
    private ProxyCreationRequestEventListener proxyConsumerCreationListener_ = new ProxyCreationRequestEventListener(){

        public void actionProxyCreationRequest(ProxyCreationRequestEvent proxyCreationRequestEvent) throws AdminLimitExceeded {
            EventChannelImpl.this.addSupplier();
        }
    };
    private ProxyCreationRequestEventListener proxySupplierCreationListener_ = new ProxyCreationRequestEventListener(){

        public void actionProxyCreationRequest(ProxyCreationRequestEvent proxyCreationRequestEvent) throws AdminLimitExceeded {
            EventChannelImpl.this.addConsumer();
        }
    };
    private ProxyEventListener proxyConsumerDisposedListener_ = new ProxyEventListener(){

        public void actionProxyCreated(ProxyEvent proxyEvent) {
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            EventChannelImpl.this.removeConsumer();
        }
    };
    private ProxyEventListener proxySupplierDisposedListener_ = new ProxyEventListener(){

        public void actionProxyCreated(ProxyEvent proxyEvent) {
        }

        public void actionProxyDisposed(ProxyEvent proxyEvent) {
            EventChannelImpl.this.removeSupplier();
        }
    };

    EventChannelImpl(ChannelContext channelContext) {
        this.channelContext_ = channelContext;
        this.eventChannelFactory_ = channelContext.getEventChannelFactoryServant();
        this.defaultFilterFactory_ = channelContext.getDefaultFilterFactory();
        this.channelContext_.setEventChannelServant(this);
        this.channelContext_.setProxySupplierDisposedEventListener(this.proxySupplierDisposedListener_);
        this.channelContext_.setProxyConsumerDisposedEventListener(this.proxyConsumerDisposedListener_);
        this.listManager_ = new FilterStageListManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetchListData(FilterStageListManager.List list) {
                Map map = EventChannelImpl.this.consumerAdminServants_;
                synchronized (map) {
                    Iterator iterator = EventChannelImpl.this.consumerAdminServants_.keySet().iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        list.add((FilterStage)EventChannelImpl.this.consumerAdminServants_.get(n));
                    }
                }
            }
        };
    }

    public void preActivate() {
    }

    public void setKey(int n) {
        this.key_ = n;
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
    }

    public void setPOA(POA pOA) {
        this.poa_ = pOA;
    }

    public Servant getServant() {
        return this;
    }

    public synchronized Object activate() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this._this(this.orb_);
            try {
                this.ior_ = this.orb_.object_to_string(this.poa_.servant_to_reference(this.getServant()));
            }
            catch (Exception exception) {
                this.logger_.error("unable to access IOR", exception);
            }
        }
        return this.thisRef_;
    }

    private void addConsumer() throws AdminLimitExceeded {
        if (this.numberOfConsumers_.compareTo(this.maxNumberOfConsumers_) >= 0) {
            Any any = this.orb_.create_any();
            any.insert_long(this.maxNumberOfConsumers_);
            AdminLimit adminLimit = new AdminLimit("consumer limit", any);
            throw new AdminLimitExceeded("Consumer creation request exceeds AdminLimit.", adminLimit);
        }
        this.numberOfConsumers_.increment();
    }

    private void removeConsumer() {
        this.numberOfConsumers_.decrement();
    }

    private void addSupplier() throws AdminLimitExceeded {
        if (this.numberOfSuppliers_.compareTo(this.maxNumberOfSuppliers_) >= 0) {
            Any any = this.orb_.create_any();
            any.insert_long(this.maxNumberOfSuppliers_);
            AdminLimit adminLimit = new AdminLimit("suppliers limit", any);
            throw new AdminLimitExceeded("supplier creation request exceeds AdminLimit.", adminLimit);
        }
        this.numberOfSuppliers_.increment();
    }

    private void removeSupplier() {
        this.numberOfSuppliers_.decrement();
    }

    int getAdminId() {
        return this.adminIdPool_.increment();
    }

    private void fireAdminCreatedEvent(AbstractAdmin abstractAdmin) {
        Iterator iterator = this.listAdminEventListeners_.iterator();
        AdminEvent adminEvent = new AdminEvent(abstractAdmin);
        while (iterator.hasNext()) {
            ((AdminEventListener)iterator.next()).actionAdminCreated(adminEvent);
        }
    }

    private void fireAdminDestroyedEvent(AbstractAdmin abstractAdmin) {
        Iterator iterator = this.listAdminEventListeners_.iterator();
        AdminEvent adminEvent = new AdminEvent(abstractAdmin);
        while (iterator.hasNext()) {
            ((AdminEventListener)iterator.next()).actionAdminDestroyed(adminEvent);
        }
    }

    public void addAdminEventListener(AdminEventListener adminEventListener) {
        this.listAdminEventListeners_.add(adminEventListener);
    }

    public void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.listAdminEventListeners_.remove(adminEventListener);
    }

    private AbstractAdmin newConsumerAdmin(ChannelContext channelContext) {
        Integer n = new Integer(this.adminIdPool_.increment());
        return this.newConsumerAdmin(channelContext, n);
    }

    private AbstractAdmin newConsumerAdmin(ChannelContext channelContext, Integer n) {
        ConsumerAdminTieImpl consumerAdminTieImpl = new ConsumerAdminTieImpl(channelContext);
        this.configureAdmin(consumerAdminTieImpl);
        consumerAdminTieImpl.setID(n);
        return consumerAdminTieImpl;
    }

    private AbstractAdmin newSupplierAdmin(ChannelContext channelContext) {
        Integer n = new Integer(this.adminIdPool_.increment());
        return this.newSupplierAdmin(channelContext, n);
    }

    private AbstractAdmin newSupplierAdmin(ChannelContext channelContext, Integer n) {
        SupplierAdminTieImpl supplierAdminTieImpl = new SupplierAdminTieImpl(channelContext);
        this.configureAdmin(supplierAdminTieImpl);
        supplierAdminTieImpl.setID(n);
        return supplierAdminTieImpl;
    }

    private void configureAdmin(AbstractAdmin abstractAdmin) {
        abstractAdmin.setSubscriptionManager(this.subscriptionManager_);
        abstractAdmin.setOfferManager(this.offerManager_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAdmin getDefaultConsumerAdminServant() {
        AbstractAdmin abstractAdmin;
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.consumerAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newConsumerAdmin(this.channelContext_, DEFAULT_ADMIN_KEY);
                try {
                    abstractAdmin.set_qos(this.qosSettings_.toArray());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.fatalError("unable to set qos", unsupportedQoS);
                }
                this.fireAdminCreatedEvent(abstractAdmin);
                final Integer n = abstractAdmin.getID();
                this.consumerAdminServants_.put(n, abstractAdmin);
                abstractAdmin.setDisposeHook(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Map map = EventChannelImpl.this.consumerAdminServants_;
                        synchronized (map) {
                            EventChannelImpl.this.consumerAdminServants_.remove(n);
                            EventChannelImpl.this.listManager_.actionSourceModified();
                        }
                    }
                });
                this.listManager_.actionSourceModified();
            }
        }
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDefaultConsumerAdminActive() {
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            return this.consumerAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAdmin getDefaultSupplierAdminServant() {
        AbstractAdmin abstractAdmin;
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            abstractAdmin = (AbstractAdmin)this.supplierAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (abstractAdmin == null) {
                abstractAdmin = this.newSupplierAdmin(this.channelContext_, DEFAULT_ADMIN_KEY);
                try {
                    abstractAdmin.set_qos(this.qosSettings_.toArray());
                }
                catch (UnsupportedQoS unsupportedQoS) {
                    this.logger_.fatalError("", unsupportedQoS);
                }
                this.fireAdminCreatedEvent(abstractAdmin);
                final Integer n = abstractAdmin.getID();
                this.supplierAdminServants_.put(n, abstractAdmin);
                abstractAdmin.setDisposeHook(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Map map = EventChannelImpl.this.supplierAdminServants_;
                        synchronized (map) {
                            EventChannelImpl.this.supplierAdminServants_.remove(n);
                        }
                    }
                });
            }
        }
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDefaultSupplierAdminActive() {
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            return this.supplierAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    public EventChannelFactory MyFactory() {
        return EventChannelFactoryHelper.narrow(this.eventChannelFactory_.activate());
    }

    public org.omg.CosNotifyChannelAdmin.ConsumerAdmin default_consumer_admin() {
        return org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(this.getDefaultConsumerAdminServant().activate());
    }

    public SupplierAdmin default_supplier_admin() {
        return SupplierAdminHelper.narrow(this.getDefaultSupplierAdminServant().activate());
    }

    public FilterFactory default_filter_factory() {
        return this.defaultFilterFactory_;
    }

    public org.omg.CosNotifyChannelAdmin.ConsumerAdmin new_for_consumers(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.new_for_consumers_servant(interFilterGroupOperator, intHolder);
        this.fireAdminCreatedEvent(abstractAdmin);
        return org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(abstractAdmin.activate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAdmin new_for_consumers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newConsumerAdmin(this.channelContext_);
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        intHolder.value = abstractAdmin.getID();
        abstractAdmin.setIsIDPublic(true);
        try {
            abstractAdmin.set_qos(this.qosSettings_.toArray());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.error("err", unsupportedQoS);
        }
        abstractAdmin.addProxyCreationEventListener(this.proxySupplierCreationListener_);
        final Integer n = abstractAdmin.getID();
        abstractAdmin.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = EventChannelImpl.this.consumerAdminServants_;
                synchronized (map) {
                    EventChannelImpl.this.consumerAdminServants_.remove(n);
                    EventChannelImpl.this.listManager_.actionSourceModified();
                }
            }
        });
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            this.consumerAdminServants_.put(n, abstractAdmin);
            this.listManager_.actionSourceModified();
        }
        return abstractAdmin;
    }

    public SupplierAdmin new_for_suppliers(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.new_for_suppliers_servant(interFilterGroupOperator, intHolder);
        this.fireAdminCreatedEvent(abstractAdmin);
        return SupplierAdminHelper.narrow(abstractAdmin.activate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAdmin new_for_suppliers_servant(InterFilterGroupOperator interFilterGroupOperator, IntHolder intHolder) {
        AbstractAdmin abstractAdmin = this.newSupplierAdmin(this.channelContext_);
        intHolder.value = abstractAdmin.getID();
        abstractAdmin.setInterFilterGroupOperator(interFilterGroupOperator);
        abstractAdmin.setIsIDPublic(true);
        try {
            abstractAdmin.set_qos(this.qosSettings_.toArray());
        }
        catch (UnsupportedQoS unsupportedQoS) {
            this.logger_.fatalError("error setting qos", unsupportedQoS);
        }
        abstractAdmin.addProxyCreationEventListener(this.proxyConsumerCreationListener_);
        final Integer n = abstractAdmin.getID();
        abstractAdmin.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = EventChannelImpl.this.supplierAdminServants_;
                synchronized (map) {
                    EventChannelImpl.this.supplierAdminServants_.remove(n);
                }
            }
        });
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            this.supplierAdminServants_.put(n, abstractAdmin);
        }
        return abstractAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAdmin(AbstractAdmin abstractAdmin) {
        java.lang.Object object;
        Integer n = abstractAdmin.getID();
        if (n != null) {
            if (abstractAdmin instanceof SupplierAdminTieImpl) {
                object = this.modifySupplierAdminsLock_;
                synchronized (object) {
                    this.supplierAdminServants_.remove(n);
                }
            }
            if (abstractAdmin instanceof ConsumerAdminTieImpl) {
                object = this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    this.consumerAdminServants_.remove(n);
                }
            }
        }
        if (abstractAdmin instanceof ConsumerAdminTieImpl) {
            object = this.modifyConsumerAdminsLock_;
            synchronized (object) {
                this.listManager_.actionSourceModified();
            }
        }
        this.fireAdminDestroyedEvent(abstractAdmin);
    }

    public org.omg.CosNotifyChannelAdmin.ConsumerAdmin get_consumeradmin(int n) throws AdminNotFound {
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.consumerAdminServants_.containsKey(n2)) {
                AbstractAdmin abstractAdmin = (AbstractAdmin)this.consumerAdminServants_.get(n2);
                return org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper.narrow(abstractAdmin.activate());
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    public SupplierAdmin get_supplieradmin(int n) throws AdminNotFound {
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            Integer n2 = new Integer(n);
            if (this.supplierAdminServants_.containsKey(n2)) {
                AbstractAdmin abstractAdmin = (AbstractAdmin)this.supplierAdminServants_.get(n2);
                return SupplierAdminHelper.narrow(abstractAdmin.activate());
            }
            throw new AdminNotFound("ID " + n + " does not exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get_all_consumeradmins() {
        int[] nArray;
        int n = 0;
        if (this.isDefaultConsumerAdminActive()) {
            n = 1;
        }
        java.lang.Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            nArray = new int[this.consumerAdminServants_.size() + n];
            Iterator iterator = this.consumerAdminServants_.keySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                nArray[n2++] = (Integer)iterator.next();
            }
            if (n == 1) {
                nArray[n2] = 0;
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get_all_supplieradmins() {
        int[] nArray;
        int n = 0;
        if (this.isDefaultSupplierAdminActive()) {
            n = 1;
        }
        java.lang.Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            nArray = new int[this.supplierAdminServants_.size() + n];
            Iterator iterator = this.supplierAdminServants_.keySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                nArray[n2++] = (Integer)iterator.next();
            }
            if (n == 1) {
                nArray[n2] = 0;
            }
        }
        return nArray;
    }

    public Property[] get_admin() {
        return this.adminSettings_.toArray();
    }

    public Property[] get_qos() {
        return this.qosSettings_.toArray();
    }

    public void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.logger_.debug("set_qos");
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
    }

    public void set_admin(Property[] propertyArray) throws UnsupportedAdmin {
        this.adminSettings_.validate_admin(propertyArray);
        this.adminSettings_.set_admin(propertyArray);
        this.configureAdminLimits(this.adminSettings_);
    }

    private void configureAdminLimits(PropertySet propertySet) {
        Any any;
        this.maxNumberOfConsumers_ = Environment.getIntPropertyWithDefault("jacorb.notification.consumer.max_number", Integer.MAX_VALUE);
        this.maxNumberOfSuppliers_ = Environment.getIntPropertyWithDefault("jacorb.notification.supplier.max_number", Integer.MAX_VALUE);
        if (propertySet.containsKey("MaxConsumers")) {
            any = propertySet.get("MaxConsumers");
            this.maxNumberOfConsumers_ = any.extract_long();
        }
        if (propertySet.containsKey("MaxSuppliers")) {
            any = propertySet.get("MaxSuppliers");
            this.maxNumberOfSuppliers_ = any.extract_long();
        }
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfConsumers=" + this.maxNumberOfConsumers_);
            this.logger_.info("set MaxNumberOfSuppliers=" + this.maxNumberOfSuppliers_);
        }
    }

    public void destroy() {
        this.dispose();
    }

    public void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this));
        }
        catch (Exception exception) {
            this.logger_.error("Unable to deactivate EventChannel Object", exception);
            throw new RuntimeException();
        }
    }

    public void dispose() {
        Disposable disposable;
        this.deactivate();
        this.eventChannelFactory_.removeEventChannelServant(this.getKey());
        this.logger_.info("destroy ConsumerAdmins");
        Iterator iterator = this.consumerAdminServants_.values().iterator();
        while (iterator.hasNext()) {
            disposable = (Disposable)iterator.next();
            iterator.remove();
            disposable.dispose();
        }
        this.logger_.info("destroy SupplierAdmins");
        iterator = this.supplierAdminServants_.values().iterator();
        while (iterator.hasNext()) {
            disposable = (Disposable)iterator.next();
            iterator.remove();
            disposable.dispose();
        }
        this.listAdminEventListeners_.clear();
    }

    public ConsumerAdmin for_consumers() {
        return ConsumerAdminHelper.narrow(this.default_consumer_admin());
    }

    public org.omg.CosEventChannelAdmin.SupplierAdmin for_suppliers() {
        return org.omg.CosEventChannelAdmin.SupplierAdminHelper.narrow(this.default_supplier_admin());
    }

    public POA _default_POA() {
        return this.poa_;
    }

    public List getAllConsumerAdmins() {
        return this.listManager_.getList();
    }

    public int getKey() {
        return this.key_;
    }

    public String getIOR() {
        return this.ior_;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext_;
    }

    public boolean isPersistent() {
        return false;
    }

    public int getNumberOfConnectedClients() {
        return this.numberOfConsumers_.get() + this.numberOfSuppliers_.get();
    }
}

