/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.EventChannelImpl;
import org.jacorb.notification.FilterFactoryImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.EventChannelEvent;
import org.jacorb.notification.interfaces.EventChannelEventListener;
import org.jacorb.notification.servant.AdminPropertySet;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.servant.PropertySet;
import org.jacorb.notification.servant.QoSPropertySet;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ChannelNotFound;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryPOA;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class EventChannelFactoryImpl
extends EventChannelFactoryPOA
implements Disposable,
ManageableServant {
    private static final java.lang.Object[] INTEGER_ARRAY_TEMPLATE = new Integer[0];
    private static final String STANDARD_IMPL_NAME = "JacORB-NotificationService";
    private static final String NOTIFICATION_SERVICE_SHORTCUT = "NotificationService";
    private static final String EVENTCHANNEL_FACTORY_POA_NAME = "EventChannelFactoryPOA";
    private static final String OBJECT_NAME = "_ECFactory";
    private Logger logger_ = Debug.getNamedLogger(this.getClass().getName());
    private ORB orb_;
    private POA eventChannelFactoryPOA_;
    private POA rootPOA_;
    private EventChannelFactory thisFactory_;
    private FilterFactory defaultFilterFactory_;
    private FilterFactoryImpl defaultFilterFactoryServant_;
    private ApplicationContext applicationContext_;
    private ChannelContext channelContextTemplate_;
    private SynchronizedInt eventChannelIDPool_;
    private Map allChannels_ = new HashMap();
    private java.lang.Object allChannelsLock_ = this.allChannels_;
    private String ior_;
    private String corbaLoc_;
    private List listEventChannelEventListener_ = new ArrayList();
    static /* synthetic */ Class class$org$jacorb$notification$EventChannelFactoryImpl;
    static /* synthetic */ Class class$org$jacorb$notification$util$PatternWrapper;

    private EventChannelFactoryImpl() {
        this.initialize();
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
        try {
            this.rootPOA_ = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            this.applicationContext_ = new ApplicationContext(oRB, this.rootPOA_, true);
            Policy[] policyArray = new Policy[]{this.rootPOA_.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            this.eventChannelFactoryPOA_ = this.rootPOA_.create_POA(EVENTCHANNEL_FACTORY_POA_NAME, this.rootPOA_.the_POAManager(), policyArray);
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray[i].destroy();
            }
            this.setUpDefaultFilterFactory();
            this.rootPOA_.the_POAManager().activate();
            this.eventChannelFactoryPOA_.the_POAManager().activate();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void setPOA(POA pOA) {
    }

    protected ORB getORB() {
        return this.orb_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventChannel create_channel(Property[] propertyArray, Property[] propertyArray2, IntHolder intHolder) throws UnsupportedAdmin, UnsupportedQoS {
        try {
            int n;
            EventChannel eventChannel = null;
            intHolder.value = n = this.createChannelIdentifier();
            Integer n2 = new Integer(n);
            EventChannelImpl eventChannelImpl = this.create_channel_servant(n, propertyArray, propertyArray2);
            this.eventChannelServantCreated(eventChannelImpl);
            eventChannel = EventChannelHelper.narrow(eventChannelImpl.activate());
            if (this.logger_.isInfoEnabled()) {
                this.logger_.info("created EventChannel with ID: " + n);
            }
            java.lang.Object object = this.allChannelsLock_;
            synchronized (object) {
                this.allChannels_.put(n2, eventChannelImpl);
            }
            return eventChannel;
        }
        catch (UnsupportedQoS unsupportedQoS) {
            throw unsupportedQoS;
        }
        catch (UnsupportedAdmin unsupportedAdmin) {
            throw unsupportedAdmin;
        }
        catch (Exception exception) {
            this.logger_.fatalError("create_channel", exception);
            throw new RuntimeException();
        }
    }

    protected void eventChannelServantCreated(EventChannelImpl eventChannelImpl) {
        EventChannelEvent eventChannelEvent = new EventChannelEvent(eventChannelImpl);
        Iterator iterator = this.listEventChannelEventListener_.iterator();
        while (iterator.hasNext()) {
            ((EventChannelEventListener)iterator.next()).actionEventChannelCreated(eventChannelEvent);
        }
    }

    private void checkQoSSettings(PropertySet propertySet) throws UnsupportedQoS {
        short s;
        if (propertySet.containsKey("EventReliability")) {
            s = propertySet.get("EventReliability").extract_short();
            switch (s) {
                case 0: {
                    this.logger_.info("EventReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("EventReliability");
                }
                default: {
                    this.throwBadValue("EventReliability");
                }
            }
        }
        s = 0;
        if (propertySet.containsKey("ConnectionReliability")) {
            s = propertySet.get("ConnectionReliability").extract_short();
            switch (s) {
                case 0: {
                    this.logger_.info("ConnectionReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("ConnectionReliability");
                }
                default: {
                    this.throwBadValue("ConnectionReliability");
                }
            }
        }
    }

    public EventChannelImpl create_channel_servant(int n, Property[] propertyArray, Property[] propertyArray2) throws UnsupportedAdmin, UnsupportedQoS, ObjectNotActive, WrongPolicy, ServantAlreadyActive {
        if (this.logger_.isInfoEnabled()) {
            this.logger_.debug("create channel_servant id=" + n);
        }
        AdminPropertySet adminPropertySet = new AdminPropertySet(propertyArray2);
        QoSPropertySet qoSPropertySet = new QoSPropertySet(1, propertyArray);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("uniqueQoSProps: " + qoSPropertySet);
            this.logger_.debug("uniqueAdminProps: " + adminPropertySet);
        }
        this.checkQoSSettings(qoSPropertySet);
        ChannelContext channelContext = this.newChannelContext();
        channelContext.setMessageFactory(this.applicationContext_.getMessageFactory());
        channelContext.setORB(this.applicationContext_.getOrb());
        channelContext.setTaskProcessor(this.applicationContext_.getTaskProcessor());
        channelContext.setPOA(this.applicationContext_.getPoa());
        EventChannelImpl eventChannelImpl = new EventChannelImpl(channelContext);
        eventChannelImpl.setKey(n);
        eventChannelImpl.set_qos(qoSPropertySet.toArray());
        eventChannelImpl.set_admin(adminPropertySet.toArray());
        eventChannelImpl.setORB(this.applicationContext_.getOrb());
        eventChannelImpl.setPOA(this.applicationContext_.getPoa());
        return eventChannelImpl;
    }

    private void fireEventChannelDestroyed(EventChannelImpl eventChannelImpl) {
        if (!this.listEventChannelEventListener_.isEmpty()) {
            EventChannelEvent eventChannelEvent = new EventChannelEvent(eventChannelImpl);
            Iterator iterator = this.listEventChannelEventListener_.iterator();
            while (iterator.hasNext()) {
                ((EventChannelEventListener)iterator.next()).actionEventChannelDestroyed(eventChannelEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEventChannelServant(int n) {
        EventChannelImpl eventChannelImpl;
        java.lang.Object object = this.allChannelsLock_;
        synchronized (object) {
            eventChannelImpl = (EventChannelImpl)this.allChannels_.remove(new Integer(n));
        }
        this.fireEventChannelDestroyed(eventChannelImpl);
    }

    private void initializeEventChannelIDPool() {
        this.eventChannelIDPool_ = new SynchronizedInt(-1);
    }

    private void initialize() {
        this.initializeEventChannelIDPool();
    }

    private int createChannelIdentifier() {
        return this.eventChannelIDPool_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get_all_channels() {
        Integer[] integerArray;
        java.lang.Object object = this.allChannelsLock_;
        synchronized (object) {
            integerArray = (Integer[])this.allChannels_.keySet().toArray(INTEGER_ARRAY_TEMPLATE);
        }
        object = new int[integerArray.length];
        for (int i = integerArray.length - 1; i >= 0; --i) {
            object[i] = integerArray[i];
        }
        return object;
    }

    public EventChannel get_event_channel(int n) throws ChannelNotFound {
        Integer n2 = new Integer(n);
        java.lang.Object object = this.allChannelsLock_;
        synchronized (object) {
            if (this.allChannels_.containsKey(n2)) {
                return EventChannelHelper.narrow(((EventChannelImpl)this.allChannels_.get(n2)).activate());
            }
            throw new ChannelNotFound("The Channel " + n + " does not exist");
        }
    }

    public void addEventChannelEventListener(EventChannelEventListener eventChannelEventListener) {
        this.listEventChannelEventListener_.add(eventChannelEventListener);
    }

    public void removeEventChannelEventListener(EventChannelEventListener eventChannelEventListener) {
        this.listEventChannelEventListener_.remove(eventChannelEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ShutdownCallback shutdownCallback) {
        int n = 0;
        java.lang.Object object = this.allChannelsLock_;
        synchronized (object) {
            Iterator iterator = this.allChannels_.entrySet().iterator();
            while (iterator.hasNext()) {
                EventChannelImpl eventChannelImpl = (EventChannelImpl)iterator.next().getValue();
                n += eventChannelImpl.getNumberOfConnectedClients();
            }
        }
        int n2 = 4000;
        int n3 = n * n2;
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Connected Clients: " + n);
            this.logger_.info("Connection Timeout: " + n2 + " ms");
            this.logger_.info("Estimated Shutdowntime: " + n3 + " ms");
        }
        shutdownCallback.needTime(n3);
        this.logger_.info("NotificationService is going down");
        this.dispose();
        this.logger_.info("NotificationService down");
        shutdownCallback.shutdownComplete();
    }

    public void deactivate() {
        try {
            this.eventChannelFactoryPOA_.deactivate_object(this.eventChannelFactoryPOA_.servant_to_id(this.getServant()));
        }
        catch (Exception exception) {
            this.logger_.fatalError("unable to deactivate object", exception);
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.listEventChannelEventListener_.clear();
        java.lang.Object object = this.allChannelsLock_;
        synchronized (object) {
            Iterator iterator = this.allChannels_.entrySet().iterator();
            while (iterator.hasNext()) {
                EventChannelImpl eventChannelImpl = (EventChannelImpl)iterator.next().getValue();
                iterator.remove();
                eventChannelImpl.dispose();
            }
        }
        if (this.defaultFilterFactoryServant_ != null) {
            this.defaultFilterFactoryServant_.dispose();
        }
        this.applicationContext_.dispose();
        this.applicationContext_.getOrb().shutdown(true);
    }

    private void setUpDefaultFilterFactory() throws InvalidName {
        String string = Environment.getProperty("jacorb.notification.default_filter_factory", "builtin");
        if (!string.equals("builtin")) {
            try {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("try to set default_filter_factory to '" + string + "'");
                }
                this.defaultFilterFactory_ = FilterFactoryHelper.narrow(this.getORB().string_to_object(string));
            }
            catch (Throwable throwable) {
                this.logger_.error("Could not resolve FilterFactory: '" + string + "'. Will default to builtin FilterFactory.", throwable);
            }
        }
        if (this.defaultFilterFactory_ == null) {
            this.logger_.info("Create FilterFactory");
            this.defaultFilterFactoryServant_ = new FilterFactoryImpl(this.applicationContext_);
            this.defaultFilterFactory_ = this.defaultFilterFactoryServant_._this(this.orb_);
        }
    }

    public void preActivate() {
    }

    public String getCorbaLoc() {
        return this.corbaLoc_;
    }

    private String createCorbaLoc(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("corbaloc::");
        stringBuffer.append(this.getLocalAddress());
        stringBuffer.append(":");
        stringBuffer.append(this.getLocalPort());
        stringBuffer.append("/");
        stringBuffer.append(NOTIFICATION_SERVICE_SHORTCUT);
        return stringBuffer.toString();
    }

    private int getLocalPort() {
        return ((org.jacorb.orb.ORB)this.applicationContext_.getOrb()).getBasicAdapter().getPort();
    }

    private String getLocalAddress() {
        return ((org.jacorb.orb.ORB)this.applicationContext_.getOrb()).getBasicAdapter().getAddress();
    }

    private String objectIdToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("%");
            String string = Integer.toHexString(byArray[i]).toUpperCase();
            if (string.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getIOR() {
        return this.ior_;
    }

    public EventChannelFactory getEventChannelFactory() {
        return this.thisFactory_;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext_;
    }

    public Servant getServant() {
        return this;
    }

    public synchronized Object activate() {
        if (this.thisFactory_ == null) {
            try {
                byte[] byArray = OBJECT_NAME.getBytes();
                this.eventChannelFactoryPOA_.activate_object_with_id(byArray, this);
                this.thisFactory_ = EventChannelFactoryHelper.narrow(this.eventChannelFactoryPOA_.id_to_reference(byArray));
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("activated EventChannelFactory with OID '" + new String(byArray) + "' on '" + this.eventChannelFactoryPOA_.the_name() + "'");
                }
                this.ior_ = this.orb_.object_to_string(this.eventChannelFactoryPOA_.id_to_reference(byArray));
                this.corbaLoc_ = this.createCorbaLoc(this.eventChannelFactoryPOA_.the_name(), byArray);
                ((org.jacorb.orb.ORB)this.orb_).addObjectKey(NOTIFICATION_SERVICE_SHORTCUT, this.ior_);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        return this.thisFactory_;
    }

    void throwPersistentNotSupported(String string) throws UnsupportedQoS {
        Any any = this.applicationContext_.getOrb().create_any();
        Any any2 = this.applicationContext_.getOrb().create_any();
        any.insert_short((short)0);
        any2.insert_short((short)0);
        UnsupportedQoS unsupportedQoS = new UnsupportedQoS(new PropertyError[]{new PropertyError(QoSError_code.UNSUPPORTED_VALUE, string, new PropertyRange(any, any2))});
        throw unsupportedQoS;
    }

    void throwBadValue(String string) throws UnsupportedQoS {
        Any any = this.applicationContext_.getOrb().create_any();
        Any any2 = this.applicationContext_.getOrb().create_any();
        any.insert_short((short)0);
        any2.insert_short((short)0);
        UnsupportedQoS unsupportedQoS = new UnsupportedQoS("The specified Property Value is not supported", new PropertyError[]{new PropertyError(QoSError_code.BAD_VALUE, string, new PropertyRange(any, any2))});
        throw unsupportedQoS;
    }

    public POA _default_POA() {
        return this.eventChannelFactoryPOA_;
    }

    private ChannelContext newChannelContext() {
        ChannelContext channelContext = new ChannelContext();
        channelContext.setDefaultFilterFactory(this.defaultFilterFactory_);
        channelContext.setEventChannelFactoryServant(this);
        return channelContext;
    }

    private static void help() {
        System.out.println("Usage: ntfy [-printIOR] [-printCorbaloc] [-writeIOR <filename>] [-registerName <nameId>[.<nameKind>]] [-port <oaPort>] [-channels <channels>] [-help]");
        System.exit(0);
    }

    public static EventChannelFactoryImpl newFactory() throws Exception {
        return EventChannelFactoryImpl.newFactory(new String[0]);
    }

    public static EventChannelFactoryImpl newFactory(String[] stringArray) throws Exception {
        NameComponent[] nameComponentArray;
        java.lang.Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        int n = 0;
        java.lang.Object object2 = null;
        String string3 = "";
        boolean bl4 = false;
        Logger logger = Debug.getNamedLogger((class$org$jacorb$notification$EventChannelFactoryImpl == null ? (class$org$jacorb$notification$EventChannelFactoryImpl = EventChannelFactoryImpl.class$("org.jacorb.notification.EventChannelFactoryImpl")) : class$org$jacorb$notification$EventChannelFactoryImpl).getName() + ".init");
        (class$org$jacorb$notification$util$PatternWrapper == null ? (class$org$jacorb$notification$util$PatternWrapper = EventChannelFactoryImpl.class$("org.jacorb.notification.util.PatternWrapper")) : class$org$jacorb$notification$util$PatternWrapper).getName();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-printIOR")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-printCorbaloc")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-help")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-port")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-channels")) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-writeIOR")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-registerName")) {
                    object = stringArray[++i];
                    int n2 = ((String)object).indexOf(".");
                    if (((String)object).lastIndexOf(".") != n2) {
                        throw new IllegalArgumentException((String)object + ": argument to -registerName should be " + "<nameId> or <nameId>.<nameKind>");
                    }
                    if (n2 != -1) {
                        object2 = ((String)object).substring(0, n2);
                        string3 = ((String)object).substring(n2 + 1);
                        continue;
                    }
                    object2 = object;
                    continue;
                }
                if (stringArray[i].equals("-memoryInfo")) {
                    bl4 = true;
                    continue;
                }
                System.out.println("Unknown argument: " + stringArray[i]);
                EventChannelFactoryImpl.help();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = true;
        }
        if (bl) {
            EventChannelFactoryImpl.help();
            System.exit(0);
        }
        Properties properties = new Properties();
        properties.put("jacorb.implname", STANDARD_IMPL_NAME);
        if (string2 != null) {
            properties.put("OAPort", string2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Starting ORB with Properties: " + properties);
        }
        object = ORB.init(new String[0], properties);
        EventChannelFactoryImpl eventChannelFactoryImpl = new EventChannelFactoryImpl();
        eventChannelFactoryImpl.setORB((ORB)object);
        eventChannelFactoryImpl.activate();
        for (int i = 0; i < n; ++i) {
            nameComponentArray = new IntHolder();
            eventChannelFactoryImpl.create_channel(new Property[0], new Property[0], (IntHolder)nameComponentArray);
        }
        if (bl2) {
            System.out.println(eventChannelFactoryImpl.getIOR());
        }
        if (string != null) {
            logger.info("Writing IOR to file:" + string);
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println(eventChannelFactoryImpl.getIOR());
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                logger.error("Could not write the IOR to file:" + string, exception);
            }
        }
        if (object2 != null) {
            NamingContext namingContext = NamingContextHelper.narrow(((ORB)object).resolve_initial_references("NameService"));
            nameComponentArray = new NameComponent[]{new NameComponent((String)object2, string3)};
            logger.info("namingContext.rebind(" + (String)object2 + (string3 != null && string3.length() > 0 ? "." + string3 : "") + " => " + eventChannelFactoryImpl.getCorbaLoc() + ")");
            namingContext.rebind(nameComponentArray, eventChannelFactoryImpl.getEventChannelFactory());
        }
        if (bl3) {
            System.out.println(eventChannelFactoryImpl.getCorbaLoc());
        }
        Thread thread = new Thread(new Runnable((ORB)object){
            private final /* synthetic */ ORB val$_orb;
            {
                this.val$_orb = oRB;
            }

            public void run() {
                this.val$_orb.run();
            }
        });
        thread.setName("Notification ORB Runner Thread");
        thread.setDaemon(false);
        thread.start();
        logger.info("NotificationService up");
        return eventChannelFactoryImpl;
    }

    public static void main(String[] stringArray) throws Exception {
        EventChannelFactoryImpl.newFactory(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface ShutdownCallback {
        public void needTime(int var1);

        public void shutdownComplete();
    }
}

