/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming.namemanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jacorb.naming.namemanager.ContextNode;
import org.jacorb.naming.namemanager.NSPrefsDlg;
import org.jacorb.naming.namemanager.NSTree;
import org.jacorb.naming.namemanager.Updater;
import org.omg.CORBA.UserException;

public class Handler
extends WindowAdapter
implements ActionListener,
MouseListener,
KeyListener {
    int updateInterval;
    NSTree tree;
    Component frame;
    JDialog dlg;
    JTextField editName;
    JPopupMenu popup;
    Updater updater;

    public Handler(Component component, NSTree nSTree) {
        this.frame = component;
        this.tree = nSTree;
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("New context");
        JMenuItem jMenuItem2 = new JMenuItem("Unbind name");
        this.popup.add(jMenuItem);
        this.popup.add(jMenuItem2);
        jMenuItem.addActionListener(this);
        jMenuItem2.addActionListener(this);
        this.updateInterval = 10;
        this.updater = new Updater(this.tree, this.updateInterval);
        this.updater.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Quit")) {
            System.exit(0);
        } else if (actionEvent.getActionCommand().equals("Unbind name")) {
            this.tree.unbind();
        } else if (actionEvent.getActionCommand().equals("New context")) {
            try {
                this.tree.bind(JOptionPane.showInputDialog(this.frame, "Name of the new context", "Create new context", 3));
            }
            catch (UserException userException) {
                JOptionPane.showMessageDialog(this.frame, userException.getClass().getName() + (userException.getMessage() != null ? ":" + userException.getMessage() : ""), "Exception", 1);
            }
        } else if (actionEvent.getActionCommand().equals("About...")) {
            JOptionPane.showMessageDialog(this.frame, "JacORB NameManager 1.1\n(C) 1998-2003 Gerald Brose, Wei-ju Wu & Volker Siegel\nFreie Universitaet Berlin", "About", 1);
        } else if (actionEvent.getActionCommand().equals("Options")) {
            NSPrefsDlg nSPrefsDlg = new NSPrefsDlg((Frame)this.frame, this.updateInterval);
            nSPrefsDlg.pack();
            nSPrefsDlg.show();
            if (nSPrefsDlg.isOk) {
                this.updater.setSeconds(nSPrefsDlg.updateInterval);
            }
        } else {
            throw new RuntimeException("Should not happen");
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            this.tree.unbind();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
            this.popup.pack();
            this.popup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        } else {
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
                ((ContextNode)defaultMutableTreeNode.getUserObject()).display();
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }
}

