/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.naming.BindingIteratorImpl;
import org.jacorb.naming.Name;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;

public class NamingContextImpl
extends NamingContextExtPOA
implements Serializable {
    private Hashtable names = new Hashtable();
    private Hashtable contexts = new Hashtable();
    private static Logger logger = Debug.getNamedLogger("jacorb.naming");
    private transient POA poa;
    private static POA rootPoa;
    private static ORB orb;
    private int child_count;
    private boolean destroyed = false;

    public void bind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        if (object == null) {
            throw new BAD_PARAM();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (name2 == null) {
            if (this.names.containsKey(name)) {
                Object object2 = (Object)this.names.get(name);
                if (object2._non_existent()) {
                    this.rebind(name.components(), object);
                    return;
                }
                throw new AlreadyBound();
            }
            if (this.contexts.containsKey(name)) {
                Object object3 = (Object)this.contexts.get(name);
                if (object3._non_existent()) {
                    this.unbind(name.components());
                }
                throw new AlreadyBound();
            }
            if (this.names.put(name, object) != null) {
                throw new CannotProceed(this._this(), name.components());
            }
            if (logger.isInfoEnabled()) {
                logger.info("Bound name: " + name.toString());
            }
        } else {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExtHelper.narrow(this.resolve(name2.components())).bind(nameComponentArray2, object);
        }
    }

    public void rebind(NameComponent[] nameComponentArray, Object object) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        if (object == null) {
            throw new BAD_PARAM();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (this.contexts.containsKey(name)) {
            throw new NotFound(NotFoundReason.not_object, new NameComponent[]{nameComponent});
        }
        Object object2 = (Object)this.names.remove(name);
        if (object2 != null) {
            object2._release();
        }
        if (name2 == null) {
            this.names.put(name, object);
            if (logger.isInfoEnabled()) {
                logger.info("re-Bound name: " + name.toString());
            }
        } else {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.resolve(name2.components()));
            if (namingContextExt == null) {
                throw new CannotProceed();
            }
            namingContextExt.rebind(nameComponentArray2, object);
        }
    }

    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        if (namingContext == null) {
            throw new BAD_PARAM();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (this.names.containsKey(name)) {
            throw new NotFound(NotFoundReason.not_context, new NameComponent[]{nameComponent});
        }
        Object object = (Object)this.contexts.remove(name);
        if (object != null) {
            object._release();
        }
        if (name2 == null) {
            this.contexts.put(name, namingContext);
            if (logger.isInfoEnabled()) {
                logger.info("Re-Bound context: " + name.baseNameComponent().id);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (name2 == null) {
            if (this.names.containsKey(name)) {
                Object object = (Object)this.names.get(name);
                if (!object._non_existent()) throw new AlreadyBound();
                this.unbind(name.components());
            } else if (this.contexts.containsKey(name)) {
                Object object = (Object)this.contexts.get(name);
                if (!object._non_existent()) throw new AlreadyBound();
                this.rebind_context(name.components(), namingContext);
                return;
            }
            if (this.contexts.put(name, namingContext) != null) {
                throw new CannotProceed(this._this(), name.components());
            }
            this.contexts.put(name, namingContext);
            if (!logger.isInfoEnabled()) return;
            logger.info("Bound context: " + name.toString());
            return;
        } else {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExtHelper.narrow(this.resolve(name2.components())).bind_context(nameComponentArray2, namingContext);
        }
    }

    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.new_context());
        this.bind_context(nameComponentArray, namingContextExt);
        if (namingContextExt == null) {
            throw new CannotProceed();
        }
        return namingContextExt;
    }

    private void cleanup() {
        Name name;
        if (!Environment.isPropertyOn("jacorb.naming.purge")) {
            return;
        }
        Vector<Name> vector = new Vector<Name>();
        Enumeration enumeration = this.names.keys();
        while (enumeration.hasMoreElements()) {
            name = (Name)enumeration.nextElement();
            if (!((Object)this.names.get(name))._non_existent()) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Removing name " + name.baseNameComponent().id);
            }
            vector.addElement(name);
        }
        if (vector.size() > 0) {
            int n = vector.size();
            while (n-- > 0) {
                this.names.remove((Name)vector.elementAt(n));
            }
            vector.removeAllElements();
        }
        enumeration = this.contexts.keys();
        while (enumeration.hasMoreElements()) {
            name = (Name)enumeration.nextElement();
            if (!((Object)this.contexts.get(name))._non_existent()) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Removing context " + name.baseNameComponent().id);
            }
            vector.addElement(name);
        }
        if (vector.size() > 0) {
            int n = vector.size();
            while (n-- > 0) {
                this.contexts.remove((Name)vector.elementAt(n));
            }
            vector.removeAllElements();
        }
    }

    public void destroy() throws NotEmpty {
        if (this.destroyed) {
            return;
        }
        if (!this.names.isEmpty() || !this.contexts.isEmpty()) {
            throw new NotEmpty();
        }
        this.names = null;
        this.contexts = null;
        this.destroyed = true;
    }

    public int how_many() {
        if (this.destroyed) {
            return 0;
        }
        return this.names.size() + this.contexts.size();
    }

    private Binding[] list() {
        int n;
        this.cleanup();
        Enumeration enumeration = this.names.keys();
        Enumeration enumeration2 = this.contexts.keys();
        Binding[] bindingArray = new Binding[n];
        for (n = this.how_many(); enumeration.hasMoreElements() && n > 0; --n) {
            bindingArray[n - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
        }
        while (enumeration2.hasMoreElements() && n > 0) {
            bindingArray[n - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
            --n;
        }
        return bindingArray;
    }

    public void list(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        Binding[] bindingArray;
        int n2;
        if (this.destroyed) {
            return;
        }
        this.cleanup();
        Enumeration enumeration = this.names.keys();
        Enumeration enumeration2 = this.contexts.keys();
        if (n < n2) {
            int n3;
            bindingArray = new Binding[n];
            for (n3 = n; enumeration.hasMoreElements() && n3 > 0; --n3) {
                bindingArray[n3 - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
            }
            while (enumeration2.hasMoreElements() && n3 > 0) {
                bindingArray[n3 - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
                --n3;
            }
            Binding[] bindingArray2 = new Binding[n2 -= n];
            while (enumeration.hasMoreElements() && n2 > 0) {
                bindingArray2[n2 - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
                --n2;
            }
            while (enumeration2.hasMoreElements() && n2 > 0) {
                bindingArray2[n2 - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
                --n2;
            }
            Object object = null;
            try {
                byte[] byArray = rootPoa.activate_object(new BindingIteratorImpl(bindingArray2));
                object = rootPoa.id_to_reference(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bindingIteratorHolder.value = BindingIteratorHelper.narrow(object);
        } else {
            bindingArray = new Binding[n2];
            for (n2 = this.how_many(); enumeration.hasMoreElements() && n2 > 0; --n2) {
                bindingArray[n2 - 1] = new Binding(((Name)enumeration.nextElement()).components(), BindingType.nobject);
            }
            while (enumeration2.hasMoreElements() && n2 > 0) {
                bindingArray[n2 - 1] = new Binding(((Name)enumeration2.nextElement()).components(), BindingType.ncontext);
                --n2;
            }
        }
        bindingListHolder.value = bindingArray;
    }

    public NamingContext new_context() {
        if (this.destroyed) {
            return null;
        }
        Object object = null;
        try {
            byte[] byArray = (new String(this.poa.servant_to_id(this)) + "_ctx" + ++this.child_count).getBytes();
            object = this.poa.create_reference_with_id(byArray, "IDL:omg.org/CosNaming/NamingContextExt:1.0");
            if (logger.isInfoEnabled()) {
                logger.info("New context.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return NamingContextExtHelper.narrow(object);
    }

    public Object resolve(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        Name name = new Name(nameComponentArray[0]);
        if (nameComponentArray.length > 1) {
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow((Object)this.contexts.get(name));
            if (namingContextExt == null || namingContextExt._non_existent()) {
                throw new NotFound(NotFoundReason.missing_node, nameComponentArray);
            }
            NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length - 1];
            for (int i = 1; i < nameComponentArray.length; ++i) {
                nameComponentArray2[i - 1] = nameComponentArray[i];
            }
            return namingContextExt.resolve(nameComponentArray2);
        }
        Object object = null;
        object = (Object)this.contexts.get(name);
        if (object == null) {
            object = (Object)this.names.get(name);
        }
        if (object == null) {
            throw new NotFound(NotFoundReason.missing_node, name.components());
        }
        if (!Environment.isPropertyOn("jacorb.naming.noping") && object._non_existent()) {
            throw new NotFound(NotFoundReason.missing_node, name.components());
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unbind(NameComponent[] nameComponentArray) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            throw new CannotProceed();
        }
        if (nameComponentArray == null) throw new InvalidName();
        if (nameComponentArray.length == 0) {
            throw new InvalidName();
        }
        Name name = new Name(nameComponentArray);
        Name name2 = name.ctxName();
        NameComponent nameComponent = name.baseNameComponent();
        if (name2 != null) {
            NameComponent[] nameComponentArray2 = new NameComponent[]{nameComponent};
            NamingContextExtHelper.narrow(this.resolve(name2.components())).unbind(nameComponentArray2);
            return;
        }
        if (this.names.containsKey(name)) {
            Object object = (Object)this.names.remove(name);
            object._release();
            if (!logger.isInfoEnabled()) return;
            logger.info("Unbound: " + name.toString());
            return;
        }
        if (this.contexts.containsKey(name)) {
            Object object = (Object)this.contexts.remove(name);
            object._release();
            if (!logger.isInfoEnabled()) return;
            logger.info("Unbound: " + name.toString());
            return;
        }
        if (!logger.isWarnEnabled()) throw new NotFound(NotFoundReason.not_context, name.components());
        logger.warn("Unbind failed for " + name.toString());
        throw new NotFound(NotFoundReason.not_context, name.components());
    }

    public POA default_POA() {
        return this.poa;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        Name name;
        Enumeration enumeration = this.contexts.keys();
        while (enumeration.hasMoreElements()) {
            name = (Name)enumeration.nextElement();
            object = (Object)this.contexts.remove(name);
            this.contexts.put(name, orb.object_to_string(object));
        }
        enumeration = this.names.keys();
        while (enumeration.hasMoreElements()) {
            name = (Name)enumeration.nextElement();
            object = (Object)this.names.remove(name);
            this.names.put(name, orb.object_to_string(object));
        }
        objectOutputStream.defaultWriteObject();
    }

    public static void init(ORB oRB, POA pOA) {
        orb = oRB;
        rootPoa = pOA;
    }

    void init(POA pOA) {
        String string;
        Name name;
        this.poa = pOA;
        Enumeration enumeration = this.contexts.keys();
        while (enumeration.hasMoreElements()) {
            name = (Name)enumeration.nextElement();
            string = (String)this.contexts.remove(name);
            this.contexts.put(name, orb.string_to_object(string));
        }
        enumeration = this.names.keys();
        while (enumeration.hasMoreElements()) {
            name = (Name)enumeration.nextElement();
            string = (String)this.names.remove(name);
            this.names.put(name, orb.string_to_object(string));
        }
    }

    public String to_string(NameComponent[] nameComponentArray) throws InvalidName {
        return Name.toString(nameComponentArray);
    }

    public NameComponent[] to_name(String string) throws InvalidName {
        return Name.toName(string);
    }

    public String to_url(String string, String string2) throws InvalidAddress, InvalidName {
        try {
            CorbaLoc corbaLoc = new CorbaLoc((org.jacorb.orb.ORB)orb, string);
            return corbaLoc.toCorbaName(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAddress();
        }
    }

    public Object resolve_str(String string) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(string));
    }
}

