/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.util.ImRManager;
import org.jacorb.naming.NamingContextImpl;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer._ServantActivatorLocalBase;

public class NameServer {
    private static ORB orb = null;
    public static String name_delimiter = "/";
    private static String filePrefix = "_nsdb";
    private static Logger logger = Debug.getNamedLogger("jacorb.naming");

    private static void usage() {
        System.err.println("Usage: java org.jacorb.naming.NameServer [<ior_filename>] [-p <ns_port>] [-t <time_out> [imr_register] ]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        String string2 = null;
        try {
            java.lang.Object object;
            String string3;
            int n = 0;
            if (stringArray.length > 6) {
                NameServer.usage();
            }
            int n2 = 0;
            if (stringArray.length > 0) {
                if (!stringArray[0].startsWith("-p")) {
                    string2 = stringArray[0];
                    ++n2;
                }
                if (n2 < stringArray.length && stringArray[n2].startsWith("-p")) {
                    if (n2 + 1 < stringArray.length) {
                        string = stringArray[n2 + 1];
                        ++n2;
                    } else {
                        NameServer.usage();
                    }
                }
                if (n2 < stringArray.length && stringArray[n2].startsWith("-t")) {
                    if (n2 + 1 < stringArray.length) {
                        try {
                            n = Integer.parseInt(stringArray[n2 + 1]);
                            ++n2;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n2 + 1 < stringArray.length && stringArray[n2 + 1].equals("imr_register")) {
                            bl = true;
                        }
                    } else {
                        NameServer.usage();
                    }
                }
            }
            Properties properties = new Properties();
            properties.put("jacorb.implname", "StandardNS");
            properties.put("jacorb.orb.objectKeyMap.NameService", "StandardNS/NameServer-POA/_root");
            if (Environment.getIntPropertyWithDefault("jacorb.connection.server.timeout", -1) < 0) {
                logger.debug("Default server.timeout to 10000");
                properties.put("jacorb.connection.server.timeout", "10000");
            }
            if (string == null && (string = Environment.getProperty("jacorb.naming.port")) != null) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    string = null;
                }
            }
            if (string != null) {
                properties.put("OAPort", string);
            }
            if ((string3 = Environment.getProperty("jacorb.naming.db_dir")) != null) {
                filePrefix = string3 + File.separatorChar + filePrefix;
            }
            orb = ORB.init(stringArray, properties);
            if (Environment.useImR() && bl) {
                object = Environment.getProperty("jacorb.java_exec") + " org.jacorb.naming.NameServer " + stringArray[0] + " " + stringArray[1];
                ImRManager.autoRegisterServer(orb, "StandardNS", (String)object, ImRManager.getLocalHostName(), true);
            }
            object = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            Policy[] policyArray = new Policy[]{object.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), object.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), object.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            POA pOA = object.create_POA("NameServer-POA", object.the_POAManager(), policyArray);
            NamingContextImpl.init(orb, (POA)object);
            NameServantActivatorImpl nameServantActivatorImpl = new NameServantActivatorImpl(orb);
            pOA.set_servant_manager(nameServantActivatorImpl);
            pOA.the_POAManager().activate();
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray[i].destroy();
            }
            byte[] byArray = new String("_root").getBytes();
            try {
                Object object2 = pOA.create_reference_with_id(byArray, "IDL:omg.org/CosNaming/NamingContextExt:1.0");
                if (string2 != null) {
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(string2), true);
                    printWriter.println(orb.object_to_string(object2));
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.getMessage());
            }
            if (logger.isInfoEnabled()) {
                logger.info("NS up");
            }
            if (n == 0) {
                orb.run();
            } else {
                Thread.sleep(n);
            }
            orb.shutdown(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static class NameServantActivatorImpl
    extends _ServantActivatorLocalBase {
        private ORB orb = null;

        public NameServantActivatorImpl(ORB oRB) {
            this.orb = oRB;
        }

        public Servant incarnate(byte[] byArray, POA pOA) throws ForwardRequest {
            String string = new String(byArray);
            NamingContextImpl namingContextImpl = null;
            try {
                File file = new File(filePrefix + string);
                if (file.exists()) {
                    FileInputStream fileInputStream;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Reading in context state from file");
                    }
                    if ((fileInputStream = new FileInputStream(file)).available() > 0) {
                        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                        namingContextImpl = (NamingContextImpl)objectInputStream.readObject();
                        objectInputStream.close();
                    }
                    fileInputStream.close();
                } else if (logger.isDebugEnabled()) {
                    logger.debug("No naming context state, starting empty");
                }
            }
            catch (IOException iOException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("File seems corrupt, starting empty");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("Could not read object from file, class not found!");
                System.exit(1);
            }
            if (namingContextImpl == null) {
                namingContextImpl = new NamingContextImpl();
            }
            namingContextImpl.init(pOA);
            return namingContextImpl;
        }

        public void etherealize(byte[] byArray, POA pOA, Servant servant, boolean bl, boolean bl2) {
            String string = new String(byArray);
            try {
                File file = new File(filePrefix + string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject((NamingContextImpl)servant);
                if (logger.isDebugEnabled()) {
                    logger.debug("Saved state for servant " + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                logger.error("Error opening output file " + filePrefix + string);
            }
        }
    }
}

