/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.lang.reflect.Field;
import org.jacorb.ir.Contained;
import org.jacorb.ir.IDLType;
import org.jacorb.ir.TypeCodeUtil;
import org.jacorb.orb.Any;
import org.jacorb.util.Debug;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ConstantDefOperations;
import org.omg.CORBA.ConstantDescription;
import org.omg.CORBA.ConstantDescriptionHelper;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.Container;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.Repository;
import org.omg.CORBA.TypeCode;

public class ConstantDef
extends Contained
implements ConstantDefOperations {
    protected static char fileSeparator = System.getProperty("file.separator").charAt(0);
    private Field field;
    private TypeCode typeCode;
    private org.omg.CORBA.IDLType type_def;
    private Any value;
    private ConstantDescription description;
    private boolean defined = false;
    org.omg.CORBA.Contained myContainer;

    public ConstantDef(Field field, Container container, Repository repository) {
        this.def_kind = DefinitionKind.dk_Constant;
        this.containing_repository = repository;
        this.defined_in = container;
        this.field = field;
        this.name(field.getName());
        this.version = "1.0";
        this.myContainer = ContainedHelper.narrow(this.defined_in);
        if (this.myContainer == null) {
            throw new INTF_REPOS("Constant should be in an interface!");
        }
        String string = this.myContainer.id();
        this.id = string.substring(0, string.lastIndexOf(":")) + "/" + this.name + ":" + this.version;
        this.absolute_name = this.myContainer.absolute_name() + "::" + this.name;
        try {
            this.typeCode = TypeCodeUtil.getTypeCode(field.getType(), null);
            Debug.output(2, "New ConstantDef " + this.absolute_name());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.output(0, "Error: ConstantDef " + this.absolute_name() + " could not be created!");
            classNotFoundException.printStackTrace();
        }
    }

    public ConstantDef(Class clazz, Container container, Repository repository) {
        this.def_kind = DefinitionKind.dk_Constant;
        this.containing_repository = repository;
        this.defined_in = container;
        this.myContainer = ContainedHelper.narrow(this.defined_in);
        try {
            this.field = clazz.getDeclaredField("value");
            this.version = "1.0";
            String string = clazz.getName();
            if (string.indexOf(46) > 0) {
                this.name(string.substring(string.lastIndexOf(46) + 1));
                String string2 = string.substring(0, string.lastIndexOf(46));
                this.id = "IDL:" + string2.replace('.', '/') + "/" + this.name + ":" + this.version;
                this.absolute_name = this.myContainer.absolute_name() + "::" + this.name;
            } else {
                this.name(string);
                this.defined_in = this.containing_repository;
                this.id = "IDL:" + this.name + ":" + this.version;
                this.absolute_name = "::" + this.name;
            }
            this.typeCode = TypeCodeUtil.getTypeCode(this.field.getType(), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new INTF_REPOS(2600, CompletionStatus.COMPLETED_NO);
        }
        Debug.output(2, "New ConstantDef " + this.absolute_name());
    }

    void define() {
        Debug.output(2, "ConstantDef " + this.absolute_name() + " defining.");
        this.value = (Any)this.orb.create_any();
        this.type_def = IDLType.create(this.typeCode, this.containing_repository);
        if (this.typeCode == null) {
            throw new INTF_REPOS("typeCode is null!");
        }
        if (this.type_def == null) {
            throw new INTF_REPOS("type_def is null!");
        }
        try {
            this.value.insert_object(this.typeCode, this.orb, this.field.get(null));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.defined = true;
    }

    public TypeCode type() {
        return this.typeCode;
    }

    public org.omg.CORBA.Any value() {
        return this.value;
    }

    public void value(org.omg.CORBA.Any any) {
        this.value = (Any)any;
    }

    public org.omg.CORBA.IDLType type_def() {
        return this.type_def;
    }

    public void type_def(org.omg.CORBA.IDLType iDLType) {
        this.type_def = iDLType;
    }

    ConstantDescription describe_constant() {
        if (!this.defined) {
            throw new INTF_REPOS("ConstantDef " + this.name + " not defined!");
        }
        if (this.description == null) {
            String string = null;
            string = this.myContainer == null ? "Global" : this.myContainer.id();
            this.description = new ConstantDescription(this.name, this.id, string, this.version, this.typeCode, this.value);
        }
        return this.description;
    }

    public Description describe() {
        org.omg.CORBA.Any any = this.orb.create_any();
        ConstantDescriptionHelper.insert(any, this.describe_constant());
        return new Description(DefinitionKind.dk_Constant, any);
    }

    public void destroy() {
    }
}

