/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.AdminPackage.FileOpFailed;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.AdminPackage.UnknownHostName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRHostInfo;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.ImplementationRepositoryPOA;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalHostName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.RegistrationPackage.InvalidSSDRef;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.ServerStartupFailed;
import org.jacorb.imr.ServerTable;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dns.DNSLookup;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.IOR;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class ImplementationRepositoryImpl
extends ImplementationRepositoryPOA {
    private static int default_port;
    private static String default_host;
    private static ORB orb;
    private File table_file;
    private ServerTable server_table;
    private File table_file_backup;
    private SocketListener listener;
    private int object_activation_retries = 5;
    private int object_activation_sleep = 50;
    private boolean allow_auto_register = false;
    private boolean check_object_liveness = false;
    private WriteThread wt;
    private boolean updatePending;
    private Shutdown shutdownThread;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public ImplementationRepositoryImpl(File file, File file2, boolean bl) {
        java.lang.Object object;
        this.table_file = file;
        this.table_file_backup = file2;
        try {
            if (bl) {
                this.server_table = new ServerTable();
                this.save_server_table(file);
            } else {
                try {
                    object = new ObjectInputStream(new FileInputStream(file));
                    this.server_table = (ServerTable)((ObjectInputStream)object).readObject();
                    ((ObjectInputStream)object).close();
                }
                catch (Exception exception) {
                    Debug.output(4, exception);
                    this.server_table = new ServerTable();
                    this.save_server_table(file);
                }
            }
        }
        catch (FileOpFailed fileOpFailed) {
            Debug.output(4, fileOpFailed);
        }
        this.shutdownThread = new Shutdown();
        this.shutdownThread.setDaemon(true);
        this.shutdownThread.setName("Shutdown Thread");
        this.addShutdownHook(this.shutdownThread);
        this.wt = new WriteThread();
        this.wt.setName("IMR Write Thread");
        this.wt.setDaemon(true);
        this.wt.start();
        try {
            object = Environment.getProperty("jacorb.imr.object_activation_retries");
            if (object != null) {
                this.object_activation_retries = Integer.parseInt((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            object = Environment.getProperty("jacorb.imr.object_activation_sleep");
            if (object != null) {
                this.object_activation_sleep = Integer.parseInt((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object = Environment.getProperty("jacorb.imr.allow_auto_register");
        if (object != null) {
            object = ((String)object).toLowerCase();
            this.allow_auto_register = "on".equals(object);
        }
        if ((object = Environment.getProperty("jacorb.imr.check_object_liveness")) != null) {
            object = ((String)object).toLowerCase();
            this.check_object_liveness = "on".equals(object);
        }
        this.listener = new SocketListener();
    }

    public void set_server_down(String string) throws UnknownServerName {
        Debug.output(4, "ImR: server " + string + " is going down... ");
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.setDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_poa(String string, String string2, String string3, int n) throws IllegalPOAName, DuplicatePOAName, UnknownServerName {
        java.lang.Object object;
        ImRServerInfo imRServerInfo = null;
        ImRPOAInfo imRPOAInfo = null;
        boolean bl = false;
        this.updatePending = true;
        Debug.output(4, "ImR: registering poa " + string + " for server: " + string2 + " on " + string3);
        if (this.allow_auto_register && !this.server_table.hasServer(string2)) {
            try {
                this.register_server(string2, "", "");
            }
            catch (IllegalServerName illegalServerName) {
            }
            catch (DuplicateServerName duplicateServerName) {
                // empty catch block
            }
        }
        imRServerInfo = this.server_table.getServer(string2);
        imRPOAInfo = this.server_table.getPOA(string);
        if (imRPOAInfo == null) {
            imRPOAInfo = new ImRPOAInfo(string, string3, n, imRServerInfo);
            imRServerInfo.addPOA(imRPOAInfo);
            this.server_table.putPOA(string, imRPOAInfo);
            Debug.output(4, "ImR: new poa registered");
        } else {
            if (imRPOAInfo.active || !string2.equals(imRPOAInfo.server.name)) {
                object = imRPOAInfo.name.getBytes();
                byte[] byArray = new byte[((byte[])object).length + 1];
                System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
                byArray[((byte[])object).length] = 47;
                if (imRPOAInfo.host.equals(string3) && imRPOAInfo.port == n) {
                    bl = true;
                } else {
                    boolean bl2 = bl = !ImplementationRepositoryImpl.checkServerActive(imRPOAInfo.host, imRPOAInfo.port, byArray);
                }
                if (!bl) {
                    throw new DuplicatePOAName("POA " + string + " has already been registered " + "for server " + imRPOAInfo.server.name);
                }
                Debug.output(4, "ImR: Remapping server/port");
            }
            imRPOAInfo.reactivate(string3, n);
            Debug.output(4, "ImR: register_poa, reactivated");
        }
        try {
            WriteThread writeThread = this.wt;
            object = writeThread;
            synchronized (writeThread) {
                this.wt.notify();
                // ** MonitorExit[var8_10 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(4, illegalMonitorStateException);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_host(HostInfo hostInfo) throws IllegalHostName, InvalidSSDRef {
        if (hostInfo.name == null || hostInfo.name.length() == 0) {
            throw new IllegalHostName(hostInfo.name);
        }
        try {
            hostInfo.ssd_ref.get_system_load();
        }
        catch (Exception exception) {
            Debug.output(4, exception);
            throw new InvalidSSDRef();
        }
        this.updatePending = true;
        this.server_table.putHost(hostInfo.name, new ImRHostInfo(hostInfo));
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(4, illegalMonitorStateException);
        }
    }

    public ImRInfo get_imr_info() {
        return new ImRInfo(this.listener.getAddress(), this.listener.getPort());
    }

    public HostInfo[] list_hosts() {
        return this.server_table.getHosts();
    }

    public ServerInfo[] list_servers() {
        ServerInfo[] serverInfoArray;
        if (this.check_object_liveness) {
            Debug.output(4, "ImR: Checking servers");
            serverInfoArray = this.server_table.getServers();
            for (int i = 0; i < serverInfoArray.length; ++i) {
                if (!serverInfoArray[i].active || serverInfoArray[i].poas.length <= 0) continue;
                byte[] byArray = serverInfoArray[i].poas[0].name.getBytes();
                byte[] byArray2 = new byte[byArray.length + 1];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray2[byArray.length] = 47;
                if (ImplementationRepositoryImpl.checkServerActive(serverInfoArray[i].poas[0].host, serverInfoArray[i].poas[0].port, byArray2)) continue;
                try {
                    Debug.output(4, "ImR: Setting server " + serverInfoArray[i].name + " down");
                    this.server_table.getServer(serverInfoArray[i].name).setDown();
                    serverInfoArray[i].active = false;
                    continue;
                }
                catch (UnknownServerName unknownServerName) {
                    Debug.output(4, "ImR: Internal error - unknown server " + serverInfoArray[i].name);
                }
            }
        } else {
            serverInfoArray = this.server_table.getServers();
        }
        return serverInfoArray;
    }

    public ServerInfo get_server_info(String string) throws UnknownServerName {
        return this.server_table.getServer(string).toServerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_server(String string, String string2, String string3) throws IllegalServerName, DuplicateServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = new ImRServerInfo(string, string3, string2);
        this.server_table.putServer(string, imRServerInfo);
        Debug.output(4, "ImR: server " + string + " on " + string3 + " registered");
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(4, illegalMonitorStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister_server(String string) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        String[] stringArray = imRServerInfo.getPOANames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.server_table.removePOA(stringArray[i]);
        }
        this.server_table.removeServer(string);
        Debug.output(4, "ImR: server " + string + " unregistered");
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(4, illegalMonitorStateException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit_server(String string, String string2, String string3) throws UnknownServerName {
        this.updatePending = true;
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.command = string2;
        imRServerInfo.host = string3;
        Debug.output(4, "ImR: server " + string + " edited");
        try {
            WriteThread writeThread = this.wt;
            synchronized (writeThread) {
                this.wt.notify();
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Debug.output(4, illegalMonitorStateException);
        }
    }

    public void hold_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.holding = true;
    }

    public void release_server(String string) throws UnknownServerName {
        ImRServerInfo imRServerInfo = this.server_table.getServer(string);
        imRServerInfo.release();
    }

    public void start_server(String string) throws UnknownServerName, ServerStartupFailed {
        this.restartServer(this.server_table.getServer(string));
    }

    public void save_server_table() throws FileOpFailed {
        if (this.table_file_backup != null) {
            this.save_server_table(this.table_file_backup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        Thread thread = this.wt;
        synchronized (thread) {
            this.wt.shutdown();
            this.wt.notify();
        }
        if (this.listener != null) {
            this.listener.stopListening(bl);
            try {
                thread = this.listener;
                synchronized (thread) {
                    this.listener.join(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Debug.output(4, interruptedException);
            }
        }
        try {
            this.save_server_table();
        }
        catch (FileOpFailed fileOpFailed) {
            Debug.output(4, "ImR: Failed to save backup table.");
        }
        Debug.output(4, "ImR: Finished shutting down");
    }

    public void unregister_host(String string) throws UnknownHostName {
        if (this.server_table.removeHost(string) == null) {
            throw new UnknownHostName(string);
        }
    }

    private void save_server_table(File file) throws FileOpFailed {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            this.server_table.table_lock.gainExclusiveLock();
            objectOutputStream.writeObject(this.server_table);
            this.server_table.table_lock.releaseExclusiveLock();
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            Debug.output(4, exception);
            throw new FileOpFailed();
        }
        this.updatePending = false;
    }

    public static void usage() {
        System.out.println("Usage: ImplementationRepositoryImpl [Parameter]");
        System.out.println("Parameter:");
        System.out.println("\t -p <port> Port to listen on for requests");
        System.out.println("\t[ -f <file> Read in server table from this file");
        System.out.println("\t| -n Start with empty server table ]");
        System.out.println("\t -i <iorfile> Place IOR in this file");
        System.out.println("\t -b <backupfile> Put server table in this file");
        System.out.println("\t -a Allow auto-registering of servers");
        System.out.println("\t -h Print this help");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length > 8) {
            ImplementationRepositoryImpl.usage();
        }
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Properties properties = null;
        File file2 = null;
        System.setProperty("jacorb.implname", "the_ImR");
        System.setProperty("jacorb.use_imr", "off");
        try {
            block17: for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() < 2) {
                    System.out.println("Ignoring argument '" + stringArray[i] + "' as it is not valid.");
                    continue;
                }
                switch (stringArray[i].charAt(1)) {
                    case 'h': {
                        ImplementationRepositoryImpl.usage();
                    }
                    case 'p': {
                        default_port = Integer.parseInt(stringArray[++i]);
                        continue block17;
                    }
                    case 'f': {
                        if (bl) {
                            System.out.println("ERROR: -n and -f not allowed together");
                            ImplementationRepositoryImpl.usage();
                        }
                        if (i + 1 >= stringArray.length) {
                            System.out.println("ERROR: Supply filename with -f switch");
                            ImplementationRepositoryImpl.usage();
                        }
                        string = stringArray[++i];
                        continue block17;
                    }
                    case 'n': {
                        if (string != null) {
                            System.out.println("ERROR: -n and -f not allowed together");
                            ImplementationRepositoryImpl.usage();
                        }
                        bl = true;
                        continue block17;
                    }
                    case 'i': {
                        if (i + 1 >= stringArray.length) {
                            System.out.println("ERROR: Supply IOR filename with -i switch");
                            ImplementationRepositoryImpl.usage();
                        }
                        string2 = stringArray[++i];
                        continue block17;
                    }
                    case 'b': {
                        if (i + 1 >= stringArray.length) {
                            System.out.println("ERROR: Supply filename with -b switch");
                            ImplementationRepositoryImpl.usage();
                        }
                        string3 = stringArray[++i];
                        continue block17;
                    }
                    case 'a': {
                        Environment.setProperty("jacorb.imr.allow_auto_register", "on");
                        continue block17;
                    }
                    default: {
                        ImplementationRepositoryImpl.usage();
                    }
                }
            }
        }
        catch (Exception exception) {
            ImplementationRepositoryImpl.usage();
        }
        if (default_port == 0 && (string4 = Environment.getProperty("jacorb.imr.endpoint_port_number")) != null && string4.length() > 0) {
            default_port = Integer.parseInt(string4);
            Debug.output(4, "ImR: Using endpoint port number " + default_port);
        }
        if ((string4 = Environment.getProperty("jacorb.imr.port_number")) != null && string4.length() > 0) {
            properties = new Properties();
            properties.setProperty("OAPort", string4);
            Debug.output(4, "ImR: Using port number " + string4);
        }
        if ((default_host = Environment.getProperty("jacorb.imr.host")) != null && default_host.length() > 0) {
            Debug.output(4, "ImR: Using host address " + default_host);
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty("OAIAddr", default_host);
        }
        if (string == null && (string = Environment.getProperty("jacorb.imr.table_file")) == null) {
            Debug.output(1, "WARNING: No file for the server table specified! Configure the property jacorb.imr.table_file or use the -f switch");
            Debug.output(1, "Will create \"table.dat\" in current directory, if necessary");
            string = "table.dat";
        }
        if (!(file = new File(string)).exists()) {
            bl = true;
            Debug.output(1, "Table file " + string + " does not exist - autocreating it.");
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                Debug.output(4, iOException);
                System.exit(-1);
            }
        } else {
            if (file.isDirectory()) {
                Debug.output(1, "ERROR: The table file is a directory! Please check " + file.getAbsolutePath());
                System.exit(-1);
            }
            if (!file.canRead()) {
                Debug.output(1, "ERROR: The table file is not readable! Please check " + file.getAbsolutePath());
                System.exit(-1);
            }
            if (!file.canWrite()) {
                Debug.output(1, "WARNING: The table file is not writable! Please check " + file.getAbsolutePath());
                System.exit(-1);
            }
        }
        if (string2 == null && (string2 = Environment.getProperty("jacorb.imr.ior_file")) == null) {
            System.out.println("ERROR: Please specify a file for the IOR string!");
            System.out.println("Property jacorb.imr.ior_file or use the -i switch");
            System.exit(-1);
        }
        if (!(string3 != null && string3.length() != 0 || (string3 = Environment.getProperty("jacorb.imr.backup_file")) != null && string3.length() != 0)) {
            Debug.output(1, "WARNING: No backup file specified!. No backup file will be created.");
        }
        if (string3 != null) {
            file2 = new File(string3);
            if (!file2.exists()) {
                bl = true;
                Debug.output(1, "Backup file " + string3 + " does not exist - autocreating it.");
                try {
                    file2.createNewFile();
                }
                catch (IOException iOException) {
                    Debug.output(4, iOException);
                    System.exit(-1);
                }
            } else {
                if (file2.isDirectory()) {
                    Debug.output(1, "ERROR: The backup file is a directory! Please check " + file2.getAbsolutePath());
                    System.exit(-1);
                }
                if (!file2.canRead()) {
                    Debug.output(1, "ERROR: The backup file is not readable! Please check " + file2.getAbsolutePath());
                    System.exit(-1);
                }
                if (!file2.canWrite()) {
                    Debug.output(1, "WARNING: The backup file is not writable! Please check " + file2.getAbsolutePath());
                    System.exit(-1);
                }
            }
        }
        orb = ORB.init(stringArray, properties);
        try {
            POA pOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            Policy[] policyArray = new Policy[]{pOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), pOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            POA pOA2 = pOA.create_POA("ImRPOA", pOA.the_POAManager(), policyArray);
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray[i].destroy();
            }
            byte[] byArray = "ImR".getBytes();
            ImplementationRepositoryImpl implementationRepositoryImpl = new ImplementationRepositoryImpl(file, file2, bl);
            pOA2.activate_object_with_id(byArray, implementationRepositoryImpl);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(string2)));
            printWriter.println(orb.object_to_string(pOA2.servant_to_reference(implementationRepositoryImpl)));
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            Debug.output(4, exception);
            Debug.output(1, "ERROR: Failed to write IOR to file.\nPlease check the path.");
            System.exit(-1);
        }
        orb.run();
    }

    private void restartServer(ImRServerInfo imRServerInfo) throws ServerStartupFailed {
        imRServerInfo.awaitRelease();
        if (!imRServerInfo.active) {
            Debug.output(4, "ImR: server " + imRServerInfo.name + " is down");
            if (imRServerInfo.command.length() == 0) {
                throw new ServerStartupFailed("Server " + imRServerInfo.name + " can't be restarted because" + " of missing startup command");
            }
            if (imRServerInfo.shouldBeRestarted()) {
                try {
                    ImRHostInfo imRHostInfo = this.server_table.getHost(imRServerInfo.host);
                    if (imRHostInfo == null) {
                        throw new ServerStartupFailed("Unknown host: >>" + imRServerInfo.host + "<<");
                    }
                    Debug.output(4, "ImR: will restart " + imRServerInfo.name);
                    imRHostInfo.startServer(imRServerInfo.command, orb);
                }
                catch (ServerStartupFailed serverStartupFailed) {
                    imRServerInfo.setNotRestarting();
                    throw serverStartupFailed;
                }
                catch (Exception exception) {
                    imRServerInfo.setNotRestarting();
                    Debug.output(4, exception);
                    this.server_table.removeHost(imRServerInfo.host);
                    throw new ServerStartupFailed("Failed to connect to host!");
                }
            } else {
                Debug.output(4, "ImR: somebody else is restarting " + imRServerInfo.name);
            }
        } else {
            Debug.output(4, "ImR: server " + imRServerInfo.name + " is active");
        }
    }

    private void addShutdownHook(Thread thread) {
        Method method = this.getHookMethod("addShutdownHook");
        if (method != null) {
            this.invokeHookMethod(method, thread);
        }
    }

    private Method getHookMethod(String string) {
        Method method = null;
        Class[] classArray = new Class[]{class$java$lang$Thread == null ? (class$java$lang$Thread = ImplementationRepositoryImpl.class$("java.lang.Thread")) : class$java$lang$Thread};
        try {
            method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = ImplementationRepositoryImpl.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod(string, classArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return method;
    }

    private void invokeHookMethod(Method method, Thread thread) {
        java.lang.Object[] objectArray = new java.lang.Object[]{thread};
        try {
            method.invoke((java.lang.Object)Runtime.getRuntime(), objectArray);
        }
        catch (Throwable throwable) {
            Debug.output(4, "Failed to invoke Runtime." + method.getName() + " and exception " + throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkServerActive(String string, int n, byte[] byArray) {
        ClientConnectionManager clientConnectionManager = null;
        IIOPAddress iIOPAddress = null;
        ClientConnection clientConnection = null;
        LocateRequestOutputStream locateRequestOutputStream = null;
        LocateReplyReceiver locateReplyReceiver = null;
        LocateReplyInputStream locateReplyInputStream = null;
        boolean bl = false;
        clientConnectionManager = ((org.jacorb.orb.ORB)orb).getClientConnectionManager();
        iIOPAddress = new IIOPAddress(string, n);
        clientConnection = clientConnectionManager.getConnection(new IIOPProfile(iIOPAddress, byArray));
        Debug.output(4, "Pinging " + string + " / " + n);
        try {
            locateRequestOutputStream = new LocateRequestOutputStream(byArray, clientConnection.getId(), 2);
            locateReplyReceiver = new LocateReplyReceiver();
            clientConnection.sendRequest(locateRequestOutputStream, locateReplyReceiver, locateRequestOutputStream.getRequestId(), true);
            locateReplyInputStream = locateReplyReceiver.getReply();
            switch (locateReplyInputStream.rep_hdr.locate_status.value()) {
                default: 
            }
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        finally {
            clientConnectionManager.releaseConnection(clientConnection);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Shutdown
    extends Thread {
        private Shutdown() {
        }

        public synchronized void run() {
            Debug.output(4, "ImR: Shutting down");
            ImplementationRepositoryImpl.this.shutdown(true);
        }
    }

    private class WriteThread
    extends Thread {
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    ImplementationRepositoryImpl.this.save_server_table(ImplementationRepositoryImpl.this.table_file);
                }
                catch (FileOpFailed fileOpFailed) {
                    Debug.output(4, fileOpFailed);
                }
                if (this.done) break;
                if (ImplementationRepositoryImpl.this.updatePending) continue;
                try {
                    WriteThread writeThread = this;
                    synchronized (writeThread) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Debug.output(4, "ImR: IMR write thread waking up to save server table... ");
            }
        }

        public void shutdown() {
            this.done = true;
        }
    }

    private class ImRRequestListener
    implements RequestListener {
        public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
            gIOPConnection.incPendingMessages();
            RequestInputStream requestInputStream = new RequestInputStream(orb, byArray);
            this.replyNewLocation(((org.jacorb.orb.ORB)orb).mapObjectKey(ParsedIOR.extractObjectKey(requestInputStream.req_hdr.target, (org.jacorb.orb.ORB)orb)), requestInputStream.req_hdr.request_id, requestInputStream.getGIOPMinor(), gIOPConnection);
        }

        public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
            gIOPConnection.incPendingMessages();
            LocateRequestInputStream locateRequestInputStream = new LocateRequestInputStream(orb, byArray);
            this.replyNewLocation(ParsedIOR.extractObjectKey(locateRequestInputStream.req_hdr.target, (org.jacorb.orb.ORB)orb), locateRequestInputStream.req_hdr.request_id, locateRequestInputStream.getGIOPMinor(), gIOPConnection);
        }

        public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        }

        public void fragmentReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        }

        public void connectionClosed() {
        }

        private void replyNewLocation(byte[] byArray, int n, int n2, GIOPConnection gIOPConnection) {
            boolean bl;
            String string = POAUtil.extractImplName(byArray) + '/' + POAUtil.extractPOAName(byArray);
            ImRPOAInfo imRPOAInfo = ImplementationRepositoryImpl.this.server_table.getPOA(string);
            if (imRPOAInfo == null) {
                this.sendSysException(new OBJECT_NOT_EXIST("POA " + string + " unknown"), gIOPConnection, n, n2);
                return;
            }
            ImRServerInfo imRServerInfo = imRPOAInfo.server;
            Debug.output(4, "ImR: Looking up: " + imRServerInfo.name);
            boolean bl2 = bl = imRServerInfo.command.length() != 0 && ImplementationRepositoryImpl.this.server_table.getHost(imRServerInfo.host) != null;
            if (imRServerInfo.active && (ImplementationRepositoryImpl.this.check_object_liveness || bl) && !ImplementationRepositoryImpl.checkServerActive(imRPOAInfo.host, imRPOAInfo.port, byArray)) {
                imRServerInfo.setDown();
            }
            try {
                ImplementationRepositoryImpl.this.restartServer(imRServerInfo);
            }
            catch (ServerStartupFailed serverStartupFailed) {
                Debug.output(4, "Object (" + imRServerInfo.name + ") on " + imRPOAInfo.host + '/' + imRPOAInfo.port + " not reachable");
                this.sendSysException(new TRANSIENT(serverStartupFailed.reason), gIOPConnection, n, n2);
                return;
            }
            boolean bl3 = imRPOAInfo.active;
            if (!imRPOAInfo.awaitActivation()) {
                this.sendSysException(new TRANSIENT("Timeout exceeded"), gIOPConnection, n, n2);
                return;
            }
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(n, ReplyStatusType_1_2.LOCATION_FORWARD, n2, false);
            IIOPAddress iIOPAddress = new IIOPAddress(imRPOAInfo.host, (short)imRPOAInfo.port);
            IIOPProfile iIOPProfile = new IIOPProfile(iIOPAddress, byArray, n2);
            IOR iOR = ParsedIOR.createObjectIOR(iIOPProfile);
            if (!bl3) {
                Object object = orb.string_to_object(new ParsedIOR(iOR, (org.jacorb.orb.ORB)orb).getIORString());
                for (int i = 0; i < ImplementationRepositoryImpl.this.object_activation_retries; ++i) {
                    try {
                        Thread.sleep(ImplementationRepositoryImpl.this.object_activation_sleep);
                        if (object._non_existent()) continue;
                        break;
                    }
                    catch (Exception exception) {
                        Debug.output(4, exception);
                    }
                }
            }
            try {
                replyOutputStream.write_IOR(iOR);
                Debug.output(4, "ImR: Sending location forward for " + imRServerInfo.name);
                gIOPConnection.sendReply(replyOutputStream);
            }
            catch (IOException iOException) {
                Debug.output(4, iOException);
                this.sendSysException(new UNKNOWN(iOException.toString()), gIOPConnection, n, n2);
            }
        }

        private void sendSysException(SystemException systemException, GIOPConnection gIOPConnection, int n, int n2) {
            ReplyOutputStream replyOutputStream = new ReplyOutputStream(n, ReplyStatusType_1_2.SYSTEM_EXCEPTION, n2, false);
            SystemExceptionHelper.write(replyOutputStream, systemException);
            try {
                gIOPConnection.sendReply(replyOutputStream);
            }
            catch (IOException iOException) {
                Debug.output(4, iOException);
            }
        }
    }

    private class SocketListener
    extends Thread {
        private ServerSocket server_socket;
        private int port = 0;
        private String address;
        private int timeout = 0;
        private boolean run = true;
        private boolean wait = false;
        private MessageReceptorPool receptor_pool = null;
        private RequestListener request_listener = null;
        private ReplyListener reply_listener = null;
        private TransportManager transport_manager = null;

        public SocketListener() {
            try {
                this.server_socket = new ServerSocket(default_port);
                this.transport_manager = new TransportManager((org.jacorb.orb.ORB)orb);
                this.address = default_host != null && default_host.length() > 0 ? DNSLookup.inverseLookup(InetAddress.getByName(default_host)) : DNSLookup.inverseLookup(InetAddress.getLocalHost());
                if (this.address == null) {
                    this.address = default_host != null && default_host.length() > 0 ? default_host : InetAddress.getLocalHost().toString();
                }
                if (this.address.indexOf("/") >= 0) {
                    this.address = this.address.substring(this.address.indexOf("/") + 1);
                }
                this.port = this.server_socket.getLocalPort();
                Debug.output(4, "ImR Listener at " + this.port + ", " + this.address);
                String string = Environment.getProperty("jacorb.imr.connection_timeout", "2000");
                try {
                    this.timeout = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.output(3, "ERROR: Unable to build timeout int from string >>" + string + "<<");
                    Debug.output(3, "Please check property \"jacorb.imr.connection_timeout\"");
                }
            }
            catch (Exception exception) {
                Debug.output(3, exception);
                Debug.output(3, "Listener: Couldn't init");
                System.exit(1);
            }
            this.setDaemon(true);
            this.receptor_pool = MessageReceptorPool.getInstance();
            this.request_listener = new ImRRequestListener();
            this.reply_listener = new NoBiDirServerReplyListener();
            this.start();
        }

        public int getPort() {
            Debug.output(4, "ImR Listener at " + this.port + ", " + this.address);
            return this.port;
        }

        public String getAddress() {
            return this.address;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public void run() {
            Thread.currentThread().setPriority(10);
            while (this.run) {
                try {
                    Socket socket = this.server_socket.accept();
                    socket.setSoTimeout(this.timeout);
                    ServerIIOPConnection serverIIOPConnection = new ServerIIOPConnection(socket, false);
                    ServerGIOPConnection serverGIOPConnection = new ServerGIOPConnection(serverIIOPConnection.get_server_profile(), serverIIOPConnection, this.request_listener, this.reply_listener, null, null);
                    this.receptor_pool.connectionCreated(serverGIOPConnection);
                }
                catch (Exception exception) {
                    if (!this.run) continue;
                    Debug.output(4, exception);
                }
            }
            orb.shutdown(this.wait);
        }

        public void stopListening(boolean bl) {
            this.run = false;
            this.wait = bl;
            try {
                this.server_socket.close();
            }
            catch (Exception exception) {
                Debug.output(4, exception);
            }
        }
    }
}

