/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.tools.beanbox.BeanContainer;
import com.bbn.openmap.tools.beanbox.BeanPanel;
import com.bbn.openmap.tools.beanbox.GenericPropertySheet;
import com.bbn.openmap.util.Debug;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.beans.BeanInfo;
import java.util.HashMap;
import java.util.Vector;

public abstract class BeanBox {
    private HashMap beanInfoMap = new HashMap();

    public BeanInfo getBeanInfoForBean(String beanClassName) {
        BeanInfo beanInfo = (BeanInfo)this.beanInfoMap.get(beanClassName);
        if (beanInfo == null && (beanInfo = BeanPanel.findBeanInfo(beanClassName)) != null) {
            this.beanInfoMap.put(beanClassName, beanInfo);
        }
        return beanInfo;
    }

    void addBean(Vector object) {
        if (object == null || object.size() != 3 || !(object.get(1) instanceof BeanInfo) || !(object.get(2) instanceof Point)) {
            throw new IllegalArgumentException("bad drop object " + object);
        }
        Object bean = object.get(0);
        BeanInfo beanInfo = (BeanInfo)object.get(1);
        Point point = (Point)object.get(2);
        this.beanInfoMap.put(bean.getClass().getName(), beanInfo);
        this.prepareForAddition(bean, beanInfo, point);
    }

    void editComplete(Object bean) {
        if (!this.containsBean(bean)) {
            this.addBean(bean);
            this.doSpecialHandling(bean);
        }
    }

    protected void prepareForAddition(Object bean, BeanInfo beanInfo, Point location) {
        try {
            this.setBeanProperties(bean, beanInfo, location);
            this.createPropertySheet(bean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createPropertySheet(Object bean) throws Exception {
        GenericPropertySheet propertySheet = new GenericPropertySheet(bean, 575, 20, null, this);
        propertySheet.setVisible(true);
    }

    protected void doSpecialHandling(Object bean) {
        BeanContainer container;
        if (!(bean instanceof BeanContainer) && (container = this.findEnclosingContainer(bean)) != null) {
            container.add(bean);
        }
    }

    protected Image getDragImage(Object bean) {
        BeanInfo beanInfo = this.getBeanInfoForBean(bean.getClass().getName());
        if (beanInfo == null) {
            if (Debug.debugging("beanbox")) {
                Debug.output("No beanInfo found for bean: " + bean);
            }
            return BeanPanel.defaultBeanIcon.getImage();
        }
        Image img = beanInfo.getIcon(2);
        if (img == null) {
            if (Debug.debugging("beanbox")) {
                Debug.output("No image found in beanInfo for bean: " + bean);
            }
            return BeanPanel.defaultBeanIcon.getImage();
        }
        Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        if (Debug.debugging("beanbox")) {
            Debug.output("" + d);
        }
        img = img.getScaledInstance((int)d.getWidth(), (int)d.getHeight(), 2);
        return img;
    }

    public void showSelected(Object bean) {
    }

    public void showCut(Object bean) {
    }

    public void showUnCut(Object bean) {
    }

    public abstract void addBean(Object var1);

    public abstract void removeBean(Object var1);

    public abstract boolean containsBean(Object var1);

    public abstract void setBeanProperties(Object var1, BeanInfo var2, Point var3);

    public abstract Object getBeanAtLocation(Point var1);

    public abstract BeanContainer findEnclosingContainer(Object var1);

    public abstract void relocateBean(Object var1, BeanInfo var2, Point var3);

    public abstract void beanChanged(Object var1, String var2);
}

