/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ECEFPoint {
    protected static double EQUIVALENT_TOLERANCE = 0.001;
    protected double x_ = 0.0;
    protected double y_ = 0.0;
    protected double z_ = 0.0;

    public ECEFPoint() {
    }

    public ECEFPoint(double x, double y, double z) {
        this.setECEF(x, y, z);
    }

    public ECEFPoint(ECEFPoint pt) {
        this.x_ = pt.x_;
        this.y_ = pt.y_;
        this.z_ = pt.z_;
    }

    public ECEFPoint(float x, float y, float z) {
        this((double)x, (double)y, (double)z);
    }

    public static ECEFPoint LLtoECEF(LatLonPoint llpoint) {
        return ECEFPoint.LLtoECEF(llpoint, new ECEFPoint());
    }

    public static ECEFPoint LLtoECEF(LatLonPoint llpoint, ECEFPoint ecef) {
        if (ecef == null) {
            ecef = new ECEFPoint();
        }
        ecef.setLatLon(llpoint);
        return ecef;
    }

    public String toString() {
        return "ECEFPoint[x=" + this.x_ + ",y=" + this.y_ + ",z=" + this.z_ + "]";
    }

    public void setx(double x) {
        this.x_ = x;
    }

    public void sety(double y) {
        this.y_ = y;
    }

    public void setz(double z) {
        this.z_ = z;
    }

    private void setECEF(double x, double y, double z) {
        this.x_ = x;
        this.y_ = y;
        this.z_ = z;
    }

    private void setECEF(ECEFPoint pt) {
        this.x_ = pt.x_;
        this.y_ = pt.y_;
        this.z_ = pt.z_;
    }

    public double getx() {
        return this.x_;
    }

    public double gety() {
        return this.y_;
    }

    public double getz() {
        return this.z_;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ECEFPoint) {
            ECEFPoint pt = (ECEFPoint)obj;
            return MoreMath.approximately_equal(this.x_, pt.x_, EQUIVALENT_TOLERANCE) && MoreMath.approximately_equal(this.y_, pt.y_, EQUIVALENT_TOLERANCE) && MoreMath.approximately_equal(this.z_, pt.z_, EQUIVALENT_TOLERANCE);
        }
        return false;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeDouble(this.x_);
        s.writeDouble(this.y_);
        s.writeDouble(this.z_);
    }

    public void read(DataInputStream s) throws IOException {
        this.setECEF(s.readDouble(), s.readDouble(), s.readDouble());
    }

    public void setLatLon(LatLonPoint pt) {
        this.setLatLon(pt.getLatitude(), pt.getLongitude());
    }

    public void setLatLon(float lat, float lon) {
        double a = 6378137.0;
        double b = 6356752.3142;
        double a2 = 4.0680631590769E13;
        double b2 = 4.0408299984087055E13;
        double e2 = 0.006694380004260827;
        double L = Math.toRadians(lon);
        double P = Math.toRadians(lat);
        double h = 0.0;
        double cosLat = Math.cos(P);
        double sinLat = Math.sin(P);
        double rn = 6378137.0 / Math.sqrt(1.0 - 0.006694380004260827 * (sinLat * sinLat));
        double x = (rn + 0.0) * cosLat * Math.cos(L);
        double y = (rn + 0.0) * cosLat * Math.sin(L);
        double z = (rn * 0.9933056199957392 + 0.0) * sinLat;
        this.setECEF(x, y, z);
    }

    public LatLonPoint getLatLon() {
        double a = 6378137.0;
        double b = 6356752.3142;
        double a2 = 4.0680631590769E13;
        double b2 = 4.0408299984087055E13;
        double e2 = 0.006694380004260827;
        double ep2 = 0.006739496756586903;
        double COS_67P5 = 0.3826834323650898;
        double AD_C = 1.0026;
        double x = this.x_;
        double y = this.y_;
        double z = this.z_;
        double W2 = x * x + y * y;
        double W = Math.sqrt(W2);
        double T0 = z * 1.0026;
        double S0 = Math.sqrt(T0 * T0 + W2);
        double sin_B0 = T0 / S0;
        double cos_B0 = W / S0;
        double sin3_B0 = sin_B0 * sin_B0 * sin_B0;
        double T1 = z + 42841.311603977185 * sin3_B0;
        double sum = W - 42697.67279723613 * (cos_B0 * cos_B0 * cos_B0);
        double S1 = Math.sqrt(T1 * T1 + sum * sum);
        double sin_p1 = T1 / S1;
        double cos_p1 = sum / S1;
        double longitude = Math.toDegrees(Math.atan2(y, x));
        double latitude = Math.toDegrees(Math.atan(sin_p1 / cos_p1));
        LatLonPoint dst = new LatLonPoint((float)latitude, (float)longitude);
        return dst;
    }
}

