/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.omGraphics.grid.ColoredShadingColors;
import com.bbn.openmap.omGraphics.grid.ElevationColors;
import com.bbn.openmap.omGraphics.grid.GridData;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.GeneralPath;

public class SlopeGenerator
implements OMGridGenerator {
    protected int contrast = 5;
    protected ElevationColors colors = new ColoredShadingColors();
    protected boolean incomplete = false;

    public SlopeGenerator() {
    }

    public SlopeGenerator(ElevationColors elevColors) {
        this.setColors(elevColors);
    }

    public void setColors(ElevationColors elevColors) {
        this.colors = elevColors;
    }

    public ElevationColors getColors() {
        return this.colors;
    }

    public void setContrast(int val) {
        if (val > 10 || val < 1) {
            val = 5;
        }
        this.contrast = val;
    }

    public int getContrast() {
        return this.contrast;
    }

    protected OMRaster getRaster(OMGrid grid) {
        return new OMRaster(grid.point1.x, grid.point1.y, grid.width, grid.height, new int[grid.width * grid.height]);
    }

    public boolean isIncompleteImage() {
        return this.incomplete;
    }

    public OMRaster generateRasterForProjection(OMGrid grid, Projection proj) {
        OMGraphic omg = this.generate(grid, proj);
        if (omg instanceof OMRaster) {
            return (OMRaster)omg;
        }
        return null;
    }

    public OMGraphic generate(OMGrid grid, Projection proj) {
        GeneralPath gridShape = grid.getShape();
        if (gridShape == null || !gridShape.intersects(0.0, 0.0, proj.getWidth(), proj.getHeight())) {
            if (Debug.debugging("grid")) {
                Debug.output("SlopeGenerator: OMGrid does not overlap map, skipping generation.");
            }
            return SinkGraphic.getSharedInstance();
        }
        OMRaster raster = this.getRaster(grid);
        this.incomplete = false;
        if (grid.height == 0 || grid.width == 0) {
            Debug.message("grid", "SlopeGenerator: grid height/width ZERO!");
            return raster;
        }
        GridData gd = grid.getData();
        if (!(gd instanceof GridData.Short)) {
            Debug.message("grid", "SlopeGenerator: grid doesn't contain short data.");
            return SinkGraphic.getSharedInstance();
        }
        int rows = grid.getRows();
        int columns = grid.getColumns();
        short[][] data = ((GridData.Short)gd).getData();
        boolean major = grid.getMajor();
        double distance = this.getSlopeRun(grid, this.getContrast());
        LatLonPoint llp = new LatLonPoint();
        Point point = new Point();
        ElevationColors colors = this.getColors();
        if (colors == null) {
            return SinkGraphic.getSharedInstance();
        }
        int x = 0;
        while (x < grid.width) {
            int screenx = (int)grid.point1.getX() + x;
            if (screenx < 0 || screenx > proj.getWidth()) {
                this.incomplete = true;
            } else {
                int y = 0;
                while (y < grid.height) {
                    int screeny = (int)grid.point1.getY() + y;
                    if (screeny < 0 || screeny > proj.getHeight()) {
                        this.incomplete = true;
                    } else {
                        point.setLocation(screenx, screeny);
                        llp = proj.inverse(point, llp);
                        int yc = Math.round((llp.getLatitude() - grid.getLatitude()) / grid.getVerticalResolution());
                        int xc = Math.round((llp.getLongitude() - grid.getLongitude()) / grid.getHorizontalResolution());
                        if (yc < 0) {
                            yc = 0;
                        }
                        if (yc > rows - 1) {
                            yc = rows - 1;
                        }
                        if (xc < 0) {
                            xc = 0;
                        }
                        if (xc > columns - 1) {
                            xc = columns - 1;
                        }
                        short elevation = 0;
                        try {
                            elevation = data[xc][yc];
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            Debug.output("Error Accessing data array:\n\txc: " + xc + ", yc: " + yc + " for x: " + x + ", y: " + y);
                        }
                        int xnw = xc - 1;
                        int xse = xc + 1;
                        if (xc == 0 || xnw < 0) {
                            xnw = xc;
                        }
                        if (xc == columns - 1 || xse > columns - 1) {
                            xse = columns - 1;
                        }
                        int yse = yc - 1;
                        int ynw = yc + 1;
                        if (yse < 0) {
                            yse = 0;
                        }
                        if (yc == rows - 1 || ynw > rows - 1) {
                            ynw = rows - 1;
                        }
                        try {
                            short e2 = data[xse][yse];
                            short e1 = data[xnw][ynw];
                            double slope = (double)(e2 - e1) / distance;
                            raster.setPixel(x, y, colors.getARGB(elevation, grid.getUnits(), slope));
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            Debug.output("Error Accessing data array:\n\txse: " + xse + ", yse: " + yse + "\n\txnw: " + xnw + ", ynw: " + ynw + "\n\tfor x: " + x + ", y: " + y);
                        }
                    }
                    y = (short)(y + 1);
                }
            }
            x = (short)(x + 1);
        }
        raster.generate(proj);
        if (Debug.debugging("grid")) {
            Debug.output("SlopeGenerator: leaving generate");
        }
        return raster;
    }

    public boolean needGenerateToRender() {
        return true;
    }

    protected double getSlopeRun(OMGrid grid, int contrastAdj) {
        double modifier = 0.045;
        int h = 0;
        while (h < contrastAdj) {
            modifier -= 0.005;
            ++h;
        }
        float vRes = grid.getVerticalResolution();
        float hRes = grid.getHorizontalResolution();
        float vResRad = Length.DECIMAL_DEGREE.toRadians(vRes);
        float hResRad = Length.DECIMAL_DEGREE.toRadians(hRes);
        Length units = grid.getUnits();
        double vDist = Math.pow(2.0 * (double)units.fromRadians(vResRad), 2.0);
        double hDist = Math.pow(2.0 * (double)units.fromRadians(hResRad), 2.0);
        return modifier * Math.sqrt(vDist + hDist);
    }
}

