/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMLabeler;
import com.bbn.openmap.omGraphics.OMText;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class OMTextLabeler
extends OMText
implements OMLabeler {
    public OMTextLabeler(String stuff) {
        this(stuff, OMText.DEFAULT_FONT, 0);
    }

    public OMTextLabeler(String stuff, int just) {
        this(stuff, OMText.DEFAULT_FONT, just);
    }

    public OMTextLabeler(String stuff, Font font, int just) {
        this.setRenderType(2);
        this.setData(stuff);
        this.setFont(font);
        this.setJustify(just);
    }

    public void setLocation(GeneralPath gp) {
        Rectangle rect = gp.getBounds();
        this.setLocation(new Point((int)(rect.getX() + rect.getWidth() / 2.0), (int)(rect.getY() + rect.getHeight() / 2.0)));
    }

    public void setLocation(Point p) {
        this.polyBounds = null;
        this.setX((int)p.getX());
        this.setY((int)p.getY());
        this.setMapLocation(p);
        this.computeBounds();
        this.setNeedToRegenerate(false);
    }

    public void setLocation(int[] xpoints, int[] ypoints) {
        this.setLocation(this.getCenter(xpoints, ypoints));
    }

    protected double calculateProjectedArea(int[] xpts, int[] ypts) {
        int j = 0;
        double area = 0.0;
        int npoints = xpts.length;
        int i = 0;
        while (i < npoints) {
            j = (i + 1) % npoints;
            area += (double)(xpts[i] * ypts[j]);
            area -= (double)(ypts[i] * xpts[j]);
            ++i;
        }
        return area / 2.0;
    }

    protected Point getCenter(int[] xpts, int[] ypts) {
        float cx = 0.0f;
        float cy = 0.0f;
        double A = this.calculateProjectedArea(xpts, ypts);
        int j = 0;
        double factor = 0.0;
        int npoints = xpts.length;
        int i = 0;
        while (i < npoints) {
            j = (i + 1) % npoints;
            factor = xpts[i] * ypts[j] - xpts[j] * ypts[i];
            cx = (float)((double)cx + (double)(xpts[i] + xpts[j]) * factor);
            cy = (float)((double)cy + (double)(ypts[i] + ypts[j]) * factor);
            ++i;
        }
        factor = 1.0 / (A *= 6.0);
        cx = (float)((double)cx * factor);
        cy = (float)((double)cy * factor);
        Point center = new Point(Math.round(cx), Math.round(cy));
        return center;
    }
}

