/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameCacheHandler;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfIndexedImageData;
import com.bbn.openmap.layer.rpf.RpfSubframe;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.util.Vector;

public class RpfCacheHandler {
    public static final int SUBFRAME_CACHE_SIZE = 20;
    public static final int MAX_NUM_DESC = 20;
    public static final int MAX_DESC_LEN = 512;
    public static final int DEFAULT_SUBFRAMEBUFFER = 5;
    public static final int NOT_CACHED = -1;
    public static final int NOT_PRESENT = -2;
    protected int scalingHeight = 256;
    protected int scalingWidth = 256;
    protected SubframeCache cache;
    protected Vector coverageBoxes;
    protected int[][] subframeIndex;
    protected int[][] subframeVersion;
    protected int subframeCacheSize;
    protected RpfViewAttributes viewAttributes;
    protected RpfFrameProvider frameProvider;
    protected Point start = new Point();
    protected Point end = new Point();
    protected boolean goodData = false;
    protected int subframeBuffer = 5;
    private float lastScaleDifference = -1.0f;
    protected boolean DEBUG_RPF = Debug.debugging("rpf");
    protected boolean DEBUG_RPFDETAIL = Debug.debugging("rpfdetail");

    public RpfCacheHandler(RpfFrameProvider provider, RpfViewAttributes rva) {
        this(provider, rva, 20);
    }

    public RpfCacheHandler(RpfFrameProvider provider, RpfViewAttributes rva, int subframe_cache_size) {
        this.frameProvider = provider;
        this.viewAttributes = rva;
        this.updateViewAttributes();
        this.subframeCacheSize = subframe_cache_size;
        this.initCache(true);
        if (this.DEBUG_RPF) {
            Debug.output("RpfCacheHandler: Created with cache size of " + this.subframeCacheSize);
        }
    }

    public void setViewAttributes(RpfViewAttributes rva) {
        this.viewAttributes = rva;
        this.updateViewAttributes();
        this.clearCache();
    }

    public RpfViewAttributes getViewAttributes() {
        return this.viewAttributes;
    }

    public void setFrameProvider(RpfFrameProvider fp) {
        this.frameProvider = fp;
        if (this.frameProvider != null) {
            this.frameProvider.setViewAttributes(this.viewAttributes);
        }
        this.clearCache();
    }

    public RpfFrameProvider getFrameProvider() {
        return this.frameProvider;
    }

    public void updateViewAttributes() {
        if (this.frameProvider != null) {
            this.frameProvider.setViewAttributes(this.viewAttributes);
        }
    }

    public Vector getCoverageBoxes() {
        return this.coverageBoxes;
    }

    public void setCache(float ullat, float ullon, float lrlat, float lrlon, CADRG proj) {
        boolean needNewCoverage = true;
        String oldID = null;
        RpfCoverageBox currentBox = null;
        if (this.coverageBoxes != null && this.coverageBoxes.size() != 0) {
            currentBox = (RpfCoverageBox)this.coverageBoxes.elementAt(0);
            oldID = currentBox.getID();
            float currentPercentCoverage = currentBox.getPercentCoverage();
            if (this.DEBUG_RPF) {
                Debug.output("RpfCachehandler: checking current coverage before re-query:");
            }
            float currentScaleDifference = RpfFrameCacheHandler.scaleDifference(proj, currentBox);
            if (currentPercentCoverage <= currentBox.setPercentCoverage(ullat, ullon, lrlat, lrlon, this.start, this.end) && this.lastScaleDifference == currentScaleDifference) {
                needNewCoverage = false;
                this.goodData = true;
                this.lastScaleDifference = currentScaleDifference;
                if (this.DEBUG_RPF) {
                    Debug.output("RpfCachehandler: reusing Coverage");
                }
            }
        }
        if (needNewCoverage) {
            if (this.DEBUG_RPF) {
                Debug.output("RpfCacheHandler: Need new Coverage.");
            }
            this.coverageBoxes = this.frameProvider != null ? this.frameProvider.getCoverage(ullat, ullon, lrlat, lrlon, proj) : null;
            if (this.coverageBoxes == null || this.coverageBoxes.size() == 0) {
                this.goodData = false;
                return;
            }
            currentBox = (RpfCoverageBox)this.coverageBoxes.elementAt(0);
            if (!currentBox.getID().equals(oldID)) {
                this.resetSubframeIndex(currentBox.verticalSubframes(), currentBox.horizontalSubframes());
                this.initCache(false);
            }
            this.start = currentBox.startIndexes;
            this.end = currentBox.endIndexes;
            this.goodData = true;
        }
        int i = 1;
        while (i < this.coverageBoxes.size()) {
            ((RpfCoverageBox)this.coverageBoxes.elementAt(i)).setPercentCoverage(ullat, ullon, lrlat, lrlon);
            ++i;
        }
        if (this.DEBUG_RPF) {
            Debug.output("RpfCachehandler: ####################");
            Debug.output("" + currentBox);
            Debug.output(" Starting point " + this.start);
            Debug.output(" Ending point " + this.end);
        }
        if (this.viewAttributes.scaleImages) {
            LatLonPoint refllpt = this.viewAttributes.proj.getUpperLeft();
            refllpt.setLongitude(refllpt.getLongitude() + (float)currentBox.subframeLonInterval);
            refllpt.setLatitude(refllpt.getLatitude() - (float)currentBox.subframeLatInterval);
            Point refpt = this.viewAttributes.proj.forward(refllpt);
            this.scalingWidth = refpt.x;
            this.scalingHeight = refpt.y;
        } else {
            this.scalingWidth = 256;
            this.scalingHeight = 256;
        }
        if (this.cache != null) {
            i = 0;
            while (i < this.subframeCacheSize) {
                this.cache.subframe[i].setScalingTo(this.scalingWidth, this.scalingHeight);
                ++i;
            }
        }
    }

    protected void resetSubframeIndex(int vertFrames, int horizFrames) {
        int matrixheight = vertFrames * 6 + this.subframeBuffer * 2;
        int matrixwidth = horizFrames * 6 + this.subframeBuffer * 2;
        this.subframeIndex = new int[matrixheight][matrixwidth];
        this.subframeVersion = new int[matrixheight][matrixwidth];
        this.clearCache();
    }

    public void clearCache() {
        if (this.subframeIndex != null && this.subframeVersion != null) {
            int i = 0;
            while (i < this.subframeIndex.length) {
                int j = 0;
                while (j < this.subframeIndex[0].length) {
                    this.subframeIndex[i][j] = -1;
                    this.subframeVersion[i][j] = -1;
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean getGoodData() {
        return this.goodData;
    }

    protected void initCache(boolean newCache) {
        if (this.subframeCacheSize <= 0) {
            this.cache = null;
            return;
        }
        if (newCache || this.cache == null) {
            this.cache = new SubframeCache(this.subframeCacheSize);
        }
        this.cache.LRU_head = 0;
        this.cache.LRU_tail = this.subframeCacheSize - 1;
        int i = 0;
        while (i < this.subframeCacheSize) {
            if (newCache) {
                try {
                    this.cache.subframe[i] = new RpfSubframe(this.viewAttributes.colorModel);
                }
                catch (OutOfMemoryError oome) {
                    Debug.error("RpfCacheHandler: \n\tRan out of memory allocating the image cache.\tConsider increasing the java memory heap using the -Xmx option.");
                    this.cache = null;
                    this.subframeCacheSize = i;
                    Debug.output("RpfCacheHandler: reseting cache size to " + this.subframeCacheSize);
                    this.initCache(true);
                    return;
                }
            }
            this.cache.subframe[i].setScalingTo(this.scalingWidth, this.scalingHeight);
            this.cache.subframe[i].version = 0;
            this.cache.subframe[i].nextSubframe = i < this.subframeCacheSize - 1 ? i + 1 : 0;
            this.cache.subframe[i].prevSubframe = i > 0 ? i - 1 : this.subframeCacheSize - 1;
            ++i;
        }
    }

    protected int getLRU() {
        if (this.cache != null) {
            return this.cache.LRU_tail;
        }
        return -1;
    }

    protected void freeCache(int index) {
        if (this.cache == null) {
            return;
        }
        if (index == this.cache.LRU_tail) {
            return;
        }
        if (index == this.cache.LRU_head) {
            this.cache.LRU_head = this.cache.subframe[this.cache.LRU_head].nextSubframe;
        } else {
            int prev;
            int next = this.cache.subframe[index].nextSubframe;
            this.cache.subframe[next].prevSubframe = prev = this.cache.subframe[index].prevSubframe;
            this.cache.subframe[prev].nextSubframe = next;
        }
        this.cache.subframe[this.cache.LRU_tail].nextSubframe = index;
        this.cache.subframe[index].prevSubframe = this.cache.LRU_tail;
        this.cache.LRU_tail = index;
    }

    protected void referenceCache(int index) {
        if (this.cache == null) {
            return;
        }
        if (index == this.cache.LRU_head) {
            return;
        }
        if (index == this.cache.LRU_tail) {
            this.cache.LRU_tail = this.cache.subframe[this.cache.LRU_tail].prevSubframe;
        } else {
            int prev;
            int next = this.cache.subframe[index].nextSubframe;
            this.cache.subframe[next].prevSubframe = prev = this.cache.subframe[index].prevSubframe;
            this.cache.subframe[prev].nextSubframe = next;
        }
        this.cache.subframe[this.cache.LRU_head].prevSubframe = index;
        this.cache.subframe[index].nextSubframe = this.cache.LRU_head;
        this.cache.LRU_head = index;
    }

    public int getCacheSize() {
        return this.subframeCacheSize;
    }

    protected RpfSubframe getSubframeFromOtherTOC(int x, int y) {
        return this.getSubframeFromOtherTOC(x, y, -1);
    }

    protected RpfSubframe getSubframeFromOtherTOC(int x, int y, int subframeCount) {
        int size = this.coverageBoxes.size();
        RpfCoverageBox currentBox = null;
        Point tmpStart = new Point();
        Point tmpEnd = new Point();
        boolean cacheIt = false;
        RpfSubframe ret = null;
        int index = 0;
        if (size < 2) {
            return null;
        }
        if (y < 0 || x < 0 || y >= this.subframeIndex.length || x >= this.subframeIndex[0].length || subframeCount >= this.subframeCacheSize) {
            cacheIt = false;
        }
        int i = 1;
        while (i < size) {
            try {
                currentBox = (RpfCoverageBox)this.coverageBoxes.elementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                return null;
            }
            int offsetX = x - this.start.x;
            int offsetY = y - this.start.y;
            int newX = currentBox.startIndexes.x + offsetX;
            int newY = currentBox.startIndexes.y + offsetY;
            if (cacheIt) {
                index = this.getLRU();
                if (index < 0 || index >= this.subframeCacheSize || subframeCount >= this.subframeCacheSize) {
                    ret = null;
                } else {
                    this.referenceCache(index);
                    this.subframeIndex[y][x] = index;
                    this.subframeVersion[y][x] = ++this.cache.subframe[index].version;
                    ret = this.cache.subframe[index];
                }
            }
            if (ret == null) {
                try {
                    ret = new RpfSubframe(this.viewAttributes.colorModel);
                    ret.setScalingTo(this.scalingWidth, this.scalingHeight);
                }
                catch (OutOfMemoryError oome) {
                    Debug.error("RpfCacheHandler: Out of memory!  No subframe for you!  Next up!");
                    return null;
                }
            }
            if (this.loadSubframe(ret, currentBox, newX, newY)) {
                return ret;
            }
            if (cacheIt) {
                this.freeCache(index);
                this.subframeIndex[y][x] = -2;
            }
            ++i;
        }
        return null;
    }

    protected RpfSubframe getCached(int cbx, int cby) {
        return this.getCached(cbx, cby, -1);
    }

    /*
     * Unable to fully structure code
     */
    protected RpfSubframe getCached(int cbx, int cby, int subframeCount) {
        currentBox = null;
        x = cbx + this.subframeBuffer;
        y = cby + this.subframeBuffer;
        if (this.coverageBoxes == null || this.coverageBoxes.size() == 0 || y < 0 || x < 0 || y >= this.subframeIndex.length || x >= this.subframeVersion[0].length) {
            return null;
        }
        try {
            currentBox = (RpfCoverageBox)this.coverageBoxes.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
        index = this.subframeIndex[y][x];
        if (index == -2) {
            return null;
        }
        if (index != -1 && this.cache != null && this.cache.subframe[index].version == this.subframeVersion[y][x] && subframeCount < this.subframeCacheSize) {
            this.referenceCache(index);
            ret = this.cache.subframe[index];
            if (this.DEBUG_RPF) {
                Debug.output("RpfCacheHandler: found subframe " + x + ", " + y + " in cache.");
            }
            if (this.viewAttributes.colorModel == 0) {
                if (ret.opaqueness != this.viewAttributes.opaqueness) {
                    pixels = ret.image.getPixels();
                    ret.opaqueness = this.viewAttributes.opaqueness;
                    i = 0;
                    while (i < pixels.length) {
                        pixels[i] = 0xFFFFFF & pixels[i] | this.viewAttributes.opaqueness << 24;
                        ++i;
                    }
                    ret.image.setNeedToRegenerate(true);
                }
            } else if (ret.opaqueness != this.viewAttributes.opaqueness) {
                ret.opaqueness = this.viewAttributes.opaqueness;
                ret.image.setTransparent(this.viewAttributes.opaqueness);
                ret.image.setNeedToRegenerate(true);
            }
            if (this.frameProvider != null && this.viewAttributes.showInfo && (ret.getAttributeText() == null || ret.getAttributeText().equals(""))) {
                ret.setAttributeText(this.frameProvider.getSubframeAttributes(currentBox.tocNumber, currentBox.entryNumber, x, y));
                ret.setScalingTo(this.scalingWidth, this.scalingHeight);
            }
            return ret;
        }
        index = this.getLRU();
        if (index < 0 || index >= this.subframeCacheSize || subframeCount >= this.subframeCacheSize) {
            try {
                ret = new RpfSubframe(this.viewAttributes.colorModel);
                if (!this.DEBUG_RPF) ** GOTO lbl52
                Debug.output("RpfCacheHandler: using uncached subframe.");
            }
            catch (OutOfMemoryError oome) {
                Debug.error("RpfCacheHandler: Out of memory!  No subframe for you!  Next up!");
                return null;
            }
        } else {
            this.referenceCache(index);
            this.subframeIndex[y][x] = index;
            this.subframeVersion[y][x] = ++this.cache.subframe[index].version;
            ret = this.cache.subframe[index];
        }
lbl52:
        // 3 sources

        if (this.loadSubframe(ret, currentBox, cbx, cby)) {
            return ret;
        }
        this.freeCache(index);
        this.subframeIndex[y][x] = -2;
        return null;
    }

    protected boolean loadSubframe(RpfSubframe subframe, RpfCoverageBox coverageBox, int x, int y) {
        boolean good = false;
        int[] pixels = null;
        Object ii = null;
        if (this.frameProvider == null) {
            Debug.message("rpf", "RpfCacheHandler.loadSubframes(): null frameProvider");
            return false;
        }
        if (this.viewAttributes.colorModel == 0) {
            pixels = this.frameProvider.getSubframeData(coverageBox.tocNumber, coverageBox.entryNumber, x, y);
            if (pixels != null) {
                subframe.image.setPixels(pixels);
                good = true;
            }
        } else if (this.viewAttributes.colorModel == 1) {
            RpfIndexedImageData riid = this.frameProvider.getRawSubframeData(coverageBox.tocNumber, coverageBox.entryNumber, x, y);
            if (riid != null && riid.imageData != null && riid.colortable != null) {
                subframe.opaqueness = this.viewAttributes.opaqueness;
                subframe.image.setBits(riid.imageData);
                subframe.image.setColors(riid.colortable);
                subframe.image.setTransparent(this.viewAttributes.opaqueness);
                good = true;
            }
        } else {
            Debug.error("RpfCacheHandler: Frame Provider colormodel not handled.");
            return false;
        }
        if (good) {
            double ylloffset = (double)y * coverageBox.subframeLatInterval;
            double xlloffset = (double)x * coverageBox.subframeLonInterval;
            float lat = (float)(coverageBox.nw_lat - ylloffset);
            float lon = (float)(coverageBox.nw_lon + xlloffset);
            float lat2 = (float)((double)lat - coverageBox.subframeLatInterval);
            float lon2 = (float)((double)lon + coverageBox.subframeLonInterval);
            String data = this.viewAttributes != null && (this.viewAttributes.autofetchAttributes || this.viewAttributes.showInfo) ? this.frameProvider.getSubframeAttributes(coverageBox.tocNumber, coverageBox.entryNumber, x, y) : "";
            if (this.DEBUG_RPFDETAIL) {
                Debug.output("Attribute data for subframe " + x + ", " + y + ":\n" + data);
            }
            subframe.setLocation(lat, lon, lat2, lon2);
            subframe.setAttributeText(data);
            return true;
        }
        subframe.setAttributeText("");
        return false;
    }

    public static class SubframeCache {
        RpfSubframe[] subframe;
        int LRU_head;
        int LRU_tail;

        public SubframeCache(int numSubframes) {
            this.subframe = new RpfSubframe[numSubframes];
        }
    }
}

