/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkCircle
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float latPoint, float lonPoint, int w, int h, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkCircle.write(latPoint, lonPoint, 0, 0, w, h, properties, dos);
    }

    public static void write(int x1, int y1, int w, int h, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:CIRCLE>".getBytes());
        dos.writeInt(6);
        dos.writeInt(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(w);
        dos.writeInt(h);
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:CIRCLE>".getBytes());
        dos.writeInt(6);
        dos.writeInt(3);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeInt(w);
        dos.writeInt(h);
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, float radius, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkCircle.write(latPoint, lonPoint, radius, -1, -1, properties, dos);
    }

    public static void write(float latPoint, float lonPoint, float radius, int units, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkCircle.write(latPoint, lonPoint, radius, units, -1, properties, dos);
    }

    public static void write(float latPoint, float lonPoint, float radius, int units, int nverts, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:CIRCLE>".getBytes());
        dos.writeInt(6);
        dos.writeInt(1);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeFloat(radius);
        dos.writeInt(units);
        dos.writeInt(nverts);
        properties.write(dos);
    }

    public static void write(OMCircle circle, Link link, LinkProperties props) throws IOException {
        switch (circle.getRenderType()) {
            case 1: {
                LatLonPoint llp = circle.getLatLon();
                LinkCircle.write(llp.getLatitude(), llp.getLongitude(), circle.getRadius(), props, link.dos);
                break;
            }
            case 2: {
                LinkCircle.write(circle.getX(), circle.getY(), circle.getWidth(), circle.getHeight(), props, (DataOutputStream)link.dos);
                break;
            }
            case 3: {
                LatLonPoint llp = circle.getLatLon();
                LinkCircle.write(llp.getLatitude(), llp.getLongitude(), circle.getOffX(), circle.getOffY(), circle.getWidth(), circle.getHeight(), props, link.dos);
                break;
            }
            default: {
                Debug.error("LinkCircle.write: circle rendertype unknown.");
            }
        }
    }

    public static OMCircle read(DataInputStream dis) throws IOException {
        OMCircle circle = null;
        int renderType = dis.readInt();
        switch (renderType) {
            case 1: {
                float lat = dis.readFloat();
                float lon = dis.readFloat();
                float radius = dis.readFloat();
                int units = dis.readInt();
                int nverts = dis.readInt();
                Length unit = Length.DECIMAL_DEGREE;
                switch (units) {
                    case 0: {
                        unit = Length.KM;
                        break;
                    }
                    case 1: {
                        unit = Length.MILE;
                        break;
                    }
                    case 2: {
                        unit = Length.NM;
                        break;
                    }
                }
                circle = new OMCircle(new LatLonPoint(lat, lon), radius, unit, nverts);
                break;
            }
            case 2: {
                int x = dis.readInt();
                int y = dis.readInt();
                int w = dis.readInt();
                int h = dis.readInt();
                circle = new OMCircle(x, y, w, h);
                break;
            }
            case 3: {
                float lat = dis.readFloat();
                float lon = dis.readFloat();
                int x = dis.readInt();
                int y = dis.readInt();
                int w = dis.readInt();
                int h = dis.readInt();
                circle = new OMCircle(lat, lon, x, y, w, h);
                break;
            }
        }
        LinkProperties properties = new LinkProperties(dis);
        if (circle != null) {
            properties.setProperties(circle);
        }
        return circle;
    }
}

