/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.layer.dted.DTEDFrame;
import com.bbn.openmap.layer.dted.DTEDFrameUtil;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class DTEDFrameCache
extends CacheHandler
implements PropertyConsumer {
    public static final int NO_DATA = -500;
    public static final int MAX_DTED_LEVEL = 1;
    protected String[] dtedDirPaths;
    protected String[] dted2DirPaths;
    protected int numXSubframes;
    protected int numYSubframes;
    public static final String DTEDPathsProperty = "paths";
    public static final String DTED2PathsProperty = "level2.paths";
    public static final String DTEDFrameCacheSizeProperty = "cacheSize";
    protected String propertyPrefix = null;

    public DTEDFrameCache() {
    }

    public DTEDFrameCache(String[] dtedPaths, int max_size) {
        super(max_size);
        this.dtedDirPaths = dtedPaths;
    }

    public DTEDFrameCache(String[] dtedPaths, String[] dted2Paths, int max_size) {
        super(max_size);
        this.dtedDirPaths = dtedPaths;
        this.dted2DirPaths = dted2Paths;
    }

    public void setDtedDirPaths(String[] paths) {
        this.dtedDirPaths = paths;
    }

    public void setDtedDirPaths(String[] paths, String[] paths2) {
        this.dtedDirPaths = paths;
        this.dted2DirPaths = paths2;
    }

    public String findFileName(double lat, double lon, int level) {
        String lonString = DTEDFrameUtil.lonToFileString((float)lon);
        String latString = DTEDFrameUtil.latToFileString((float)lat, level);
        String partialFile = "/" + lonString + "/" + latString;
        String[] searchPaths = this.dtedDirPaths;
        String ret = this.findFileName(this.dtedDirPaths, partialFile);
        if (ret == null && level == 2) {
            latString = DTEDFrameUtil.latToFileString((float)lat, 1);
            partialFile = "/" + lonString + "/" + latString;
            ret = this.findFileName(this.dted2DirPaths, partialFile);
        }
        return ret;
    }

    protected String findFileName(String[] searchPaths, String partialFile) {
        if (searchPaths == null || searchPaths.length == 0) {
            return null;
        }
        int i = 0;
        while (i < searchPaths.length) {
            String dtedFileName = searchPaths[i] + partialFile;
            if (BinaryFile.exists(dtedFileName)) {
                return dtedFileName;
            }
            ++i;
        }
        return null;
    }

    public DTEDFrame get(double lat, double lon, int level) {
        String name = this.findFileName(lat, lon, level);
        if (name != null) {
            return (DTEDFrame)this.get(name);
        }
        return null;
    }

    public CacheObject load(String dtedFramePath) {
        if (dtedFramePath != null) {
            DTEDFrame frame = new DTEDFrame(dtedFramePath, dtedFramePath.endsWith("dt0"));
            frame.initSubframes(this.numXSubframes, this.numYSubframes);
            if (frame.frame_is_valid) {
                return new DTEDCacheObject(dtedFramePath, frame);
            }
        }
        return null;
    }

    public void resizeCache(int max_size, int num_x_subframes, int num_y_subframes) {
        boolean destructive = false;
        if (num_x_subframes > 0 && num_y_subframes > 0) {
            this.numXSubframes = num_x_subframes;
            this.numYSubframes = num_y_subframes;
            destructive = true;
            Debug.message("dted", "DTEDFrameCache: destructive resizing");
        } else {
            Debug.message("dted", "DTEDFrameCache: passive resizing");
        }
        CacheObject[] oldObjs = this.objs;
        if (max_size != this.objs.length && max_size > 0) {
            this.objs = new CacheObject[max_size];
        }
        int i = 0;
        while (i < this.objs.length) {
            block8: {
                block11: {
                    block10: {
                        DTEDFrame frame;
                        block9: {
                            DTEDCacheObject dco;
                            block7: {
                                if (i >= oldObjs.length) break;
                                dco = (DTEDCacheObject)oldObjs[i];
                                if (dco != null) break block7;
                                this.objs[i] = null;
                                break block8;
                            }
                            frame = (DTEDFrame)dco.obj;
                            dco.cachedTime = 0;
                            if (frame != null) break block9;
                            Debug.output("DTEDFrameCache: No Frame for key!");
                            break block8;
                        }
                        if (!destructive) break block10;
                        frame.initSubframes(num_x_subframes, num_y_subframes);
                        break block11;
                    }
                    if (oldObjs == this.objs) break block8;
                }
                this.objs[i] = i < oldObjs.length ? oldObjs[i] : null;
            }
            ++i;
        }
        oldObjs = null;
    }

    public void resizeCache(int max_size) {
        this.resizeCache(max_size, 0, 0);
    }

    public int getElevation(float lat, float lon) {
        int i = 1;
        while (i >= 0) {
            DTEDFrame frame = null;
            String dtedFileName = this.findFileName(lat, lon, i);
            if (dtedFileName != null) {
                frame = (DTEDFrame)this.get(dtedFileName);
            }
            if (frame != null) {
                return frame.elevationAt(lat, lon);
            }
            --i;
        }
        return -500;
    }

    public short[][] getElevations(EqualArc proj, int dtedLevel) {
        LatLonPoint ul = proj.getUpperLeft();
        LatLonPoint lr = proj.getLowerRight();
        return this.getElevations(ul.getLatitude(), ul.getLongitude(), lr.getLatitude(), lr.getLongitude(), dtedLevel);
    }

    public short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon, int dtedLevel) {
        return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, null);
    }

    protected short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon, int dtedLevel, DTEDFrame refFrame) {
        int y;
        float upper = ullat;
        float lower = lrlat;
        float right = lrlon;
        float left = ullon;
        if (ullon > lrlon) {
            if (ullon > 0.0f && lrlon < 0.0f) {
                Debug.error("DTEDFrameCache: getElevations: Stradling dateline not handled!");
                return null;
            }
            right = ullon;
            left = lrlon;
        }
        if (lrlat > ullat) {
            upper = lrlat;
            lower = ullat;
        }
        float upperlat = 0.0f;
        float upperlon = 0.0f;
        float lowerlat = 0.0f;
        float lowerlon = 0.0f;
        int xSize = (int)(Math.ceil(right) - Math.floor(left));
        int ySize = (int)(Math.ceil(upper) - Math.floor(lower));
        int[] xLengths = new int[xSize];
        int[] yLengths = new int[ySize];
        short[][][][] es = new short[xSize][ySize][][];
        DTEDFrame frame = null;
        boolean needCalc = false;
        int x = 0;
        while (x < xSize) {
            lowerlon = x == 0 ? left : (float)Math.floor(left) + (float)x;
            upperlon = x == xSize - 1 ? right : (float)Math.floor(left) + (float)(x + 1);
            y = 0;
            while (y < ySize) {
                lowerlat = y == 0 ? lower : (float)Math.floor(lower) + (float)y;
                upperlat = y == ySize - 1 ? upper : (float)Math.floor(lower) + (float)(y + 1);
                DTEDFrame thisFrame = this.get(lowerlat, lowerlon, dtedLevel);
                if (thisFrame != null) {
                    es[x][y] = thisFrame.getElevations(upperlat, lowerlon, lowerlat, upperlon);
                    xLengths[x] = es[x][y].length;
                    yLengths[y] = es[x][y][0].length;
                    frame = thisFrame;
                } else if (refFrame != null) {
                    Debug.output("DTEDFrameCache: Missing frames, going to use reference frame");
                    int[] indexes = refFrame.getIndexesFromLatLons(upperlat, lowerlon, lowerlat, upperlon);
                    xLengths[x] = indexes[2] - indexes[0] + 1;
                    yLengths[y] = indexes[3] - indexes[1] + 1;
                } else {
                    if (frame != null) {
                        return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, frame);
                    }
                    needCalc = true;
                }
                ++y;
            }
            ++x;
        }
        if (needCalc && frame != null) {
            return this.getElevations(ullat, ullon, lrlat, lrlon, dtedLevel, frame);
        }
        int xLength = 0;
        int yLength = 0;
        x = 0;
        while (x < xLengths.length) {
            xLength += xLengths[x];
            ++x;
        }
        y = 0;
        while (y < yLengths.length) {
            yLength += yLengths[y];
            ++y;
        }
        short[][] matrix = new short[xLength][yLength];
        int xspacer = 0;
        x = 0;
        while (x < es.length) {
            int yspacer = 0;
            y = 0;
            while (y < es[x].length) {
                if (es[x][y] != null) {
                    int i = 0;
                    while (i < es[x][y].length) {
                        System.arraycopy(es[x][y][i], 0, matrix[i + xspacer], yspacer, es[x][y][i].length);
                        ++i;
                    }
                    yspacer += yLengths[y];
                } else {
                    yspacer += xLengths[y];
                }
                ++y;
            }
            xspacer += xLengths[x];
            ++x;
        }
        return matrix;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(this);
        String[] paths = LayerUtils.initPathsFromProperties(props, prefix + DTEDPathsProperty);
        String[] paths2 = LayerUtils.initPathsFromProperties(props, prefix + DTED2PathsProperty);
        this.setDtedDirPaths(paths, paths2);
        this.resetCache(LayerUtils.intFromProperties(props, prefix + DTEDFrameCacheSizeProperty, 20));
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + DTEDFrameCacheSizeProperty, Integer.toString(this.getCacheSize()));
        String prop = null;
        int j = 0;
        while (j < 2) {
            String[] p;
            StringBuffer pathString = new StringBuffer();
            if (j == 0) {
                p = this.dtedDirPaths;
                prop = DTEDPathsProperty;
            } else {
                p = this.dted2DirPaths;
                prop = DTED2PathsProperty;
            }
            if (p != null) {
                int i = 0;
                while (i < p.length) {
                    if (p[i] != null) {
                        pathString.append(p[i]);
                        if (i < p.length - 1) {
                            pathString.append(";");
                        }
                    }
                    ++i;
                }
                props.put(prefix + prop, pathString.toString());
            } else {
                props.put(prefix + prop, "");
            }
            ++j;
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(DTEDPathsProperty, "Paths to the DTED Level 0 and 1 directories");
        props.put(DTED2PathsProperty, "Paths to the DTED Level 2 directories");
        props.put(DTEDFrameCacheSizeProperty, "Size of the frame cache");
        return props;
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            Debug.output("DTEDFrameCache:  Need a path/filename");
            System.exit(0);
        }
        Debug.output("DTEDFrameCache: " + args[0]);
        DTEDFrameCache dfc = new DTEDFrameCache(args, args, 10);
        float ullat = 37.002f;
        float ullon = -121.002f;
        float lrlat = 35.998f;
        float lrlon = -119.998f;
        short[][] e = dfc.getElevations(ullat, ullon, lrlat, lrlon, 0);
        if (e != null) {
            int i = e[0].length - 1;
            while (i >= 0) {
                int col = 0;
                System.out.print("r" + i + "-");
                int j = 0;
                while (j < e.length) {
                    System.out.print(e[j][i] + " ");
                    ++col;
                    ++j;
                }
                System.out.println(" - " + col);
                --i;
            }
        }
    }

    private static class DTEDCacheObject
    extends CacheObject {
        public DTEDCacheObject(String id, DTEDFrame obj) {
            super(id, obj);
        }

        public void finalize() {
            ((DTEDFrame)this.obj).dispose();
        }
    }
}

