/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.LightMapHandlerChild;
import com.bbn.openmap.gui.ToolPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JMenuItem;

public class ToolPanelToggleMenuItem
extends JMenuItem
implements ActionListener,
LightMapHandlerChild,
ComponentListener {
    protected ToolPanel toolPanel = null;
    protected static final String hideLabel = "Hide Tool Panel";
    protected static final String displayLabel = "Display Tool Panel";

    public ToolPanelToggleMenuItem() {
        super(hideLabel);
        this.init(null);
    }

    public ToolPanelToggleMenuItem(ToolPanel tp) {
        super(tp.isVisible() ? hideLabel : displayLabel);
        this.init(tp);
    }

    public void init(ToolPanel tp) {
        this.setToolPanel(tp);
        this.addActionListener(this);
    }

    public void setToolPanel(ToolPanel tp) {
        if (this.toolPanel != null) {
            this.toolPanel.removeComponentListener(this);
        }
        this.toolPanel = tp;
        this.setVisible(this.toolPanel != null);
        if (this.toolPanel != null) {
            this.toolPanel.addComponentListener(this);
            this.stateCheck();
        }
    }

    public ToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public boolean forToolPanel(ToolPanel tp) {
        return tp == this.toolPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.toolPanel != null) {
            boolean selected = this.toolPanel.isVisible();
            this.toolPanel.setVisible(!selected);
            this.setText(selected ? displayLabel : hideLabel);
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof ToolPanel) {
            this.setToolPanel((ToolPanel)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof ToolPanel && this.getToolPanel() == (ToolPanel)someObj) {
            this.setToolPanel(null);
        }
    }

    public void stateCheck() {
        if (this.toolPanel != null) {
            this.setEnabled(this.toolPanel.areComponentsVisible());
            this.setText(this.toolPanel.isVisible() ? hideLabel : displayLabel);
        }
    }

    public void componentHidden(ComponentEvent ce) {
        this.stateCheck();
    }

    public void componentMoved(ComponentEvent ce) {
    }

    public void componentResized(ComponentEvent ce) {
    }

    public void componentShown(ComponentEvent ce) {
        this.stateCheck();
    }
}

