/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.examples.beanbox;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.examples.beanbox.SimpleBeanContainer;
import com.bbn.openmap.examples.beanbox.SimpleBeanLayer;
import com.bbn.openmap.examples.beanbox.SimpleBeanObject;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.tools.beanbox.BeanLayoutManager;
import java.util.Vector;

public class WallFormationLayout
extends BeanLayoutManager {
    private float separationInNM;
    private float bearingInDeg;

    public WallFormationLayout() {
        this(35.0f, 90.0f, null);
    }

    public WallFormationLayout(float sep, float bearing, SimpleBeanContainer c) {
        this.separationInNM = sep;
        this.bearingInDeg = bearing;
        this._container = c;
    }

    public float getSeparationInNM() {
        return this.separationInNM;
    }

    public void setSeparationInNM(float sep) {
        this.separationInNM = sep;
        this.layoutContainer();
    }

    public float getBearingInDeg() {
        return this.bearingInDeg;
    }

    public void setBearingInDeg(float bearing) {
        if (bearing < 0.0f) {
            bearing = 360.0f - bearing;
        }
        this.bearingInDeg = bearing % 360.0f;
        this.layoutContainer();
    }

    public void layoutContainer() {
        if (this._container == null) {
            return;
        }
        SimpleBeanContainer container = (SimpleBeanContainer)this._container;
        Vector contents = this._container.getContents();
        if (contents == null || contents.size() == 0) {
            return;
        }
        LatLonPoint midllp = new LatLonPoint(container.getLatitude(), container.getLongitude());
        LatLonPoint[] llps = new LatLonPoint[contents.size()];
        if (contents.size() == 1) {
            llps[0] = midllp;
        } else {
            LatLonPoint cornerllp1;
            float angle1Deg = this.bearingInDeg - 90.0f;
            float angle1Rad = (float)((double)angle1Deg * Math.PI / 180.0);
            float angle2Deg = this.bearingInDeg + 90.0f;
            float angle2Rad = (float)((double)angle2Deg * Math.PI / 180.0);
            int numBeans = contents.size();
            float spanNM = (float)(numBeans - 1) * this.separationInNM;
            llps[0] = cornerllp1 = GreatCircle.spherical_between(midllp.radlat_, midllp.radlon_, Length.NM.toRadians(spanNM / 2.0f), angle1Rad);
            int i = 1;
            while (i < contents.size()) {
                llps[i] = GreatCircle.spherical_between(cornerllp1.radlat_, cornerllp1.radlon_, Length.NM.toRadians(this.separationInNM) * (float)i, angle2Rad);
                ++i;
            }
        }
        int i = 0;
        while (i < contents.size()) {
            Long id = (Long)contents.get(i);
            SimpleBeanObject obj = SimpleBeanLayer.getLayer().getObject(id);
            if (obj != null) {
                obj.setLatitude(llps[i].getLatitude());
                obj.setLongitude(llps[i].getLongitude());
                obj.setBearingInDeg(this.bearingInDeg);
            }
            ++i;
        }
        SimpleBeanLayer.getLayer().updateGraphics();
    }
}

