/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.output;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianOutputStream
extends DataOutputStream {
    protected int written;

    public void writeString(String string, int length) throws IOException {
        if (string.length() < length) {
            String newstring = this.zeroFill(string, length);
            byte[] bytes = newstring.getBytes();
            this.out.write(bytes);
        } else {
            String newstring = string.substring(0, length);
            byte[] bytes = newstring.getBytes();
            this.out.write(bytes);
        }
    }

    private String zeroFill(String string, int length) {
        char[] oldchars = string.toCharArray();
        char[] newchars = new char[length];
        int i = 0;
        while (i <= newchars.length - 1) {
            newchars[i] = i <= oldchars.length - 1 ? oldchars[i] : (char)'\u0000';
            ++i;
        }
        return new String(newchars);
    }

    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    public void writeLEShort(short s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeLEChar(int c) throws IOException {
        this.out.write(c & 0xFF);
        this.out.write(c >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeLEInt(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >>> 8 & 0xFF);
        this.out.write(i >>> 16 & 0xFF);
        this.out.write(i >>> 24 & 0xFF);
        this.written += 4;
    }

    public void writeLELong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void writeLEFloat(float f) throws IOException {
        this.writeLEInt(Float.floatToIntBits(f));
    }

    public final void writeLEDouble(double d) throws IOException {
        this.writeLELong(Double.doubleToLongBits(d));
    }

    public void writeLEChars(String s) throws IOException {
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
            ++i;
        }
        this.written += length * 2;
    }

    public void writeLEUTF(String s) throws IOException {
        int numchars = s.length();
        int numbytes = 0;
        int i = 0;
        while (i < numchars) {
            char c = s.charAt(i);
            numbytes = c >= '\u0001' && c <= '\u007f' ? ++numbytes : (c > '\u07ff' ? (numbytes += 3) : (numbytes += 2));
            ++i;
        }
        if (numbytes > 65535) {
            throw new UTFDataFormatException();
        }
        this.out.write(numbytes >>> 8 & 0xFF);
        this.out.write(numbytes & 0xFF);
        int i2 = 0;
        while (i2 < numchars) {
            char c = s.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                this.out.write(c);
            } else if (c > '\u07ff') {
                this.out.write(0xE0 | c >> 12 & 0xF);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0x80 | c & 0x3F);
                this.written += 2;
            } else {
                this.out.write(0xC0 | c >> 6 & 0x1F);
                this.out.write(0x80 | c & 0x3F);
                ++this.written;
            }
            ++i2;
        }
        this.written += numchars + 2;
    }
}

