/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.ShpInputStream;
import com.bbn.openmap.dataAccess.shape.input.ShxInputStream;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;

public abstract class EsriGraphicList
extends OMGraphicList
implements ShapeConstants,
EsriGraphic {
    protected float[] extents;

    public void add(OMGraphic shape) {
        super.add(shape);
    }

    public void addOMGraphic(OMGraphic g) {
        this.add(g);
    }

    public abstract int getType();

    public EsriGraphicList() {
    }

    public EsriGraphicList(int initialCapacity) {
        super(initialCapacity);
    }

    public EsriGraphicList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity);
    }

    public void setExtents(float[] extents) {
        this.extents = extents;
    }

    public float[] getExtents() {
        if (this.extents == null) {
            this.extents = new float[]{90.0f, 180.0f, -90.0f, -180.0f};
        }
        return this.extents;
    }

    public void addExtents(float[] graphicExtents) {
        float[] ex = this.getExtents();
        int i = 0;
        while (i < graphicExtents.length) {
            if (ex[0] > graphicExtents[i]) {
                ex[0] = graphicExtents[i];
            }
            if (ex[1] > graphicExtents[i + 1]) {
                ex[1] = graphicExtents[i + 1];
            }
            if (ex[2] < graphicExtents[i]) {
                ex[2] = graphicExtents[i];
            }
            if (ex[3] < graphicExtents[i + 1]) {
                ex[3] = graphicExtents[i + 1];
            }
            i += 2;
        }
    }

    public void setTable(DbfTableModel dtm) {
        this.setAppObject(dtm);
    }

    public DbfTableModel getTable() {
        Object obj = this.getAppObject();
        if (obj instanceof DbfTableModel) {
            return (DbfTableModel)obj;
        }
        return null;
    }

    public void createTable() {
        DbfTableModel dbfTableModel = new DbfTableModel(5);
    }

    public static EsriGraphicList getEsriGraphicList(URL shp, URL shx, DrawingAttributes drawingAttributes, DbfTableModel dbf) {
        InputStream is;
        EsriGraphicList list = null;
        int[][] indexData = null;
        try {
            is = shx.openStream();
            ShxInputStream xis = new ShxInputStream(is);
            indexData = xis.getIndex();
            is.close();
        }
        catch (Exception e) {
            Debug.error("EsriGraphicList: Unable to stream SHX file");
            if (Debug.debugging("shape")) {
                e.printStackTrace();
            }
            return null;
        }
        try {
            is = shp.openStream();
            ShpInputStream pis = new ShpInputStream(is);
            if (drawingAttributes != null) {
                pis.setDrawingAttributes(drawingAttributes);
            }
            list = pis.getGeometry(indexData);
            is.close();
        }
        catch (Exception e) {
            Debug.error("EsriGraphicList: Not able to stream SHP file");
            if (Debug.debugging("shape")) {
                e.printStackTrace();
            }
            return null;
        }
        if (list != null && dbf != null && dbf.getRowCount() == list.size()) {
            list.setTable(dbf);
            Iterator it = list.iterator();
            int count = 0;
            while (it.hasNext()) {
                OMGraphic graphic = (OMGraphic)it.next();
                graphic.setAppObject(dbf.getRecord(count++));
            }
        }
        return list;
    }
}

